/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.NoSuchRepositoryException;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.model.Repository;
import com.liferay.portal.model.impl.RepositoryImpl;
import com.liferay.portal.model.impl.RepositoryModelImpl;
import com.liferay.portal.service.persistence.RepositoryPersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class RepositoryPersistenceImpl
extends BasePersistenceImpl<Repository>
implements RepositoryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = RepositoryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = String.valueOf(FINDER_CLASS_NAME_ENTITY) + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, RepositoryModelImpl.UUID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
    private static final String _FINDER_COLUMN_UUID_UUID_1 = "repository.uuid IS NULL";
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "repository.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(repository.uuid IS NULL OR repository.uuid = '')";
    public static final FinderPath FINDER_PATH_FETCH_BY_UUID_G = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, RepositoryModelImpl.UUID_COLUMN_BITMASK | RepositoryModelImpl.GROUPID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID_G = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_UUID_G_UUID_1 = "repository.uuid IS NULL AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "repository.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(repository.uuid IS NULL OR repository.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "repository.groupId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID_C = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, RepositoryModelImpl.UUID_COLUMN_BITMASK | RepositoryModelImpl.COMPANYID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID_C = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_UUID_C_UUID_1 = "repository.uuid IS NULL AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "repository.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(repository.uuid IS NULL OR repository.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "repository.companyId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPID = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, RepositoryModelImpl.GROUPID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_GROUPID = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "repository.groupId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_G_N_P = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, RepositoryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByG_N_P", new String[]{Long.class.getName(), String.class.getName(), String.class.getName()}, RepositoryModelImpl.GROUPID_COLUMN_BITMASK | RepositoryModelImpl.NAME_COLUMN_BITMASK | RepositoryModelImpl.PORTLETID_COLUMN_BITMASK);
    public static final FinderPath FINDER_PATH_COUNT_BY_G_N_P = new FinderPath(RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_N_P", new String[]{Long.class.getName(), String.class.getName(), String.class.getName()});
    private static final String _FINDER_COLUMN_G_N_P_GROUPID_2 = "repository.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_N_P_NAME_1 = "repository.name IS NULL AND ";
    private static final String _FINDER_COLUMN_G_N_P_NAME_2 = "repository.name = ? AND ";
    private static final String _FINDER_COLUMN_G_N_P_NAME_3 = "(repository.name IS NULL OR repository.name = '') AND ";
    private static final String _FINDER_COLUMN_G_N_P_PORTLETID_1 = "repository.portletId IS NULL";
    private static final String _FINDER_COLUMN_G_N_P_PORTLETID_2 = "repository.portletId = ?";
    private static final String _FINDER_COLUMN_G_N_P_PORTLETID_3 = "(repository.portletId IS NULL OR repository.portletId = '')";
    private static final String _SQL_SELECT_REPOSITORY = "SELECT repository FROM Repository repository";
    private static final String _SQL_SELECT_REPOSITORY_WHERE = "SELECT repository FROM Repository repository WHERE ";
    private static final String _SQL_COUNT_REPOSITORY = "SELECT COUNT(repository) FROM Repository repository";
    private static final String _SQL_COUNT_REPOSITORY_WHERE = "SELECT COUNT(repository) FROM Repository repository WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "repository.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Repository exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Repository exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = PropsValues.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE;
    private static Log _log = LogFactoryUtil.getLog(RepositoryPersistenceImpl.class);
    private static Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});
    private static Repository _nullRepository = new RepositoryImpl(){

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public CacheModel<Repository> toCacheModel() {
            return _nullRepositoryCacheModel;
        }
    };
    private static CacheModel<Repository> _nullRepositoryCacheModel = new CacheModel<Repository>(){

        public Repository toEntityModel() {
            return _nullRepository;
        }
    };

    public List<Repository> findByUuid(String uuid) throws SystemException {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<Repository> findByUuid(String uuid, int start, int end) throws SystemException {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<Repository> findByUuid(String uuid, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID;
            finderArgs = new Object[]{uuid};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (list != null && !list.isEmpty()) {
            for (Repository repository : list) {
                if (Validator.equals((Object)uuid, (Object)repository.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY repository.repositoryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    if (bindUuid) {
                        qPos.add(uuid);
                    }
                    if (!pagination) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                        list = new UnmodifiableList(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Repository findByUuid_First(String uuid, OrderByComparator orderByComparator) throws NoSuchRepositoryException, SystemException {
        Repository repository = this.fetchByUuid_First(uuid, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    public Repository fetchByUuid_First(String uuid, OrderByComparator orderByComparator) throws SystemException {
        List<Repository> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository findByUuid_Last(String uuid, OrderByComparator orderByComparator) throws NoSuchRepositoryException, SystemException {
        Repository repository = this.fetchByUuid_Last(uuid, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    public Repository fetchByUuid_Last(String uuid, OrderByComparator orderByComparator) throws SystemException {
        int count = this.countByUuid(uuid);
        List<Repository> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository[] findByUuid_PrevAndNext(long repositoryId, String uuid, OrderByComparator orderByComparator) throws NoSuchRepositoryException, SystemException {
        Repository repository = this.findByPrimaryKey(repositoryId);
        Session session = null;
        try {
            session = this.openSession();
            Repository[] array = new RepositoryImpl[]{this.getByUuid_PrevAndNext(session, repository, uuid, orderByComparator, true), repository, this.getByUuid_PrevAndNext(session, repository, uuid, orderByComparator, false)};
            Repository[] repositoryArray = array;
            return repositoryArray;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Repository getByUuid_PrevAndNext(Session session, Repository repository, String uuid, OrderByComparator orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_REPOSITORY_WHERE);
        boolean bindUuid = false;
        if (uuid == null) {
            query.append(_FINDER_COLUMN_UUID_UUID_1);
        } else if (uuid.equals("")) {
            query.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            int i2 = 0;
            while (i2 < orderByConditionFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                    } else {
                        query.append(" <= ? AND ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                } else {
                    query.append(" <= ? ");
                }
                ++i2;
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            int i3 = 0;
            while (i3 < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                    } else {
                        query.append(" DESC, ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                ++i3;
            }
        } else {
            query.append(" ORDER BY repository.repositoryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        if (orderByComparator != null) {
            Object[] values;
            Object[] objectArray = values = orderByComparator.getOrderByConditionValues((Object)repository);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                qPos.add(value);
                ++n2;
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Repository)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) throws SystemException {
        for (Repository repository : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)repository);
        }
    }

    public int countByUuid(String uuid) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    if (bindUuid) {
                        qPos.add(uuid);
                    }
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Repository findByUUID_G(String uuid, long groupId) throws NoSuchRepositoryException, SystemException {
        Repository repository = this.fetchByUUID_G(uuid, groupId);
        if (repository == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("uuid=");
            msg.append(uuid);
            msg.append(", groupId=");
            msg.append(groupId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchRepositoryException(msg.toString());
        }
        return repository;
    }

    public Repository fetchByUUID_G(String uuid, long groupId) throws SystemException {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public Repository fetchByUUID_G(String uuid, long groupId, boolean retrieveFromCache) throws SystemException {
        Repository repository;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_UUID_G, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result instanceof Repository && (!Validator.equals((Object)uuid, (Object)(repository = (Repository)result).getUuid()) || groupId != repository.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("repository.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("repository.uuid = ? AND ");
            }
            query.append("repository.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    if (bindUuid) {
                        qPos.add(uuid);
                    }
                    qPos.add(groupId);
                    List list = q.list();
                    if (list.isEmpty()) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_UUID_G, (Object[])finderArgs, (Object)list);
                    } else {
                        Repository repository2 = (Repository)list.get(0);
                        result = repository2;
                        this.cacheResult(repository2);
                        if (repository2.getUuid() == null || !repository2.getUuid().equals(uuid) || repository2.getGroupId() != groupId) {
                            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_UUID_G, (Object[])finderArgs, (Object)repository2);
                        }
                    }
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_UUID_G, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Repository)result;
    }

    public Repository removeByUUID_G(String uuid, long groupId) throws NoSuchRepositoryException, SystemException {
        Repository repository = this.findByUUID_G(uuid, groupId);
        return (Repository)this.remove((BaseModel)repository);
    }

    public int countByUUID_G(String uuid, long groupId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("repository.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("repository.uuid = ? AND ");
            }
            query.append("repository.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    if (bindUuid) {
                        qPos.add(uuid);
                    }
                    qPos.add(groupId);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Repository> findByUuid_C(String uuid, long companyId) throws SystemException {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<Repository> findByUuid_C(String uuid, long companyId, int start, int end) throws SystemException {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<Repository> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C;
            finderArgs = new Object[]{uuid, companyId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (list != null && !list.isEmpty()) {
            for (Repository repository : list) {
                if (Validator.equals((Object)uuid, (Object)repository.getUuid()) && companyId == repository.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
            query.append(_SQL_SELECT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("repository.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("repository.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY repository.repositoryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    if (bindUuid) {
                        qPos.add(uuid);
                    }
                    qPos.add(companyId);
                    if (!pagination) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                        list = new UnmodifiableList(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Repository findByUuid_C_First(String uuid, long companyId, OrderByComparator orderByComparator) throws NoSuchRepositoryException, SystemException {
        Repository repository = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    public Repository fetchByUuid_C_First(String uuid, long companyId, OrderByComparator orderByComparator) throws SystemException {
        List<Repository> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository findByUuid_C_Last(String uuid, long companyId, OrderByComparator orderByComparator) throws NoSuchRepositoryException, SystemException {
        Repository repository = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    public Repository fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator orderByComparator) throws SystemException {
        int count = this.countByUuid_C(uuid, companyId);
        List<Repository> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository[] findByUuid_C_PrevAndNext(long repositoryId, String uuid, long companyId, OrderByComparator orderByComparator) throws NoSuchRepositoryException, SystemException {
        Repository repository = this.findByPrimaryKey(repositoryId);
        Session session = null;
        try {
            session = this.openSession();
            Repository[] array = new RepositoryImpl[]{this.getByUuid_C_PrevAndNext(session, repository, uuid, companyId, orderByComparator, true), repository, this.getByUuid_C_PrevAndNext(session, repository, uuid, companyId, orderByComparator, false)};
            Repository[] repositoryArray = array;
            return repositoryArray;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Repository getByUuid_C_PrevAndNext(Session session, Repository repository, String uuid, long companyId, OrderByComparator orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_REPOSITORY_WHERE);
        boolean bindUuid = false;
        if (uuid == null) {
            query.append("repository.uuid IS NULL AND ");
        } else if (uuid.equals("")) {
            query.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
        } else {
            bindUuid = true;
            query.append("repository.uuid = ? AND ");
        }
        query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            int i2 = 0;
            while (i2 < orderByConditionFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                    } else {
                        query.append(" <= ? AND ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                } else {
                    query.append(" <= ? ");
                }
                ++i2;
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            int i3 = 0;
            while (i3 < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                    } else {
                        query.append(" DESC, ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                ++i3;
            }
        } else {
            query.append(" ORDER BY repository.repositoryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        qPos.add(companyId);
        if (orderByComparator != null) {
            Object[] values;
            Object[] objectArray = values = orderByComparator.getOrderByConditionValues((Object)repository);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                qPos.add(value);
                ++n2;
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Repository)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) throws SystemException {
        for (Repository repository : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)repository);
        }
    }

    public int countByUuid_C(String uuid, long companyId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_REPOSITORY_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append("repository.uuid IS NULL AND ");
            } else if (uuid.equals("")) {
                query.append("(repository.uuid IS NULL OR repository.uuid = '') AND ");
            } else {
                bindUuid = true;
                query.append("repository.uuid = ? AND ");
            }
            query.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    if (bindUuid) {
                        qPos.add(uuid);
                    }
                    qPos.add(companyId);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Repository> findByGroupId(long groupId) throws SystemException {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<Repository> findByGroupId(long groupId, int start, int end) throws SystemException {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<Repository> findByGroupId(long groupId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID;
            finderArgs = new Object[]{groupId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPID;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (list != null && !list.isEmpty()) {
            for (Repository repository : list) {
                if (groupId == repository.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_REPOSITORY_WHERE);
            query.append("repository.groupId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY repository.repositoryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    if (!pagination) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                        list = new UnmodifiableList(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Repository findByGroupId_First(long groupId, OrderByComparator orderByComparator) throws NoSuchRepositoryException, SystemException {
        Repository repository = this.fetchByGroupId_First(groupId, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    public Repository fetchByGroupId_First(long groupId, OrderByComparator orderByComparator) throws SystemException {
        List<Repository> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository findByGroupId_Last(long groupId, OrderByComparator orderByComparator) throws NoSuchRepositoryException, SystemException {
        Repository repository = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (repository != null) {
            return repository;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchRepositoryException(msg.toString());
    }

    public Repository fetchByGroupId_Last(long groupId, OrderByComparator orderByComparator) throws SystemException {
        int count = this.countByGroupId(groupId);
        List<Repository> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Repository[] findByGroupId_PrevAndNext(long repositoryId, long groupId, OrderByComparator orderByComparator) throws NoSuchRepositoryException, SystemException {
        Repository repository = this.findByPrimaryKey(repositoryId);
        Session session = null;
        try {
            session = this.openSession();
            Repository[] array = new RepositoryImpl[]{this.getByGroupId_PrevAndNext(session, repository, groupId, orderByComparator, true), repository, this.getByGroupId_PrevAndNext(session, repository, groupId, orderByComparator, false)};
            Repository[] repositoryArray = array;
            return repositoryArray;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Repository getByGroupId_PrevAndNext(Session session, Repository repository, long groupId, OrderByComparator orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_REPOSITORY_WHERE);
        query.append("repository.groupId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            int i2 = 0;
            while (i2 < orderByConditionFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i2]);
                if (i2 + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                    } else {
                        query.append(" <= ? AND ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                } else {
                    query.append(" <= ? ");
                }
                ++i2;
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            int i3 = 0;
            while (i3 < orderByFields.length) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i3]);
                if (i3 + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                    } else {
                        query.append(" DESC, ");
                    }
                } else if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
                ++i3;
            }
        } else {
            query.append(" ORDER BY repository.repositoryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        if (orderByComparator != null) {
            Object[] values;
            Object[] objectArray = values = orderByComparator.getOrderByConditionValues((Object)repository);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                qPos.add(value);
                ++n2;
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Repository)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) throws SystemException {
        for (Repository repository : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)repository);
        }
    }

    public int countByGroupId(long groupId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_GROUPID;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_REPOSITORY_WHERE);
            query.append("repository.groupId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Repository findByG_N_P(long groupId, String name, String portletId) throws NoSuchRepositoryException, SystemException {
        Repository repository = this.fetchByG_N_P(groupId, name, portletId);
        if (repository == null) {
            StringBundler msg = new StringBundler(8);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", name=");
            msg.append(name);
            msg.append(", portletId=");
            msg.append(portletId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchRepositoryException(msg.toString());
        }
        return repository;
    }

    public Repository fetchByG_N_P(long groupId, String name, String portletId) throws SystemException {
        return this.fetchByG_N_P(groupId, name, portletId, true);
    }

    public Repository fetchByG_N_P(long groupId, String name, String portletId, boolean retrieveFromCache) throws SystemException {
        Repository repository;
        Object[] finderArgs = new Object[]{groupId, name, portletId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_G_N_P, (Object[])finderArgs, (SessionFactory)this);
        }
        if (!(!(result instanceof Repository) || groupId == (repository = (Repository)result).getGroupId() && Validator.equals((Object)name, (Object)repository.getName()) && Validator.equals((Object)portletId, (Object)repository.getPortletId()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(5);
            query.append(_SQL_SELECT_REPOSITORY_WHERE);
            query.append(_FINDER_COLUMN_G_N_P_GROUPID_2);
            boolean bindName = false;
            if (name == null) {
                query.append(_FINDER_COLUMN_G_N_P_NAME_1);
            } else if (name.equals("")) {
                query.append(_FINDER_COLUMN_G_N_P_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_G_N_P_NAME_2);
            }
            boolean bindPortletId = false;
            if (portletId == null) {
                query.append(_FINDER_COLUMN_G_N_P_PORTLETID_1);
            } else if (portletId.equals("")) {
                query.append(_FINDER_COLUMN_G_N_P_PORTLETID_3);
            } else {
                bindPortletId = true;
                query.append(_FINDER_COLUMN_G_N_P_PORTLETID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    List list;
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    if (bindName) {
                        qPos.add(name);
                    }
                    if (bindPortletId) {
                        qPos.add(portletId);
                    }
                    if ((list = q.list()).isEmpty()) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_N_P, (Object[])finderArgs, (Object)list);
                    } else {
                        Repository repository2 = (Repository)list.get(0);
                        result = repository2;
                        this.cacheResult(repository2);
                        if (repository2.getGroupId() != groupId || repository2.getName() == null || !repository2.getName().equals(name) || repository2.getPortletId() == null || !repository2.getPortletId().equals(portletId)) {
                            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_N_P, (Object[])finderArgs, (Object)repository2);
                        }
                    }
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_G_N_P, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Repository)result;
    }

    public Repository removeByG_N_P(long groupId, String name, String portletId) throws NoSuchRepositoryException, SystemException {
        Repository repository = this.findByG_N_P(groupId, name, portletId);
        return (Repository)this.remove((BaseModel)repository);
    }

    public int countByG_N_P(long groupId, String name, String portletId) throws SystemException {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_G_N_P;
        Object[] finderArgs = new Object[]{groupId, name, portletId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_COUNT_REPOSITORY_WHERE);
            query.append(_FINDER_COLUMN_G_N_P_GROUPID_2);
            boolean bindName = false;
            if (name == null) {
                query.append(_FINDER_COLUMN_G_N_P_NAME_1);
            } else if (name.equals("")) {
                query.append(_FINDER_COLUMN_G_N_P_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_G_N_P_NAME_2);
            }
            boolean bindPortletId = false;
            if (portletId == null) {
                query.append(_FINDER_COLUMN_G_N_P_PORTLETID_1);
            } else if (portletId.equals("")) {
                query.append(_FINDER_COLUMN_G_N_P_PORTLETID_3);
            } else {
                bindPortletId = true;
                query.append(_FINDER_COLUMN_G_N_P_PORTLETID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    QueryPos qPos = QueryPos.getInstance((Query)q);
                    qPos.add(groupId);
                    if (bindName) {
                        qPos.add(name);
                    }
                    if (bindPortletId) {
                        qPos.add(portletId);
                    }
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public void cacheResult(Repository repository) {
        EntityCacheUtil.putResult((boolean)RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, (Serializable)Long.valueOf(repository.getPrimaryKey()), (Serializable)repository);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_UUID_G, (Object[])new Object[]{repository.getUuid(), repository.getGroupId()}, (Object)repository);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_N_P, (Object[])new Object[]{repository.getGroupId(), repository.getName(), repository.getPortletId()}, (Object)repository);
        repository.resetOriginalValues();
    }

    public void cacheResult(List<Repository> repositories) {
        for (Repository repository : repositories) {
            if (EntityCacheUtil.getResult((boolean)RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, (Serializable)Long.valueOf(repository.getPrimaryKey())) == null) {
                this.cacheResult(repository);
                continue;
            }
            repository.resetOriginalValues();
        }
    }

    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear((String)RepositoryImpl.class.getName());
        }
        EntityCacheUtil.clearCache((String)RepositoryImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Repository repository) {
        EntityCacheUtil.removeResult((boolean)RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, (Serializable)Long.valueOf(repository.getPrimaryKey()));
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache(repository);
    }

    public void clearCache(List<Repository> repositories) {
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Repository repository : repositories) {
            EntityCacheUtil.removeResult((boolean)RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, (Serializable)Long.valueOf(repository.getPrimaryKey()));
            this.clearUniqueFindersCache(repository);
        }
    }

    protected void cacheUniqueFindersCache(Repository repository) {
        if (repository.isNew()) {
            Object[] args = new Object[]{repository.getUuid(), repository.getGroupId()};
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_UUID_G, (Object[])args, (Object)1L);
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_UUID_G, (Object[])args, (Object)repository);
            args = new Object[]{repository.getGroupId(), repository.getName(), repository.getPortletId()};
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_G_N_P, (Object[])args, (Object)1L);
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_N_P, (Object[])args, (Object)repository);
        } else {
            Object[] args;
            RepositoryModelImpl repositoryModelImpl = (RepositoryModelImpl)repository;
            if ((repositoryModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_UUID_G.getColumnBitmask()) != 0L) {
                args = new Object[]{repository.getUuid(), repository.getGroupId()};
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_UUID_G, (Object[])args, (Object)1L);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_UUID_G, (Object[])args, (Object)repository);
            }
            if ((repositoryModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_G_N_P.getColumnBitmask()) != 0L) {
                args = new Object[]{repository.getGroupId(), repository.getName(), repository.getPortletId()};
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_G_N_P, (Object[])args, (Object)1L);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_N_P, (Object[])args, (Object)repository);
            }
        }
    }

    protected void clearUniqueFindersCache(Repository repository) {
        RepositoryModelImpl repositoryModelImpl = (RepositoryModelImpl)repository;
        Object[] args = new Object[]{repository.getUuid(), repository.getGroupId()};
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_UUID_G, (Object[])args);
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_UUID_G, (Object[])args);
        if ((repositoryModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_UUID_G.getColumnBitmask()) != 0L) {
            args = new Object[]{repositoryModelImpl.getOriginalUuid(), repositoryModelImpl.getOriginalGroupId()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_UUID_G, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_UUID_G, (Object[])args);
        }
        args = new Object[]{repository.getGroupId(), repository.getName(), repository.getPortletId()};
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_G_N_P, (Object[])args);
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_G_N_P, (Object[])args);
        if ((repositoryModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_G_N_P.getColumnBitmask()) != 0L) {
            args = new Object[]{repositoryModelImpl.getOriginalGroupId(), repositoryModelImpl.getOriginalName(), repositoryModelImpl.getOriginalPortletId()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_G_N_P, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_G_N_P, (Object[])args);
        }
    }

    public Repository create(long repositoryId) {
        RepositoryImpl repository = new RepositoryImpl();
        repository.setNew(true);
        repository.setPrimaryKey(repositoryId);
        String uuid = PortalUUIDUtil.generate();
        repository.setUuid(uuid);
        return repository;
    }

    public Repository remove(long repositoryId) throws NoSuchRepositoryException, SystemException {
        return this.remove(Long.valueOf(repositoryId));
    }

    public Repository remove(Serializable primaryKey) throws NoSuchRepositoryException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            Repository repository = (Repository)session.get(RepositoryImpl.class, primaryKey);
            if (repository == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchRepositoryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Repository repository2 = (Repository)this.remove((BaseModel)repository);
            return repository2;
        }
        catch (NoSuchRepositoryException nsee) {
            throw nsee;
        }
        catch (Exception e2) {
            throw this.processException(e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Repository removeImpl(Repository repository) throws SystemException {
        repository = this.toUnwrappedModel(repository);
        Session session = null;
        try {
            try {
                session = this.openSession();
                if (!session.contains((Object)repository)) {
                    repository = (Repository)session.get(RepositoryImpl.class, repository.getPrimaryKeyObj());
                }
                if (repository != null) {
                    session.delete((Object)repository);
                }
            }
            catch (Exception e2) {
                throw this.processException(e2);
            }
        }
        finally {
            this.closeSession(session);
        }
        if (repository != null) {
            this.clearCache(repository);
        }
        return repository;
    }

    public Repository updateImpl(Repository repository) throws SystemException {
        repository = this.toUnwrappedModel(repository);
        boolean isNew = repository.isNew();
        RepositoryModelImpl repositoryModelImpl = (RepositoryModelImpl)repository;
        if (Validator.isNull((String)repository.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            repository.setUuid(uuid);
        }
        Session session = null;
        try {
            try {
                session = this.openSession();
                if (repository.isNew()) {
                    session.save((Object)repository);
                    repository.setNew(false);
                } else {
                    session.merge((Object)repository);
                }
            }
            catch (Exception e2) {
                throw this.processException(e2);
            }
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew || !RepositoryModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else {
            Object[] args;
            if ((repositoryModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID.getColumnBitmask()) != 0L) {
                args = new Object[]{repositoryModelImpl.getOriginalUuid()};
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_UUID, (Object[])args);
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID, (Object[])args);
                args = new Object[]{repositoryModelImpl.getUuid()};
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_UUID, (Object[])args);
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID, (Object[])args);
            }
            if ((repositoryModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C.getColumnBitmask()) != 0L) {
                args = new Object[]{repositoryModelImpl.getOriginalUuid(), repositoryModelImpl.getOriginalCompanyId()};
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_UUID_C, (Object[])args);
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C, (Object[])args);
                args = new Object[]{repositoryModelImpl.getUuid(), repositoryModelImpl.getCompanyId()};
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_UUID_C, (Object[])args);
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C, (Object[])args);
            }
            if ((repositoryModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID.getColumnBitmask()) != 0L) {
                args = new Object[]{repositoryModelImpl.getOriginalGroupId()};
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_GROUPID, (Object[])args);
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID, (Object[])args);
                args = new Object[]{repositoryModelImpl.getGroupId()};
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_GROUPID, (Object[])args);
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID, (Object[])args);
            }
        }
        EntityCacheUtil.putResult((boolean)RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, (Serializable)Long.valueOf(repository.getPrimaryKey()), (Serializable)repository);
        this.clearUniqueFindersCache(repository);
        this.cacheUniqueFindersCache(repository);
        return repository;
    }

    protected Repository toUnwrappedModel(Repository repository) {
        if (repository instanceof RepositoryImpl) {
            return repository;
        }
        RepositoryImpl repositoryImpl = new RepositoryImpl();
        repositoryImpl.setNew(repository.isNew());
        repositoryImpl.setPrimaryKey(repository.getPrimaryKey());
        repositoryImpl.setUuid(repository.getUuid());
        repositoryImpl.setRepositoryId(repository.getRepositoryId());
        repositoryImpl.setGroupId(repository.getGroupId());
        repositoryImpl.setCompanyId(repository.getCompanyId());
        repositoryImpl.setUserId(repository.getUserId());
        repositoryImpl.setUserName(repository.getUserName());
        repositoryImpl.setCreateDate(repository.getCreateDate());
        repositoryImpl.setModifiedDate(repository.getModifiedDate());
        repositoryImpl.setClassNameId(repository.getClassNameId());
        repositoryImpl.setName(repository.getName());
        repositoryImpl.setDescription(repository.getDescription());
        repositoryImpl.setPortletId(repository.getPortletId());
        repositoryImpl.setTypeSettings(repository.getTypeSettings());
        repositoryImpl.setDlFolderId(repository.getDlFolderId());
        return repositoryImpl;
    }

    public Repository findByPrimaryKey(Serializable primaryKey) throws NoSuchRepositoryException, SystemException {
        Repository repository = this.fetchByPrimaryKey(primaryKey);
        if (repository == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchRepositoryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return repository;
    }

    public Repository findByPrimaryKey(long repositoryId) throws NoSuchRepositoryException, SystemException {
        return this.findByPrimaryKey(Long.valueOf(repositoryId));
    }

    public Repository fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        Repository repository = (Repository)EntityCacheUtil.getResult((boolean)RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, (Serializable)primaryKey);
        if (repository == _nullRepository) {
            return null;
        }
        if (repository == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    repository = (Repository)session.get(RepositoryImpl.class, primaryKey);
                    if (repository != null) {
                        this.cacheResult(repository);
                    } else {
                        EntityCacheUtil.putResult((boolean)RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, (Serializable)primaryKey, (Serializable)_nullRepository);
                    }
                }
                catch (Exception e2) {
                    EntityCacheUtil.removeResult((boolean)RepositoryModelImpl.ENTITY_CACHE_ENABLED, RepositoryImpl.class, (Serializable)primaryKey);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return repository;
    }

    public Repository fetchByPrimaryKey(long repositoryId) throws SystemException {
        return this.fetchByPrimaryKey(Long.valueOf(repositoryId));
    }

    public List<Repository> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<Repository> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<Repository> findAll(int start, int end, OrderByComparator orderByComparator) throws SystemException {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 3);
                query.append(_SQL_SELECT_REPOSITORY);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_REPOSITORY;
                if (pagination) {
                    sql = sql.concat(" ORDER BY repository.repositoryId ASC");
                }
            }
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(sql);
                    if (!pagination) {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                        Collections.sort(list);
                        list = new UnmodifiableList(list);
                    } else {
                        list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)list);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() throws SystemException {
        for (Repository repository : this.findAll()) {
            this.remove((BaseModel)repository);
        }
    }

    public int countAll() throws SystemException {
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                try {
                    session = this.openSession();
                    Query q = session.createQuery(_SQL_COUNT_REPOSITORY);
                    count = (Long)q.uniqueResult();
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (Object)count);
                }
                catch (Exception e2) {
                    FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY);
                    throw this.processException(e2);
                }
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portal.model.Repository")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                String[] stringArray = listenerClassNames;
                int n = listenerClassNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String listenerClassName = stringArray[n2];
                    listenersList.add((ModelListener)InstanceFactory.newInstance((ClassLoader)this.getClassLoader(), (String)listenerClassName));
                    ++n2;
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e2) {
                _log.error((Throwable)e2);
            }
        }
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)RepositoryImpl.class.getName());
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

