/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.permission.RolePermissionUtil;
import com.liferay.portal.service.permission.UserGroupRolePermission;

public class UserGroupRolePermissionImpl
implements UserGroupRolePermission {
    public void check(PermissionChecker permissionChecker, long groupId, long roleId) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, groupId, roleId)) {
            throw new PrincipalException();
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, long roleId) throws PortalException, SystemException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        return permissionChecker.isGroupOwner(groupId) || GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"ASSIGN_USER_ROLES") || OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getOrganizationId(), (String)"ASSIGN_USER_ROLES") || RolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (long)roleId, (String)"ASSIGN_MEMBERS");
    }
}

