/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.WebsiteURLException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.model.Website;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.WebsiteLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import java.util.Date;
import java.util.List;

public class WebsiteLocalServiceImpl
extends WebsiteLocalServiceBaseImpl {
    public Website addWebsite(long userId, String className, long classPK, String url, int typeId, boolean primary) throws PortalException, SystemException {
        return this.addWebsite(userId, className, classPK, url, typeId, primary, new ServiceContext());
    }

    public Website addWebsite(long userId, String className, long classPK, String url, int typeId, boolean primary, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        this.validate(0L, user.getCompanyId(), classNameId, classPK, url, typeId, primary);
        long websiteId = this.counterLocalService.increment();
        Website website = this.websitePersistence.create(websiteId);
        website.setUuid(serviceContext.getUuid());
        website.setCompanyId(user.getCompanyId());
        website.setUserId(user.getUserId());
        website.setUserName(user.getFullName());
        website.setCreateDate(now);
        website.setCreateDate(serviceContext.getCreateDate(now));
        website.setModifiedDate(serviceContext.getModifiedDate(now));
        website.setClassNameId(classNameId);
        website.setClassPK(classPK);
        website.setUrl(url);
        website.setTypeId(typeId);
        website.setPrimary(primary);
        this.websitePersistence.update((BaseModel)website);
        return website;
    }

    public void deleteWebsites(long companyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        List websites = this.websitePersistence.findByC_C_C(companyId, classNameId, classPK);
        for (Website website : websites) {
            this.deleteWebsite(website);
        }
    }

    public Website fetchWebsiteByUuidAndCompanyId(String uuid, long companyId) throws SystemException {
        return this.websitePersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public List<Website> getWebsites() throws SystemException {
        return this.websitePersistence.findAll();
    }

    public List<Website> getWebsites(long companyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.websitePersistence.findByC_C_C(companyId, classNameId, classPK);
    }

    public Website updateWebsite(long websiteId, String url, int typeId, boolean primary) throws PortalException, SystemException {
        this.validate(websiteId, 0L, 0L, 0L, url, typeId, primary);
        Website website = this.websitePersistence.findByPrimaryKey(websiteId);
        website.setModifiedDate(new Date());
        website.setUrl(url);
        website.setTypeId(typeId);
        website.setPrimary(primary);
        this.websitePersistence.update((BaseModel)website);
        return website;
    }

    protected void validate(long websiteId, long companyId, long classNameId, long classPK, boolean primary) throws SystemException {
        if (primary) {
            List websites = this.websitePersistence.findByC_C_C_P(companyId, classNameId, classPK, primary);
            for (Website website : websites) {
                if (websiteId > 0L && website.getWebsiteId() == websiteId) continue;
                website.setPrimary(false);
                this.websitePersistence.update((BaseModel)website);
            }
        }
    }

    protected void validate(long websiteId, long companyId, long classNameId, long classPK, String url, int typeId, boolean primary) throws PortalException, SystemException {
        if (!Validator.isUrl((String)url)) {
            throw new WebsiteURLException();
        }
        if (websiteId > 0L) {
            Website website = this.websitePersistence.findByPrimaryKey(websiteId);
            companyId = website.getCompanyId();
            classNameId = website.getClassNameId();
            classPK = website.getClassPK();
        }
        this.listTypeService.validate(typeId, classNameId, ".website");
        this.validate(websiteId, companyId, classNameId, classPK, primary);
    }
}

