/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.notifications.UserNotificationFeedEntry;
import com.liferay.portal.kernel.notifications.UserNotificationInterpreter;
import com.liferay.portal.model.UserNotificationEvent;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.UserNotificationInterpreterLocalServiceBaseImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UserNotificationInterpreterLocalServiceImpl
extends UserNotificationInterpreterLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(UserNotificationInterpreterLocalServiceImpl.class);
    private Map<String, Map<String, UserNotificationInterpreter>> _userNotificationInterpreters = new HashMap<String, Map<String, UserNotificationInterpreter>>();

    public void addUserNotificationInterpreter(UserNotificationInterpreter userNotificationInterpreter) {
        String selector = userNotificationInterpreter.getSelector();
        Map<String, UserNotificationInterpreter> userNotificationInterpreters = this._userNotificationInterpreters.get(selector);
        if (userNotificationInterpreters == null) {
            userNotificationInterpreters = new HashMap<String, UserNotificationInterpreter>();
            this._userNotificationInterpreters.put(selector, userNotificationInterpreters);
        }
        userNotificationInterpreters.put(userNotificationInterpreter.getPortletId(), userNotificationInterpreter);
    }

    public void deleteUserNotificationInterpreter(UserNotificationInterpreter userNotificationInterpreter) {
        Map<String, UserNotificationInterpreter> userNotificationInterpreters = this._userNotificationInterpreters.get(userNotificationInterpreter.getSelector());
        if (userNotificationInterpreters == null) {
            return;
        }
        this._userNotificationInterpreters.remove(userNotificationInterpreter.getPortletId());
    }

    public Map<String, Map<String, UserNotificationInterpreter>> getUserNotificationInterpreters() {
        return Collections.unmodifiableMap(this._userNotificationInterpreters);
    }

    public UserNotificationFeedEntry interpret(String selector, UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws PortalException {
        Map<String, UserNotificationInterpreter> userNotificationInterpreters = this._userNotificationInterpreters.get(selector);
        if (userNotificationInterpreters == null) {
            return null;
        }
        UserNotificationInterpreter userNotificationInterpreter = userNotificationInterpreters.get(userNotificationEvent.getType());
        if (userNotificationInterpreter == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No interpreter found for " + userNotificationEvent));
            }
            return null;
        }
        return userNotificationInterpreter.interpret(userNotificationEvent, serviceContext);
    }
}

