/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchUserGroupRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.UserGroupRoleLocalServiceBaseImpl;
import com.liferay.portal.service.persistence.UserGroupRolePK;
import java.util.ArrayList;
import java.util.List;

public class UserGroupRoleLocalServiceImpl
extends UserGroupRoleLocalServiceBaseImpl {
    public List<UserGroupRole> addUserGroupRoles(long userId, long groupId, long[] roleIds) throws SystemException {
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        long[] lArray = roleIds;
        int n = roleIds.length;
        int n2 = 0;
        while (n2 < n) {
            long roleId = lArray[n2];
            UserGroupRole userGroupRole = this.addUserGroupRole(userId, groupId, roleId);
            userGroupRoles.add(userGroupRole);
            ++n2;
        }
        PermissionCacheUtil.clearCache();
        return userGroupRoles;
    }

    public List<UserGroupRole> addUserGroupRoles(long[] userIds, long groupId, long roleId) throws SystemException {
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        long[] lArray = userIds;
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userId = lArray[n2];
            UserGroupRole userGroupRole = this.addUserGroupRole(userId, groupId, roleId);
            userGroupRoles.add(userGroupRole);
            ++n2;
        }
        PermissionCacheUtil.clearCache();
        return userGroupRoles;
    }

    @Override
    public UserGroupRole deleteUserGroupRole(UserGroupRole userGroupRole) throws SystemException {
        this.userGroupRolePersistence.remove((BaseModel)userGroupRole);
        PermissionCacheUtil.clearCache();
        return userGroupRole;
    }

    public void deleteUserGroupRoles(long userId, long groupId, long[] roleIds) throws SystemException {
        long[] lArray = roleIds;
        int n = roleIds.length;
        int n2 = 0;
        while (n2 < n) {
            long roleId = lArray[n2];
            UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, roleId);
            try {
                this.userGroupRolePersistence.remove(userGroupRolePK);
            }
            catch (NoSuchUserGroupRoleException noSuchUserGroupRoleException) {}
            ++n2;
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRoles(long userId, long[] groupIds) throws SystemException {
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            this.userGroupRolePersistence.removeByU_G(userId, groupId);
            ++n2;
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRoles(long[] userIds, long groupId) throws SystemException {
        long[] lArray = userIds;
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userId = lArray[n2];
            this.userGroupRolePersistence.removeByU_G(userId, groupId);
            ++n2;
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRoles(long[] userIds, long groupId, int roleType) throws SystemException {
        List roles = this.rolePersistence.findByT_S(roleType, "");
        long[] lArray = userIds;
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userId = lArray[n2];
            for (Role role : roles) {
                UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, role.getRoleId());
                try {
                    this.userGroupRolePersistence.remove(userGroupRolePK);
                }
                catch (NoSuchUserGroupRoleException noSuchUserGroupRoleException) {}
            }
            ++n2;
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRoles(long[] userIds, long groupId, long roleId) throws SystemException {
        long[] lArray = userIds;
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userId = lArray[n2];
            UserGroupRolePK pk = new UserGroupRolePK(userId, groupId, roleId);
            try {
                this.userGroupRolePersistence.remove(pk);
            }
            catch (NoSuchUserGroupRoleException noSuchUserGroupRoleException) {}
            ++n2;
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRolesByGroupId(long groupId) throws SystemException {
        this.userGroupRolePersistence.removeByGroupId(groupId);
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRolesByRoleId(long roleId) throws SystemException {
        this.userGroupRolePersistence.removeByRoleId(roleId);
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRolesByUserId(long userId) throws SystemException {
        this.userGroupRolePersistence.removeByUserId(userId);
        PermissionCacheUtil.clearCache();
    }

    public List<UserGroupRole> getUserGroupRoles(long userId) throws SystemException {
        return this.userGroupRolePersistence.findByUserId(userId);
    }

    public List<UserGroupRole> getUserGroupRoles(long userId, long groupId) throws SystemException {
        return this.userGroupRolePersistence.findByU_G(userId, groupId);
    }

    public List<UserGroupRole> getUserGroupRolesByGroup(long groupId) throws SystemException {
        return this.userGroupRolePersistence.findByGroupId(groupId);
    }

    public List<UserGroupRole> getUserGroupRolesByGroupAndRole(long groupId, long roleId) throws SystemException {
        return this.userGroupRolePersistence.findByG_R(groupId, roleId);
    }

    public List<UserGroupRole> getUserGroupRolesByUserUserGroupAndGroup(long userId, long groupId) throws SystemException {
        return this.userGroupRoleFinder.findByUserUserGroupGroupRole(userId, groupId);
    }

    public boolean hasUserGroupRole(long userId, long groupId, long roleId) throws SystemException {
        return this.hasUserGroupRole(userId, groupId, roleId, false);
    }

    public boolean hasUserGroupRole(long userId, long groupId, long roleId, boolean inherit) throws SystemException {
        UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, roleId);
        UserGroupRole userGroupRole = this.userGroupRolePersistence.fetchByPrimaryKey(userGroupRolePK);
        if (userGroupRole != null) {
            return true;
        }
        return inherit && this.roleFinder.countByU_G_R(userId, groupId, roleId) > 0;
    }

    public boolean hasUserGroupRole(long userId, long groupId, String roleName) throws PortalException, SystemException {
        return this.hasUserGroupRole(userId, groupId, roleName, false);
    }

    public boolean hasUserGroupRole(long userId, long groupId, String roleName, boolean inherit) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long companyId = user.getCompanyId();
        Role role = this.rolePersistence.findByC_N(companyId, roleName);
        long roleId = role.getRoleId();
        return this.hasUserGroupRole(userId, groupId, roleId, inherit);
    }

    protected UserGroupRole addUserGroupRole(long userId, long groupId, long roleId) throws SystemException {
        UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, roleId);
        UserGroupRole userGroupRole = this.userGroupRolePersistence.fetchByPrimaryKey(userGroupRolePK);
        if (userGroupRole == null) {
            userGroupRole = this.userGroupRolePersistence.create(userGroupRolePK);
            this.userGroupRolePersistence.update((BaseModel)userGroupRole);
        }
        return userGroupRole;
    }
}

