/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.DuplicateUserGroupException;
import com.liferay.portal.NoSuchUserGroupException;
import com.liferay.portal.RequiredUserGroupException;
import com.liferay.portal.UserGroupNameException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.ldap.LDAPUserGroupTransactionThreadLocal;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.UserGroupLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UserGroupLocalServiceImpl
extends UserGroupLocalServiceBaseImpl {
    @Override
    public void addGroupUserGroups(long groupId, long[] userGroupIds) throws SystemException {
        this.groupPersistence.addUserGroups(groupId, userGroupIds);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void addTeamUserGroups(long teamId, long[] userGroupIds) throws SystemException {
        this.teamPersistence.addUserGroups(teamId, userGroupIds);
        PermissionCacheUtil.clearCache();
    }

    public UserGroup addUserGroup(long userId, long companyId, String name, String description) throws PortalException, SystemException {
        return this.addUserGroup(userId, companyId, name, description, null);
    }

    public UserGroup addUserGroup(long userId, long companyId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        Date now = new Date();
        this.validate(0L, companyId, name);
        User user = this.userPersistence.findByPrimaryKey(userId);
        long userGroupId = this.counterLocalService.increment();
        UserGroup userGroup = this.userGroupPersistence.create(userGroupId);
        if (serviceContext != null) {
            userGroup.setUuid(serviceContext.getUuid());
        }
        userGroup.setCompanyId(companyId);
        userGroup.setUserId(user.getUserId());
        userGroup.setUserName(user.getFullName());
        if (serviceContext != null) {
            userGroup.setCreateDate(serviceContext.getCreateDate(now));
            userGroup.setModifiedDate(serviceContext.getModifiedDate(now));
        } else {
            userGroup.setCreateDate(now);
            userGroup.setModifiedDate(now);
        }
        userGroup.setParentUserGroupId(0L);
        userGroup.setName(name);
        userGroup.setDescription(description);
        userGroup.setAddedByLDAPImport(LDAPUserGroupTransactionThreadLocal.isOriginatesFromLDAP());
        userGroup.setExpandoBridgeAttributes(serviceContext);
        this.userGroupPersistence.update((BaseModel)userGroup);
        this.groupLocalService.addGroup(userId, 0L, UserGroup.class.getName(), userGroup.getUserGroupId(), 0L, String.valueOf(userGroupId), null, 0, null, false, true, null);
        this.resourceLocalService.addResources(companyId, 0L, userId, UserGroup.class.getName(), userGroup.getUserGroupId(), false, false, false);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(UserGroup.class);
        indexer.reindex((Object)userGroup);
        return userGroup;
    }

    @Override
    public void clearUserUserGroups(long userId) throws SystemException {
        this.userPersistence.clearUserGroups(userId);
        PermissionCacheUtil.clearCache();
    }

    public void copyUserGroupLayouts(long userGroupId, long userId) throws PortalException, SystemException {
        Map<String, String[]> parameterMap = this.getLayoutTemplatesParameters();
        File[] files = this.exportLayouts(userGroupId, parameterMap);
        try {
            this.importLayouts(userId, parameterMap, files[0], files[1]);
        }
        finally {
            if (files[0] != null) {
                files[0].delete();
            }
            if (files[1] != null) {
                files[1].delete();
            }
        }
    }

    public void copyUserGroupLayouts(long userGroupId, long[] userIds) throws PortalException, SystemException {
        Map<String, String[]> parameterMap = this.getLayoutTemplatesParameters();
        File[] files = this.exportLayouts(userGroupId, parameterMap);
        try {
            long[] lArray = userIds;
            int n = userIds.length;
            int n2 = 0;
            while (n2 < n) {
                long userId = lArray[n2];
                if (!this.userGroupPersistence.containsUser(userGroupId, userId)) {
                    this.importLayouts(userId, parameterMap, files[0], files[1]);
                }
                ++n2;
            }
        }
        finally {
            if (files[0] != null) {
                files[0].delete();
            }
            if (files[1] != null) {
                files[1].delete();
            }
        }
    }

    public void copyUserGroupLayouts(long[] userGroupIds, long userId) throws PortalException, SystemException {
        long[] lArray = userGroupIds;
        int n = userGroupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userGroupId = lArray[n2];
            if (!this.userGroupPersistence.containsUser(userGroupId, userId)) {
                this.copyUserGroupLayouts(userGroupId, userId);
            }
            ++n2;
        }
    }

    @Override
    public UserGroup deleteUserGroup(long userGroupId) throws PortalException, SystemException {
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        return this.deleteUserGroup(userGroup);
    }

    @Override
    public UserGroup deleteUserGroup(UserGroup userGroup) throws PortalException, SystemException {
        int count = this.userLocalService.getUserGroupUsersCount(userGroup.getUserGroupId(), 0);
        if (count > 0) {
            throw new RequiredUserGroupException();
        }
        this.expandoValueLocalService.deleteValues(UserGroup.class.getName(), userGroup.getUserGroupId());
        this.clearUserUserGroups(userGroup.getUserGroupId());
        Group group = userGroup.getGroup();
        this.groupLocalService.deleteGroup(group);
        this.userGroupGroupRoleLocalService.deleteUserGroupGroupRolesByUserGroupId(userGroup.getUserGroupId());
        this.resourceLocalService.deleteResource(userGroup.getCompanyId(), UserGroup.class.getName(), 4, userGroup.getUserGroupId());
        this.userGroupPersistence.remove((BaseModel)userGroup);
        PermissionCacheUtil.clearCache();
        return userGroup;
    }

    public void deleteUserGroups(long companyId) throws PortalException, SystemException {
        List userGroups = this.userGroupPersistence.findByCompanyId(companyId);
        for (UserGroup userGroup : userGroups) {
            this.deleteUserGroup(userGroup);
        }
    }

    public UserGroup fetchUserGroup(long companyId, String name) throws SystemException {
        return this.userGroupPersistence.fetchByC_N(companyId, name);
    }

    public UserGroup fetchUserGroupByUuidAndCompanyId(String uuid, long companyId) throws SystemException {
        return this.userGroupPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public UserGroup getUserGroup(long companyId, String name) throws PortalException, SystemException {
        return this.userGroupPersistence.findByC_N(companyId, name);
    }

    public List<UserGroup> getUserGroups(long companyId) throws SystemException {
        return this.userGroupPersistence.findByCompanyId(companyId);
    }

    public List<UserGroup> getUserGroups(long[] userGroupIds) throws PortalException, SystemException {
        ArrayList<UserGroup> userGroups = new ArrayList<UserGroup>(userGroupIds.length);
        long[] lArray = userGroupIds;
        int n = userGroupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userGroupId = lArray[n2];
            UserGroup userGroup = this.getUserGroup(userGroupId);
            userGroups.add(userGroup);
            ++n2;
        }
        return userGroups;
    }

    public List<UserGroup> search(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        return this.userGroupFinder.findByKeywords(companyId, keywords, params, start, end, obc);
    }

    public Hits search(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws SystemException {
        String name = null;
        String description = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            name = keywords;
            description = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.search(companyId, name, description, params, andOperator, start, end, sort);
    }

    public Hits search(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws SystemException {
        try {
            String keywords;
            SearchContext searchContext = new SearchContext();
            searchContext.setAndSearch(andSearch);
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("description", description);
            attributes.put("name", name);
            searchContext.setAttributes(attributes);
            searchContext.setCompanyId(companyId);
            searchContext.setEnd(end);
            if (params != null && Validator.isNotNull((String)(keywords = (String)params.remove("keywords")))) {
                searchContext.setKeywords(keywords);
            }
            QueryConfig queryConfig = new QueryConfig();
            queryConfig.setHighlightEnabled(false);
            queryConfig.setScoreEnabled(false);
            searchContext.setQueryConfig(queryConfig);
            if (sort != null) {
                searchContext.setSorts(new Sort[]{sort});
            }
            searchContext.setStart(start);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(UserGroup.class);
            return indexer.search(searchContext);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public int searchCount(long companyId, String keywords, LinkedHashMap<String, Object> params) throws SystemException {
        return this.userGroupFinder.countByKeywords(companyId, keywords, params);
    }

    @Override
    public void setUserUserGroups(long userId, long[] userGroupIds) throws PortalException, SystemException {
        this.copyUserGroupLayouts(userGroupIds, userId);
        this.userPersistence.setUserGroups(userId, userGroupIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userId);
        PermissionCacheUtil.clearCache();
    }

    public void unsetGroupUserGroups(long groupId, long[] userGroupIds) throws SystemException {
        List teams = this.teamPersistence.findByGroupId(groupId);
        for (Team team : teams) {
            this.teamPersistence.removeUserGroups(team.getTeamId(), userGroupIds);
        }
        this.userGroupGroupRoleLocalService.deleteUserGroupGroupRoles(userGroupIds, groupId);
        this.groupPersistence.removeUserGroups(groupId, userGroupIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetTeamUserGroups(long teamId, long[] userGroupIds) throws SystemException {
        this.teamPersistence.removeUserGroups(teamId, userGroupIds);
        PermissionCacheUtil.clearCache();
    }

    public UserGroup updateUserGroup(long companyId, long userGroupId, String name, String description) throws PortalException, SystemException {
        return this.updateUserGroup(companyId, userGroupId, name, description, null);
    }

    public UserGroup updateUserGroup(long companyId, long userGroupId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        this.validate(userGroupId, companyId, name);
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        userGroup.setModifiedDate(new Date());
        userGroup.setName(name);
        userGroup.setDescription(description);
        userGroup.setExpandoBridgeAttributes(serviceContext);
        this.userGroupPersistence.update((BaseModel)userGroup);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(UserGroup.class);
        indexer.reindex((Object)userGroup);
        return userGroup;
    }

    protected File[] exportLayouts(long userGroupId, Map<String, String[]> parameterMap) throws PortalException, SystemException {
        File[] files = new File[2];
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        Group group = userGroup.getGroup();
        if (userGroup.hasPrivateLayouts()) {
            files[0] = this.layoutLocalService.exportLayoutsAsFile(group.getGroupId(), true, null, parameterMap, null, null);
        }
        if (userGroup.hasPublicLayouts()) {
            files[1] = this.layoutLocalService.exportLayoutsAsFile(group.getGroupId(), false, null, parameterMap, null, null);
        }
        return files;
    }

    protected Map<String, String[]> getLayoutTemplatesParameters() {
        LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
        parameterMap.put("CATEGORIES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("DATA_STRATEGY", new String[]{"DATA_STRATEGY_MIRROR"});
        parameterMap.put("DELETE_MISSING_LAYOUTS", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("DELETE_PORTLET_DATA", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("LAYOUT_SET_SETTINGS", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("LAYOUTS_IMPORT_MODE", new String[]{"CREATED_FROM_PROTOTYPE"});
        parameterMap.put("LOGO", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_SETUP", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_USER_PREFERENCES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLETS_MERGE_MODE", new String[]{"ADD_TO_BOTTOM"});
        parameterMap.put("THEME", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("THEME_REFERENCE", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("UPDATE_LAST_PUBLISH_DATE", new String[]{Boolean.FALSE.toString()});
        parameterMap.put("USER_ID_STRATEGY", new String[]{"CURRENT_USER_ID"});
        return parameterMap;
    }

    protected void importLayouts(long userId, Map<String, String[]> parameterMap, File privateLayoutsFile, File publicLayoutsFile) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = user.getGroup().getGroupId();
        if (privateLayoutsFile != null) {
            this.layoutLocalService.importLayouts(userId, groupId, true, parameterMap, privateLayoutsFile);
        }
        if (publicLayoutsFile != null) {
            this.layoutLocalService.importLayouts(userId, groupId, false, parameterMap, publicLayoutsFile);
        }
    }

    protected void validate(long userGroupId, long companyId, String name) throws PortalException, SystemException {
        if (Validator.isNull((String)name) || name.indexOf(44) != -1 || name.indexOf(42) != -1) {
            throw new UserGroupNameException();
        }
        if (Validator.isNumber((String)name) && !PropsValues.USER_GROUPS_NAME_ALLOW_NUMERIC) {
            throw new UserGroupNameException();
        }
        try {
            UserGroup userGroup = this.userGroupFinder.findByC_N(companyId, name);
            if (userGroup.getUserGroupId() != userGroupId) {
                throw new DuplicateUserGroupException();
            }
        }
        catch (NoSuchUserGroupException noSuchUserGroupException) {}
    }
}

