/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.SystemEvent;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.service.base.SystemEventLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import java.util.Date;
import java.util.List;

public class SystemEventLocalServiceImpl
extends SystemEventLocalServiceBaseImpl {
    public void addSystemEvent(long userId, long groupId, long classNameId, long classPK, String classUuid, int type) throws PortalException, SystemException {
        this.addSystemEvent(userId, groupId, classNameId, classPK, classUuid, type, null);
    }

    public void addSystemEvent(long userId, long groupId, long classNameId, long classPK, String classUuid, int type, String extraData) throws PortalException, SystemException {
        if (userId == 0L) {
            userId = PrincipalThreadLocal.getUserId();
        }
        long companyId = 0L;
        String userName = "";
        if (userId > 0L) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            companyId = user.getCompanyId();
            userName = user.getFullName();
        }
        if (companyId == 0L) {
            if (groupId > 0L) {
                Group group = this.groupPersistence.findByPrimaryKey(groupId);
                companyId = group.getCompanyId();
            } else {
                throw new IllegalArgumentException("Unable to determine company");
            }
        }
        long systemEventId = this.counterLocalService.increment();
        SystemEvent systemEvent = this.systemEventPersistence.create(systemEventId);
        systemEvent.setGroupId(groupId);
        systemEvent.setCompanyId(companyId);
        systemEvent.setUserId(userId);
        systemEvent.setUserName(userName);
        systemEvent.setCreateDate(new Date());
        systemEvent.setClassNameId(classNameId);
        systemEvent.setClassPK(classPK);
        systemEvent.setClassUuid(classUuid);
        systemEvent.setType(type);
        systemEvent.setExtraData(extraData);
        this.systemEventPersistence.update((BaseModel)systemEvent);
    }

    public void addSystemEvent(long groupId, String className, long classPK, String classUuid, int type) throws PortalException, SystemException {
        this.addSystemEvent(0L, groupId, PortalUtil.getClassNameId((String)className), classPK, classUuid, type, null);
    }

    public void deleteSystemEvents(long groupId) throws SystemException {
        this.systemEventPersistence.removeByGroupId(groupId);
    }

    public SystemEvent fetchSystemEvent(long groupId, long classNameId, long classPK, int type) throws SystemException {
        return this.systemEventPersistence.fetchByG_C_C_T_First(groupId, classNameId, classPK, type, null);
    }

    public List<SystemEvent> getSystemEvents(long groupId, long classNameId, long classPK) throws SystemException {
        return this.systemEventPersistence.findByG_C_C(groupId, classNameId, classPK);
    }

    public List<SystemEvent> getSystemEvents(long groupId, long classNameId, long classPK, int type) throws SystemException {
        return this.systemEventPersistence.findByG_C_C_T(groupId, classNameId, classPK, type);
    }
}

