/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchResourcePermissionException;
import com.liferay.portal.kernel.concurrent.LockRegistry;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.ResourceAction;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.base.ResourcePermissionLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.ResourcePermissionsThreadLocal;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class ResourcePermissionLocalServiceImpl
extends ResourcePermissionLocalServiceBaseImpl {
    public static final String[] EMPTY_ACTION_IDS = new String[1];
    private static final String _FIND_MISSING_RESOURCE_PERMISSIONS = String.valueOf(ResourcePermissionLocalServiceImpl.class.getName()) + ".findMissingResourcePermissions";
    private static final String _UPDATE_ACTION_IDS = String.valueOf(ResourcePermissionLocalServiceImpl.class.getName()) + ".updateActionIds";

    public void addResourcePermission(long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException, SystemException {
        if (scope == 1) {
            this.removeResourcePermissions(companyId, name, 2, roleId, actionId);
        } else if (scope == 2) {
            this.removeResourcePermissions(companyId, name, 1, roleId, actionId);
        } else if (scope == 4) {
            throw new NoSuchResourcePermissionException();
        }
        this.updateResourcePermission(companyId, name, scope, primKey, roleId, 0L, new String[]{actionId}, 1);
        PermissionCacheUtil.clearCache();
    }

    public void addResourcePermissions(String resourceName, String roleName, int scope, long resourceActionBitwiseValue) throws SystemException {
        List roles = this.rolePersistence.findByName(roleName);
        if (roles.isEmpty()) {
            return;
        }
        Session session = this.resourcePermissionPersistence.openSession();
        try {
            String sql = CustomSQLUtil.get((String)_UPDATE_ACTION_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$ROLE_ID$]", (String)ListUtil.toString((List)roles, (Accessor)Role.ROLE_ID_ACCESSOR));
            SQLQuery sqlQuery = session.createSQLQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)sqlQuery);
            qPos.add(resourceActionBitwiseValue);
            qPos.add(resourceActionBitwiseValue);
            qPos.add(resourceName);
            qPos.add(scope);
            sqlQuery.executeUpdate();
            sql = CustomSQLUtil.get((String)_FIND_MISSING_RESOURCE_PERMISSIONS);
            sqlQuery = session.createSQLQuery(sql);
            sqlQuery.addScalar("companyId", Type.LONG);
            sqlQuery.addScalar("name", Type.STRING);
            sqlQuery.addScalar("scope", Type.INTEGER);
            sqlQuery.addScalar("primKey", Type.STRING);
            sqlQuery.addScalar("roleId", Type.LONG);
            qPos = QueryPos.getInstance((Query)sqlQuery);
            qPos.add(resourceName);
            qPos.add(scope);
            qPos.add(roleName);
            List resourcePermissionArrays = sqlQuery.list(true);
            if (resourcePermissionArrays.isEmpty()) {
                return;
            }
            try {
                for (Object[] resourcePermissionArray : resourcePermissionArrays) {
                    long resourcePermissionId = this.counterLocalService.increment(ResourcePermission.class.getName());
                    ResourcePermission resourcePermission = this.resourcePermissionPersistence.create(resourcePermissionId);
                    resourcePermission.setCompanyId(((Long)resourcePermissionArray[0]).longValue());
                    resourcePermission.setName((String)resourcePermissionArray[1]);
                    resourcePermission.setScope(((Integer)resourcePermissionArray[2]).intValue());
                    resourcePermission.setPrimKey((String)resourcePermissionArray[3]);
                    resourcePermission.setRoleId(((Long)resourcePermissionArray[4]).longValue());
                    resourcePermission.setActionIds(resourceActionBitwiseValue);
                    session.save((Object)resourcePermission);
                }
            }
            catch (Exception e2) {
                throw new SystemException((Throwable)e2);
            }
        }
        finally {
            this.resourcePermissionPersistence.closeSession(session);
            this.resourcePermissionPersistence.clearCache();
        }
    }

    public void deleteResourcePermissions(long companyId, String name, int scope, long primKey) throws PortalException, SystemException {
        this.deleteResourcePermissions(companyId, name, scope, String.valueOf(primKey));
    }

    public void deleteResourcePermissions(long companyId, String name, int scope, String primKey) throws PortalException, SystemException {
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P(companyId, name, scope, primKey);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            this.deleteResourcePermission(resourcePermission.getResourcePermissionId());
        }
    }

    public List<String> getAvailableResourcePermissionActionIds(long companyId, String name, int scope, String primKey, long roleId, Collection<String> actionIds) throws PortalException, SystemException {
        ResourcePermission resourcePermission = this.resourcePermissionPersistence.fetchByC_N_S_P_R(companyId, name, scope, primKey, roleId);
        if (resourcePermission == null) {
            return Collections.emptyList();
        }
        ArrayList<String> availableActionIds = new ArrayList<String>(actionIds.size());
        for (String actionId : actionIds) {
            ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
            if (!this.hasActionId(resourcePermission, resourceAction)) continue;
            availableActionIds.add(actionId);
        }
        return availableActionIds;
    }

    public Map<Long, Set<String>> getAvailableResourcePermissionActionIds(long companyId, String name, int scope, String primKey, long[] roleIds, Collection<String> actionIds) throws PortalException, SystemException {
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P_R(companyId, name, scope, primKey, roleIds);
        if (resourcePermissions.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<String>> roleIdsToActionIds = new HashMap<Long, Set<String>>();
        for (ResourcePermission resourcePermission : resourcePermissions) {
            long roleId = resourcePermission.getRoleId();
            HashSet<String> availableActionIds = (HashSet<String>)roleIdsToActionIds.get(roleId);
            if (availableActionIds != null) continue;
            availableActionIds = new HashSet<String>();
            roleIdsToActionIds.put(roleId, availableActionIds);
            for (String actionId : actionIds) {
                ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
                if (!this.hasActionId(resourcePermission, resourceAction)) continue;
                availableActionIds.add(actionId);
            }
        }
        return roleIdsToActionIds;
    }

    public ResourcePermission getResourcePermission(long companyId, String name, int scope, String primKey, long roleId) throws PortalException, SystemException {
        return this.resourcePermissionPersistence.findByC_N_S_P_R(companyId, name, scope, primKey, roleId);
    }

    public List<ResourcePermission> getResourcePermissions(long companyId, String name, int scope, String primKey) throws SystemException {
        return this.resourcePermissionPersistence.findByC_N_S_P(companyId, name, scope, primKey);
    }

    public int getResourcePermissionsCount(long companyId, String name, int scope, String primKey) throws SystemException {
        return this.resourcePermissionPersistence.countByC_N_S_P(companyId, name, scope, primKey);
    }

    public List<ResourcePermission> getResourceResourcePermissions(long companyId, long groupId, String name, String primKey) throws SystemException {
        return this.resourcePermissionFinder.findByResource(companyId, groupId, name, primKey);
    }

    public List<ResourcePermission> getRoleResourcePermissions(long roleId) throws SystemException {
        return this.resourcePermissionPersistence.findByRoleId(roleId);
    }

    public List<ResourcePermission> getRoleResourcePermissions(long roleId, int[] scopes, int start, int end) throws SystemException {
        return this.resourcePermissionFinder.findByR_S(roleId, scopes, start, end);
    }

    public List<ResourcePermission> getScopeResourcePermissions(int[] scopes) throws SystemException {
        return this.resourcePermissionPersistence.findByScope(scopes);
    }

    public boolean hasActionId(ResourcePermission resourcePermission, ResourceAction resourceAction) {
        long bitwiseValue;
        long actionIds = resourcePermission.getActionIds();
        return (actionIds & (bitwiseValue = resourceAction.getBitwiseValue())) == bitwiseValue;
    }

    public boolean hasResourcePermission(List<Resource> resources, long[] roleIds, String actionId) throws PortalException, SystemException {
        int i2 = resources.size() - 1;
        while (i2 >= 0) {
            Resource resource = resources.get(i2);
            if (this.hasResourcePermission(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), roleIds, actionId)) {
                return true;
            }
            --i2;
        }
        return false;
    }

    public boolean hasResourcePermission(long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException, SystemException {
        ResourcePermission resourcePermission = this.resourcePermissionPersistence.fetchByC_N_S_P_R(companyId, name, scope, primKey, roleId);
        if (resourcePermission == null) {
            return false;
        }
        ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
        return this.hasActionId(resourcePermission, resourceAction);
    }

    public boolean hasResourcePermission(long companyId, String name, int scope, String primKey, long[] roleIds, String actionId) throws PortalException, SystemException {
        ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        if (!(roleIds.length <= PropsValues.PERMISSIONS_ROLE_RESOURCE_PERMISSION_QUERY_THRESHOLD || dbType.equals("derby") || dbType.equals("jdatastore") || dbType.equals("sap"))) {
            int count = this.resourcePermissionFinder.countByC_N_S_P_R_A(companyId, name, scope, primKey, roleIds, resourceAction.getBitwiseValue());
            if (count > 0) {
                return true;
            }
        } else {
            List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P_R(companyId, name, scope, primKey, roleIds);
            if (resourcePermissions.isEmpty()) {
                return false;
            }
            for (ResourcePermission resourcePermission : resourcePermissions) {
                if (!this.hasActionId(resourcePermission, resourceAction)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean[] hasResourcePermissions(long companyId, String name, int scope, String primKey, long[] roleIds, String actionId) throws PortalException, SystemException {
        ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P_R(companyId, name, scope, primKey, roleIds);
        boolean[] hasResourcePermissions = new boolean[roleIds.length];
        if (resourcePermissions.isEmpty()) {
            return hasResourcePermissions;
        }
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (!this.hasActionId(resourcePermission, resourceAction)) continue;
            long roleId = resourcePermission.getRoleId();
            int i2 = 0;
            while (i2 < roleIds.length) {
                if (roleIds[i2] == roleId) {
                    hasResourcePermissions[i2] = true;
                }
                ++i2;
            }
        }
        return hasResourcePermissions;
    }

    public boolean hasScopeResourcePermission(long companyId, String name, int scope, long roleId, String actionId) throws PortalException, SystemException {
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S(companyId, name, scope);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            if (!this.hasResourcePermission(companyId, name, scope, resourcePermission.getPrimKey(), roleId, actionId)) continue;
            return true;
        }
        return false;
    }

    public void mergePermissions(long fromRoleId, long toRoleId) throws PortalException, SystemException {
        Role fromRole = this.rolePersistence.findByPrimaryKey(fromRoleId);
        Role toRole = this.rolePersistence.findByPrimaryKey(toRoleId);
        if (fromRole.getType() != toRole.getType()) {
            throw new PortalException("Role types are mismatched");
        }
        if (PortalUtil.isSystemRole((String)toRole.getName())) {
            throw new PortalException("Cannot move permissions to system role");
        }
        if (PortalUtil.isSystemRole((String)fromRole.getName())) {
            throw new PortalException("Cannot move permissions from system role");
        }
        List<ResourcePermission> resourcePermissions = this.getRoleResourcePermissions(fromRoleId);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            resourcePermission.setRoleId(toRoleId);
            this.resourcePermissionPersistence.update((BaseModel)resourcePermission);
        }
        this.roleLocalService.deleteRole(fromRoleId);
        PermissionCacheUtil.clearCache();
    }

    public void reassignPermissions(long resourcePermissionId, long toRoleId) throws PortalException, SystemException {
        ResourcePermission resourcePermission = this.getResourcePermission(resourcePermissionId);
        long companyId = resourcePermission.getCompanyId();
        String name = resourcePermission.getName();
        int scope = resourcePermission.getScope();
        String primKey = resourcePermission.getPrimKey();
        long fromRoleId = resourcePermission.getRoleId();
        Role toRole = this.roleLocalService.getRole(toRoleId);
        List actionIds = null;
        actionIds = toRole.getType() == 1 ? ResourceActionsUtil.getModelResourceActions((String)name) : ResourceActionsUtil.getModelResourceGroupDefaultActions((String)name);
        this.setResourcePermissions(companyId, name, scope, primKey, toRoleId, actionIds.toArray(new String[actionIds.size()]));
        this.resourcePermissionPersistence.remove(resourcePermissionId);
        List<ResourcePermission> resourcePermissions = this.getRoleResourcePermissions(fromRoleId);
        if (resourcePermissions.isEmpty()) {
            this.roleLocalService.deleteRole(fromRoleId);
        }
    }

    public void removeResourcePermission(long companyId, String name, int scope, String primKey, long roleId, String actionId) throws PortalException, SystemException {
        this.updateResourcePermission(companyId, name, scope, primKey, roleId, 0L, new String[]{actionId}, 2);
        PermissionCacheUtil.clearCache();
    }

    public void removeResourcePermissions(long companyId, String name, int scope, long roleId, String actionId) throws PortalException, SystemException {
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S(companyId, name, scope);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            this.updateResourcePermission(companyId, name, scope, resourcePermission.getPrimKey(), roleId, 0L, new String[]{actionId}, 2);
        }
        PermissionCacheUtil.clearCache();
    }

    public void setOwnerResourcePermissions(long companyId, String name, int scope, String primKey, long roleId, long ownerId, String[] actionIds) throws PortalException, SystemException {
        this.updateResourcePermission(companyId, name, scope, primKey, roleId, ownerId, actionIds, 3);
    }

    public void setResourcePermissions(long companyId, String name, int scope, String primKey, long roleId, String[] actionIds) throws PortalException, SystemException {
        this.updateResourcePermission(companyId, name, scope, primKey, roleId, 0L, actionIds, 3);
    }

    public void setResourcePermissions(long companyId, String name, int scope, String primKey, Map<Long, String[]> roleIdsToActionIds) throws PortalException, SystemException {
        this.updateResourcePermission(companyId, name, scope, primKey, 0L, roleIdsToActionIds);
    }

    protected void doUpdateResourcePermission(long companyId, String name, int scope, String primKey, long ownerId, long roleId, String[] actionIds, int operator, boolean fetch) throws PortalException, SystemException {
        ResourcePermission resourcePermission = null;
        Map<Long, ResourcePermission> resourcePermissionsMap = ResourcePermissionsThreadLocal.getResourcePermissions();
        if (resourcePermissionsMap != null) {
            resourcePermission = resourcePermissionsMap.get(roleId);
        } else if (fetch) {
            resourcePermission = this.resourcePermissionPersistence.fetchByC_N_S_P_R(companyId, name, scope, primKey, roleId);
        }
        if (resourcePermission == null) {
            if ((operator == 1 || operator == 3) && actionIds.length == 0) {
                return;
            }
            if (operator == 2) {
                return;
            }
            long resourcePermissionId = this.counterLocalService.increment(ResourcePermission.class.getName());
            resourcePermission = this.resourcePermissionPersistence.create(resourcePermissionId);
            resourcePermission.setCompanyId(companyId);
            resourcePermission.setName(name);
            resourcePermission.setScope(scope);
            resourcePermission.setPrimKey(primKey);
            resourcePermission.setRoleId(roleId);
            resourcePermission.setOwnerId(ownerId);
        }
        long actionIdsLong = resourcePermission.getActionIds();
        if (operator == 3) {
            actionIdsLong = 0L;
        }
        String[] stringArray = actionIds;
        int n = actionIds.length;
        int n2 = 0;
        while (n2 < n) {
            String actionId = stringArray[n2];
            if (actionId == null) break;
            ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
            actionIdsLong = operator == 1 || operator == 3 ? (actionIdsLong |= resourceAction.getBitwiseValue()) : (actionIdsLong &= resourceAction.getBitwiseValue() ^ 0xFFFFFFFFFFFFFFFFL);
            ++n2;
        }
        resourcePermission.setActionIds(actionIdsLong);
        this.resourcePermissionPersistence.update((BaseModel)resourcePermission);
        PermissionCacheUtil.clearCache();
        SearchEngineUtil.updatePermissionFields((String)name, (String)primKey);
    }

    protected void doUpdateResourcePermission(long companyId, String name, int scope, String primKey, long ownerId, Map<Long, String[]> roleIdsToActionIds) throws PortalException, SystemException {
        boolean flushEnabled = PermissionThreadLocal.isFlushEnabled();
        PermissionThreadLocal.setIndexEnabled((boolean)false);
        try {
            String[] actionIds;
            long roleId;
            long[] roleIds = ArrayUtil.toLongArray(roleIdsToActionIds.keySet());
            List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P_R(companyId, name, scope, primKey, roleIds);
            for (ResourcePermission resourcePermission : resourcePermissions) {
                roleId = resourcePermission.getRoleId();
                actionIds = roleIdsToActionIds.remove(roleId);
                this.doUpdateResourcePermission(companyId, name, scope, primKey, ownerId, roleId, actionIds, 3, true);
            }
            if (roleIdsToActionIds.isEmpty()) {
                return;
            }
            for (Map.Entry entry : roleIdsToActionIds.entrySet()) {
                roleId = (Long)entry.getKey();
                actionIds = (String[])entry.getValue();
                this.doUpdateResourcePermission(companyId, name, scope, primKey, ownerId, roleId, actionIds, 3, false);
            }
        }
        finally {
            PermissionThreadLocal.setIndexEnabled((boolean)flushEnabled);
            PermissionCacheUtil.clearCache();
            SearchEngineUtil.updatePermissionFields((String)name, (String)primKey);
        }
    }

    protected void updateResourcePermission(long companyId, String name, int scope, String primKey, long roleId, long ownerId, String[] actionIds, int operator) throws PortalException, SystemException {
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        if (!dbType.equals("hypersonic")) {
            this.doUpdateResourcePermission(companyId, name, scope, primKey, ownerId, roleId, actionIds, operator, true);
            return;
        }
        StringBundler sb = new StringBundler(9);
        sb.append(companyId);
        sb.append("#");
        sb.append(name);
        sb.append("#");
        sb.append(scope);
        sb.append("#");
        sb.append(primKey);
        sb.append("#");
        sb.append(roleId);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String groupName = clazz.getName();
        String key = sb.toString();
        ReentrantLock lock = LockRegistry.allocateLock((String)groupName, (String)key);
        lock.lock();
        try {
            this.doUpdateResourcePermission(companyId, name, scope, primKey, ownerId, roleId, actionIds, operator, true);
        }
        finally {
            lock.unlock();
            LockRegistry.freeLock((String)groupName, (String)key);
        }
    }

    protected void updateResourcePermission(long companyId, String name, int scope, String primKey, long ownerId, Map<Long, String[]> roleIdsToActionIds) throws PortalException, SystemException {
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        if (!dbType.equals("hypersonic")) {
            this.doUpdateResourcePermission(companyId, name, scope, primKey, ownerId, roleIdsToActionIds);
            return;
        }
        StringBundler sb = new StringBundler(9);
        sb.append(companyId);
        sb.append("#");
        sb.append(name);
        sb.append("#");
        sb.append(scope);
        sb.append("#");
        sb.append(primKey);
        sb.append("#");
        sb.append(StringUtil.merge(roleIdsToActionIds.keySet()));
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String groupName = clazz.getName();
        String key = sb.toString();
        ReentrantLock lock = LockRegistry.allocateLock((String)groupName, (String)key);
        lock.lock();
        try {
            this.doUpdateResourcePermission(companyId, name, scope, primKey, ownerId, roleIdsToActionIds);
        }
        finally {
            lock.unlock();
            LockRegistry.freeLock((String)groupName, (String)key);
        }
    }
}

