/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.ResourceActionsException;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.GroupedModel;
import com.liferay.portal.model.PermissionedModel;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.impl.ResourceImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.ResourceLocalServiceBaseImpl;
import com.liferay.portal.util.ResourcePermissionsThreadLocal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.time.StopWatch;

public class ResourceLocalServiceImpl
extends ResourceLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(ResourceLocalServiceImpl.class);

    public void addModelResources(AuditedModel auditedModel, ServiceContext serviceContext) throws PortalException, SystemException {
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addResources(auditedModel.getCompanyId(), this.getGroupId(auditedModel), auditedModel.getUserId(), auditedModel.getModelClassName(), String.valueOf(auditedModel.getPrimaryKeyObj()), false, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions(), this.getPermissionedModel(auditedModel));
        } else {
            if (serviceContext.isDeriveDefaultPermissions()) {
                serviceContext.deriveDefaultPermissions(this.getGroupId(auditedModel), auditedModel.getModelClassName());
            }
            this.addModelResources(auditedModel.getCompanyId(), this.getGroupId(auditedModel), auditedModel.getUserId(), auditedModel.getModelClassName(), String.valueOf(auditedModel.getPrimaryKeyObj()), serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions(), this.getPermissionedModel(auditedModel));
        }
    }

    public void addModelResources(long companyId, long groupId, long userId, String name, long primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.addModelResources(companyId, groupId, userId, name, String.valueOf(primKey), groupPermissions, guestPermissions, null);
    }

    public void addModelResources(long companyId, long groupId, long userId, String name, String primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.addModelResources(companyId, groupId, userId, name, primKey, groupPermissions, guestPermissions, null);
    }

    public void addResources(long companyId, long groupId, long userId, String name, long primKey, boolean portletActions, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.addResources(companyId, groupId, userId, name, String.valueOf(primKey), portletActions, addGroupPermissions, addGuestPermissions, null);
    }

    public void addResources(long companyId, long groupId, long userId, String name, String primKey, boolean portletActions, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.addResources(companyId, groupId, userId, name, primKey, portletActions, addGroupPermissions, addGuestPermissions, null);
    }

    public void addResources(long companyId, long groupId, String name, boolean portletActions) throws PortalException, SystemException {
        this.addResources(companyId, groupId, 0L, name, null, portletActions, false, false);
    }

    public void deleteResource(AuditedModel auditedModel, int scope) throws PortalException, SystemException {
        this.deleteResource(auditedModel.getCompanyId(), auditedModel.getModelClassName(), scope, String.valueOf(auditedModel.getPrimaryKeyObj()), this.getPermissionedModel(auditedModel));
    }

    public void deleteResource(long companyId, String name, int scope, long primKey) throws PortalException, SystemException {
        this.deleteResource(companyId, name, scope, String.valueOf(primKey), null);
    }

    public void deleteResource(long companyId, String name, int scope, String primKey) throws PortalException, SystemException {
        this.deleteResource(companyId, name, scope, primKey, null);
    }

    public Resource getResource(long companyId, String name, int scope, String primKey) {
        ResourceImpl resource = new ResourceImpl();
        resource.setCompanyId(companyId);
        resource.setName(name);
        resource.setScope(scope);
        resource.setPrimKey(primKey);
        return resource;
    }

    public boolean hasUserPermissions(long userId, long resourceId, List<Resource> resources, String actionId, long[] roleIds) throws PortalException, SystemException {
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        int block = 1;
        boolean hasUserPermissions = this.resourcePermissionLocalService.hasResourcePermission(resources, roleIds, actionId);
        this.logHasUserPermissions(userId, resourceId, actionId, stopWatch, block++);
        return hasUserPermissions;
    }

    public void updateModelResources(AuditedModel auditedModel, ServiceContext serviceContext) throws PortalException, SystemException {
        this.updateResources(auditedModel.getCompanyId(), this.getGroupId(auditedModel), auditedModel.getModelClassName(), String.valueOf(auditedModel.getPrimaryKeyObj()), serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions(), this.getPermissionedModel(auditedModel));
    }

    public void updateResources(long companyId, long groupId, String name, long primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.updateResources(companyId, groupId, name, String.valueOf(primKey), groupPermissions, guestPermissions, null);
    }

    public void updateResources(long companyId, long groupId, String name, String primKey, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.updateResources(companyId, groupId, name, primKey, groupPermissions, guestPermissions, null);
    }

    public void updateResources(long companyId, String name, int scope, String primKey, String newPrimKey) throws SystemException {
        if (!this.resourceBlockLocalService.isSupported(name)) {
            this.updateResourcePermissions(companyId, name, scope, primKey, newPrimKey);
        }
    }

    protected void addGroupPermissions(long companyId, long groupId, long userId, String name, Resource resource, boolean portletActions, PermissionedModel permissionedModel) throws PortalException, SystemException {
        List actions = null;
        actions = portletActions ? ResourceActionsUtil.getPortletResourceGroupDefaultActions((String)name) : ResourceActionsUtil.getModelResourceGroupDefaultActions((String)name);
        String[] actionIds = actions.toArray(new String[actions.size()]);
        if (this.resourceBlockLocalService.isSupported(name)) {
            this.addGroupPermissionsBlocks(groupId, resource, actions, permissionedModel);
        } else {
            this.addGroupPermissions(groupId, resource, actionIds);
        }
    }

    protected void addGroupPermissions(long groupId, Resource resource, String[] actionIds) throws PortalException, SystemException {
        Role role = this.roleLocalService.getDefaultGroupRole(groupId);
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), actionIds);
    }

    protected void addGroupPermissionsBlocks(long groupId, Resource resource, List<String> actionIds, PermissionedModel permissionedModel) throws PortalException, SystemException {
        if (permissionedModel == null) {
            throw new IllegalArgumentException("Permissioned model is null");
        }
        Role role = this.roleLocalService.getDefaultGroupRole(groupId);
        this.resourceBlockLocalService.setIndividualScopePermissions(resource.getCompanyId(), groupId, resource.getName(), permissionedModel, role.getRoleId(), actionIds);
    }

    protected void addGuestPermissions(long companyId, long groupId, long userId, String name, Resource resource, boolean portletActions, PermissionedModel permissionedModel) throws PortalException, SystemException {
        List actions = null;
        actions = portletActions ? ResourceActionsUtil.getPortletResourceGuestDefaultActions((String)name) : ResourceActionsUtil.getModelResourceGuestDefaultActions((String)name);
        String[] actionIds = actions.toArray(new String[actions.size()]);
        if (this.resourceBlockLocalService.isSupported(name)) {
            this.addGuestPermissionsBlocks(companyId, groupId, resource, actions, permissionedModel);
        } else {
            this.addGuestPermissions(companyId, resource, actionIds);
        }
    }

    protected void addGuestPermissions(long companyId, Resource resource, String[] actionIds) throws PortalException, SystemException {
        Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), guestRole.getRoleId(), actionIds);
    }

    protected void addGuestPermissionsBlocks(long companyId, long groupId, Resource resource, List<String> actionIds, PermissionedModel permissionedModel) throws PortalException, SystemException {
        if (permissionedModel == null) {
            throw new IllegalArgumentException("Permissioned model is null");
        }
        Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
        this.resourceBlockLocalService.setIndividualScopePermissions(resource.getCompanyId(), groupId, resource.getName(), permissionedModel, guestRole.getRoleId(), actionIds);
    }

    protected void addModelResources(long companyId, long groupId, long userId, Resource resource, String[] groupPermissions, String[] guestPermissions, PermissionedModel permissionedModel) throws PortalException, SystemException {
        Role ownerRole = this.roleLocalService.getRole(companyId, "Owner");
        List ownerActionIds = ResourceActionsUtil.getModelResourceActions((String)resource.getName());
        ownerActionIds = ListUtil.copy((List)ownerActionIds);
        this.filterOwnerActions(resource.getName(), ownerActionIds);
        String[] ownerPermissions = ownerActionIds.toArray(new String[ownerActionIds.size()]);
        Role defaultGroupRole = null;
        if (groupId > 0L) {
            defaultGroupRole = this.roleLocalService.getDefaultGroupRole(groupId);
            if (groupPermissions == null) {
                groupPermissions = new String[]{};
            }
        }
        Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
        if (guestPermissions == null) {
            guestPermissions = new String[]{};
        }
        if (this.resourceBlockLocalService.isSupported(resource.getName())) {
            if (permissionedModel == null) {
                throw new IllegalArgumentException("Permissioned model is null");
            }
            this.resourceBlockLocalService.setIndividualScopePermissions(resource.getCompanyId(), groupId, resource.getName(), permissionedModel, ownerRole.getRoleId(), ownerActionIds);
            if (groupId > 0L) {
                this.resourceBlockLocalService.setIndividualScopePermissions(resource.getCompanyId(), groupId, resource.getName(), permissionedModel, defaultGroupRole.getRoleId(), Arrays.asList(groupPermissions));
            }
            this.resourceBlockLocalService.setIndividualScopePermissions(resource.getCompanyId(), groupId, resource.getName(), permissionedModel, guestRole.getRoleId(), Arrays.asList(guestPermissions));
        } else {
            this.resourcePermissionLocalService.setOwnerResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), ownerRole.getRoleId(), userId, ownerPermissions);
            if (groupId > 0L) {
                this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), defaultGroupRole.getRoleId(), groupPermissions);
            }
            this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), guestRole.getRoleId(), guestPermissions);
        }
    }

    protected void addModelResources(long companyId, long groupId, long userId, String name, String primKey, String[] groupPermissions, String[] guestPermissions, PermissionedModel permissionedModel) throws PortalException, SystemException {
        if (!PermissionThreadLocal.isAddResource()) {
            return;
        }
        this.validate(name, false);
        if (primKey == null) {
            return;
        }
        Resource resource = this.getResource(companyId, name, 4, primKey);
        boolean flushEnabled = PermissionThreadLocal.isFlushEnabled();
        PermissionThreadLocal.setIndexEnabled((boolean)false);
        try {
            this.addModelResources(companyId, groupId, userId, resource, groupPermissions, guestPermissions, permissionedModel);
        }
        finally {
            PermissionThreadLocal.setIndexEnabled((boolean)flushEnabled);
            PermissionCacheUtil.clearCache();
            SearchEngineUtil.updatePermissionFields((String)name, (String)primKey);
        }
    }

    protected void addResources(long companyId, long groupId, long userId, Resource resource, boolean portletActions, PermissionedModel permissionedModel) throws PortalException, SystemException {
        List actionIds = null;
        if (portletActions) {
            actionIds = ResourceActionsUtil.getPortletResourceActions((String)resource.getName());
        } else {
            actionIds = ResourceActionsUtil.getModelResourceActions((String)resource.getName());
            actionIds = ListUtil.copy((List)actionIds);
            this.filterOwnerActions(resource.getName(), actionIds);
        }
        Role role = this.roleLocalService.getRole(companyId, "Owner");
        if (this.resourceBlockLocalService.isSupported(resource.getName())) {
            if (permissionedModel == null) {
                throw new IllegalArgumentException("Permissioned model is null");
            }
            this.resourceBlockLocalService.setIndividualScopePermissions(resource.getCompanyId(), groupId, resource.getName(), permissionedModel, role.getRoleId(), actionIds);
        } else {
            this.resourcePermissionLocalService.setOwnerResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), userId, actionIds.toArray(new String[actionIds.size()]));
        }
    }

    protected void addResources(long companyId, long groupId, long userId, String name, String primKey, boolean portletActions, boolean addGroupPermissions, boolean addGuestPermissions, PermissionedModel permissionedModel) throws PortalException, SystemException {
        if (!PermissionThreadLocal.isAddResource()) {
            return;
        }
        this.validate(name, portletActions);
        if (primKey == null) {
            return;
        }
        Resource resource = this.getResource(companyId, name, 4, primKey);
        boolean flushEnabled = PermissionThreadLocal.isFlushEnabled();
        PermissionThreadLocal.setIndexEnabled((boolean)false);
        List resourcePermissions = this.resourcePermissionPersistence.findByC_N_S_P(companyId, name, 4, primKey);
        ResourcePermissionsThreadLocal.setResourcePermissions(resourcePermissions);
        try {
            this.addResources(companyId, groupId, userId, resource, portletActions, permissionedModel);
            if (groupId > 0L && addGroupPermissions) {
                this.addGroupPermissions(companyId, groupId, userId, name, resource, portletActions, permissionedModel);
            }
            if (addGuestPermissions) {
                this.addGuestPermissions(companyId, groupId, userId, name, resource, portletActions, permissionedModel);
            }
        }
        finally {
            ResourcePermissionsThreadLocal.setResourcePermissions(null);
            PermissionThreadLocal.setIndexEnabled((boolean)flushEnabled);
            PermissionCacheUtil.clearCache();
            SearchEngineUtil.updatePermissionFields((String)name, (String)primKey);
        }
    }

    protected void deleteResource(long companyId, String name, int scope, String primKey, PermissionedModel permissionedModel) throws PortalException, SystemException {
        if (this.resourceBlockLocalService.isSupported(name)) {
            if (permissionedModel == null) {
                throw new IllegalArgumentException("Permissioned model is null");
            }
            this.resourceBlockLocalService.releasePermissionedModelResourceBlock(permissionedModel);
            return;
        }
        this.resourcePermissionLocalService.deleteResourcePermissions(companyId, name, scope, primKey);
    }

    protected void filterOwnerActions(String name, List<String> actionIds) {
        List defaultOwnerActions = ResourceActionsUtil.getModelResourceOwnerDefaultActions((String)name);
        if (defaultOwnerActions.isEmpty()) {
            return;
        }
        Iterator<String> itr = actionIds.iterator();
        while (itr.hasNext()) {
            String actionId = itr.next();
            if (defaultOwnerActions.contains(actionId)) continue;
            itr.remove();
        }
    }

    protected long getGroupId(AuditedModel auditedModel) {
        long groupId = 0L;
        if (auditedModel instanceof GroupedModel) {
            GroupedModel groupedModel = (GroupedModel)auditedModel;
            groupId = BeanPropertiesUtil.getLongSilent((Object)groupedModel, (String)"resourceGroupId", (long)groupedModel.getGroupId());
        }
        return groupId;
    }

    protected PermissionedModel getPermissionedModel(AuditedModel auditedModel) {
        PermissionedModel permissionedModel = null;
        if (auditedModel instanceof PermissionedModel) {
            permissionedModel = (PermissionedModel)auditedModel;
        }
        return permissionedModel;
    }

    protected void logHasUserPermissions(long userId, long resourceId, String actionId, StopWatch stopWatch, int block) {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Checking user permissions block " + block + " for " + userId + " " + resourceId + " " + actionId + " takes " + stopWatch.getTime() + " ms"));
    }

    protected void updateResourceBlocks(long companyId, long groupId, Resource resource, String[] groupPermissions, String[] guestPermissions, PermissionedModel permissionedModel) throws PortalException, SystemException {
        if (permissionedModel == null) {
            throw new IllegalArgumentException("Permissioned model is null");
        }
        Role role = this.roleLocalService.getDefaultGroupRole(groupId);
        this.resourceBlockLocalService.setIndividualScopePermissions(companyId, groupId, resource.getName(), permissionedModel, role.getRoleId(), Arrays.asList(groupPermissions));
        role = this.roleLocalService.getRole(companyId, "Guest");
        this.resourceBlockLocalService.setIndividualScopePermissions(companyId, groupId, resource.getName(), permissionedModel, role.getRoleId(), Arrays.asList(guestPermissions));
    }

    protected void updateResourcePermissions(long companyId, long groupId, Resource resource, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        Role role = this.roleLocalService.getDefaultGroupRole(groupId);
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), groupPermissions);
        role = this.roleLocalService.getRole(companyId, "Guest");
        this.resourcePermissionLocalService.setResourcePermissions(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), guestPermissions);
    }

    protected void updateResourcePermissions(long companyId, String name, int scope, String primKey, String newPrimKey) throws SystemException {
        List resourcePermissions = this.resourcePermissionLocalService.getResourcePermissions(companyId, name, scope, primKey);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            resourcePermission.setPrimKey(newPrimKey);
            this.resourcePermissionPersistence.update((BaseModel)resourcePermission);
        }
    }

    protected void updateResources(long companyId, long groupId, String name, String primKey, String[] groupPermissions, String[] guestPermissions, PermissionedModel permissionedModel) throws PortalException, SystemException {
        Resource resource = this.getResource(companyId, name, 4, primKey);
        if (groupPermissions == null) {
            groupPermissions = new String[]{};
        }
        if (guestPermissions == null) {
            guestPermissions = new String[]{};
        }
        if (this.resourceBlockLocalService.isSupported(name)) {
            this.updateResourceBlocks(companyId, groupId, resource, groupPermissions, guestPermissions, permissionedModel);
        } else {
            this.updateResourcePermissions(companyId, groupId, resource, groupPermissions, guestPermissions);
        }
    }

    protected void validate(String name, boolean portletActions) throws PortalException {
        List actions = null;
        actions = portletActions ? ResourceActionsUtil.getPortletResourceActions((String)name) : ResourceActionsUtil.getModelResourceActions((String)name);
        if (actions.size() == 0) {
            throw new ResourceActionsException("There are no actions associated with the resource " + name);
        }
    }
}

