/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.RepositoryEntry;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.RepositoryEntryLocalServiceBaseImpl;
import java.util.Date;

public class RepositoryEntryLocalServiceImpl
extends RepositoryEntryLocalServiceBaseImpl {
    public RepositoryEntry addRepositoryEntry(long userId, long groupId, long repositoryId, String mappedId, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        long repositoryEntryId = this.counterLocalService.increment();
        RepositoryEntry repositoryEntry = this.repositoryEntryPersistence.create(repositoryEntryId);
        repositoryEntry.setUuid(serviceContext.getUuid());
        repositoryEntry.setGroupId(groupId);
        repositoryEntry.setCompanyId(user.getCompanyId());
        repositoryEntry.setUserId(userId);
        repositoryEntry.setUserName(user.getFullName());
        repositoryEntry.setCreateDate(serviceContext.getCreateDate(now));
        repositoryEntry.setModifiedDate(serviceContext.getModifiedDate(now));
        repositoryEntry.setRepositoryId(repositoryId);
        repositoryEntry.setMappedId(mappedId);
        this.repositoryEntryPersistence.update((BaseModel)repositoryEntry);
        return repositoryEntry;
    }

    public RepositoryEntry updateRepositoryEntry(long repositoryEntryId, String mappedId) throws PortalException, SystemException {
        RepositoryEntry repositoryEntry = this.repositoryEntryPersistence.findByPrimaryKey(repositoryEntryId);
        repositoryEntry.setModifiedDate(new Date());
        repositoryEntry.setMappedId(mappedId);
        this.repositoryEntryPersistence.update((BaseModel)repositoryEntry);
        return repositoryEntry;
    }
}

