/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchReleaseException;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Release;
import com.liferay.portal.service.base.ReleaseLocalServiceBaseImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;

public class ReleaseLocalServiceImpl
extends ReleaseLocalServiceBaseImpl {
    private static final String _GET_BUILD_NUMBER = "select buildNumber from Release_ where releaseId = ?";
    private static final String _TEST_DATABASE_STRING_CASE_SENSITIVITY = "select count(*) from Release_ where releaseId = ? and testString = ?";
    private static Log _log = LogFactoryUtil.getLog(ReleaseLocalServiceImpl.class);

    public Release addRelease(String servletContextName, int buildNumber) throws SystemException {
        Release release = null;
        if (servletContextName.equals("portal")) {
            release = this.releasePersistence.create(1L);
        } else {
            long releaseId = this.counterLocalService.increment();
            release = this.releasePersistence.create(releaseId);
        }
        Date now = new Date();
        release.setCreateDate(now);
        release.setModifiedDate(now);
        release.setServletContextName(servletContextName);
        release.setBuildNumber(buildNumber);
        if (servletContextName.equals("portal")) {
            release.setTestString("You take the blue pill, the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill, you stay in Wonderland, and I show you how deep the rabbit hole goes.");
        }
        this.releasePersistence.update((BaseModel)release);
        return release;
    }

    public void createTablesAndPopulate() throws SystemException {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Create tables and populate with default data");
            }
            DB db = DBFactoryUtil.getDB();
            db.runSQLTemplate("portal-tables.sql", false);
            db.runSQLTemplate("portal-data-common.sql", false);
            db.runSQLTemplate("portal-data-counter.sql", false);
            if (!PropsValues.SCHEMA_RUN_MINIMAL && !ShardUtil.isEnabled()) {
                db.runSQLTemplate("portal-data-sample.vm", false);
            }
            db.runSQLTemplate("portal-data-release.sql", false);
            db.runSQLTemplate("indexes.sql", false);
            db.runSQLTemplate("sequences.sql", false);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new SystemException((Throwable)e2);
        }
    }

    public Release fetchRelease(String servletContextName) throws SystemException {
        if (Validator.isNull((String)servletContextName)) {
            throw new IllegalArgumentException("Servlet context name is null");
        }
        Release release = null;
        release = servletContextName.equals("portal") ? this.releasePersistence.fetchByPrimaryKey(1L) : this.releasePersistence.fetchByServletContextName(servletContextName);
        return release;
    }

    public int getBuildNumberOrCreate() throws PortalException, SystemException {
        block12: {
            ResultSet rs;
            PreparedStatement ps;
            Connection con;
            block10: {
                con = null;
                ps = null;
                rs = null;
                try {
                    int buildNumber;
                    block11: {
                        con = DataAccess.getConnection();
                        ps = con.prepareStatement(_GET_BUILD_NUMBER);
                        ps.setLong(1, 1L);
                        rs = ps.executeQuery();
                        if (!rs.next()) break block10;
                        buildNumber = rs.getInt("buildNumber");
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)("Build number " + buildNumber));
                        }
                        DB db = DBFactoryUtil.getDB();
                        try {
                            db.runSQL("alter table Release_ add state_ INTEGER");
                        }
                        catch (Exception e2) {
                            if (!_log.isDebugEnabled()) break block11;
                            _log.debug((Object)e2.getMessage());
                        }
                    }
                    this.testSupportsStringCaseSensitiveQuery();
                    int n = buildNumber;
                    DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
                    return n;
                }
                catch (Exception e3) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e3.getMessage());
                    }
                    break block12;
                }
                finally {
                    DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                }
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        }
        if (GetterUtil.getBoolean((String)PropsUtil.get("schema.run.enabled"))) {
            this.releaseLocalService.createTablesAndPopulate();
            this.testSupportsStringCaseSensitiveQuery();
            Release release = this.fetchRelease("portal");
            return release.getBuildNumber();
        }
        throw new NoSuchReleaseException("The database needs to be populated");
    }

    public Release updateRelease(long releaseId, int buildNumber, Date buildDate, boolean verified) throws PortalException, SystemException {
        Release release = this.releasePersistence.findByPrimaryKey(releaseId);
        release.setModifiedDate(new Date());
        release.setBuildNumber(buildNumber);
        release.setBuildDate(buildDate);
        release.setVerified(verified);
        this.releasePersistence.update((BaseModel)release);
        return release;
    }

    protected void testSupportsStringCaseSensitiveQuery() throws SystemException {
        DB db = DBFactoryUtil.getDB();
        int count = this.testSupportsStringCaseSensitiveQuery("You take the blue pill, the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill, you stay in Wonderland, and I show you how deep the rabbit hole goes.");
        if (count == 0) {
            block9: {
                block8: {
                    try {
                        db.runSQL("alter table Release_ add testString VARCHAR(1024) null");
                    }
                    catch (Exception e2) {
                        if (!_log.isDebugEnabled()) break block8;
                        _log.debug((Object)e2.getMessage());
                    }
                }
                try {
                    db.runSQL("update Release_ set testString = 'You take the blue pill, the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill, you stay in Wonderland, and I show you how deep the rabbit hole goes.'");
                }
                catch (Exception e3) {
                    if (!_log.isDebugEnabled()) break block9;
                    _log.debug((Object)e3.getMessage());
                }
            }
            count = this.testSupportsStringCaseSensitiveQuery("You take the blue pill, the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill, you stay in Wonderland, and I show you how deep the rabbit hole goes.");
        }
        if (count == 0) {
            throw new SystemException("Release_ table was not initialized properly");
        }
        count = this.testSupportsStringCaseSensitiveQuery("You take the blue pill, the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill, you stay in Wonderland, and I show you how deep the rabbit hole goes.".toUpperCase());
        if (count == 0) {
            db.setSupportsStringCaseSensitiveQuery(true);
        } else {
            db.setSupportsStringCaseSensitiveQuery(false);
        }
    }

    protected int testSupportsStringCaseSensitiveQuery(String testString) {
        int count;
        block7: {
            count = 0;
            Connection con = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    con = DataAccess.getConnection();
                    ps = con.prepareStatement(_TEST_DATABASE_STRING_CASE_SENSITIVITY);
                    ps.setLong(1, 1L);
                    ps.setString(2, testString);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                catch (Exception e2) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)e2.getMessage());
                    }
                    DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        }
        return count;
    }
}

