/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.concurrent.LockRegistry;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletPreferencesIds;
import com.liferay.portal.service.base.PortletPreferencesLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletPreferencesThreadLocal;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.portlet.PortletPreferences;

public class PortletPreferencesLocalServiceImpl
extends PortletPreferencesLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(PortletPreferencesLocalServiceImpl.class);

    public com.liferay.portal.model.PortletPreferences addPortletPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, Portlet portlet, String defaultPreferences) throws SystemException {
        com.liferay.portal.model.PortletPreferences portletPreferences;
        block4: {
            long portletPreferencesId = this.counterLocalService.increment();
            portletPreferences = this.portletPreferencesPersistence.create(portletPreferencesId);
            portletPreferences.setOwnerId(ownerId);
            portletPreferences.setOwnerType(ownerType);
            portletPreferences.setPlid(plid);
            portletPreferences.setPortletId(portletId);
            if (Validator.isNull((String)defaultPreferences)) {
                defaultPreferences = portlet == null ? "<portlet-preferences />" : portlet.getDefaultPreferences();
            }
            portletPreferences.setPreferences(defaultPreferences);
            try {
                this.portletPreferencesPersistence.update((BaseModel)portletPreferences);
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Add failed, fetch {ownerId=" + ownerId + ", ownerType=" + ownerType + ", plid=" + plid + ", portletId=" + portletId + "}"));
                }
                if ((portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid, portletId, false)) != null) break block4;
                throw se;
            }
        }
        return portletPreferences;
    }

    public void deletePortletPreferences(long ownerId, int ownerType, long plid) throws SystemException {
        this.portletPreferencesPersistence.removeByO_O_P(ownerId, ownerType, plid);
    }

    public void deletePortletPreferences(long ownerId, int ownerType, long plid, String portletId) throws PortalException, SystemException {
        this.portletPreferencesPersistence.removeByO_O_P_P(ownerId, ownerType, plid, portletId);
    }

    public void deletePortletPreferencesByPlid(long plid) throws SystemException {
        this.portletPreferencesPersistence.removeByPlid(plid);
    }

    @Skip
    public PortletPreferences getDefaultPreferences(long companyId, String portletId) throws SystemException {
        Portlet portlet = this.portletLocalService.getPortletById(companyId, portletId);
        return PortletPreferencesFactoryUtil.fromDefaultXML((String)portlet.getDefaultPreferences());
    }

    public List<com.liferay.portal.model.PortletPreferences> getPortletPreferences() throws SystemException {
        return this.portletPreferencesPersistence.findAll();
    }

    public List<com.liferay.portal.model.PortletPreferences> getPortletPreferences(int ownerType, long plid, String portletId) throws SystemException {
        return this.portletPreferencesPersistence.findByO_P_P(ownerType, plid, portletId);
    }

    public List<com.liferay.portal.model.PortletPreferences> getPortletPreferences(long ownerId, int ownerType, long plid) throws SystemException {
        return this.portletPreferencesPersistence.findByO_O_P(ownerId, ownerType, plid);
    }

    public com.liferay.portal.model.PortletPreferences getPortletPreferences(long ownerId, int ownerType, long plid, String portletId) throws PortalException, SystemException {
        return this.portletPreferencesPersistence.findByO_O_P_P(ownerId, ownerType, plid, portletId);
    }

    public List<com.liferay.portal.model.PortletPreferences> getPortletPreferences(long companyId, long groupId, long ownerId, int ownerType, String portletId, boolean privateLayout) throws SystemException {
        return this.portletPreferencesFinder.findByC_G_O_O_P_P(companyId, groupId, ownerId, ownerType, portletId, privateLayout);
    }

    public List<com.liferay.portal.model.PortletPreferences> getPortletPreferences(long plid, String portletId) throws SystemException {
        return this.portletPreferencesPersistence.findByP_P(plid, portletId);
    }

    public List<com.liferay.portal.model.PortletPreferences> getPortletPreferencesByPlid(long plid) throws SystemException {
        return this.portletPreferencesPersistence.findByPlid(plid);
    }

    public long getPortletPreferencesCount(int ownerType, long plid, String portletId) throws SystemException {
        return this.portletPreferencesPersistence.countByO_P_P(ownerType, plid, portletId);
    }

    public PortletPreferences getPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId) throws SystemException {
        return this.getPreferences(companyId, ownerId, ownerType, plid, portletId, null);
    }

    public PortletPreferences getPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String defaultPreferences) throws SystemException {
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        if (!dbType.equals("hypersonic")) {
            return this.doGetPreferences(companyId, ownerId, ownerType, plid, portletId, defaultPreferences);
        }
        StringBundler sb = new StringBundler(7);
        sb.append(ownerId);
        sb.append("#");
        sb.append(ownerType);
        sb.append("#");
        sb.append(plid);
        sb.append("#");
        sb.append(portletId);
        String groupName = ((Object)((Object)this)).getClass().getName();
        String key = sb.toString();
        ReentrantLock lock = LockRegistry.allocateLock((String)groupName, (String)key);
        lock.lock();
        try {
            PortletPreferences portletPreferences = this.doGetPreferences(companyId, ownerId, ownerType, plid, portletId, defaultPreferences);
            return portletPreferences;
        }
        finally {
            lock.unlock();
            LockRegistry.freeLock((String)groupName, (String)key);
        }
    }

    public PortletPreferences getPreferences(PortletPreferencesIds portletPreferencesIds) throws SystemException {
        return this.getPreferences(portletPreferencesIds.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), portletPreferencesIds.getPlid(), portletPreferencesIds.getPortletId());
    }

    public PortletPreferences getStrictPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId) throws SystemException {
        boolean strict = PortletPreferencesThreadLocal.isStrict();
        PortletPreferencesThreadLocal.setStrict((!PropsValues.TCK_URL ? 1 : 0) != 0);
        try {
            PortletPreferences portletPreferences = this.getPreferences(companyId, ownerId, ownerType, plid, portletId, null);
            return portletPreferences;
        }
        finally {
            PortletPreferencesThreadLocal.setStrict((boolean)strict);
        }
    }

    public PortletPreferences getStrictPreferences(PortletPreferencesIds portletPreferencesIds) throws SystemException {
        return this.getStrictPreferences(portletPreferencesIds.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), portletPreferencesIds.getPlid(), portletPreferencesIds.getPortletId());
    }

    public com.liferay.portal.model.PortletPreferences updatePreferences(long ownerId, int ownerType, long plid, String portletId, PortletPreferences portletPreferences) throws SystemException {
        String xml = PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
        return this.updatePreferences(ownerId, ownerType, plid, portletId, xml);
    }

    public com.liferay.portal.model.PortletPreferences updatePreferences(long ownerId, int ownerType, long plid, String portletId, String xml) throws SystemException {
        com.liferay.portal.model.PortletPreferences portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid, portletId);
        if (portletPreferences == null) {
            long portletPreferencesId = this.counterLocalService.increment();
            portletPreferences = this.portletPreferencesPersistence.create(portletPreferencesId);
            portletPreferences.setOwnerId(ownerId);
            portletPreferences.setOwnerType(ownerType);
            portletPreferences.setPlid(plid);
            portletPreferences.setPortletId(portletId);
        }
        portletPreferences.setPreferences(xml);
        this.portletPreferencesPersistence.update((BaseModel)portletPreferences);
        return portletPreferences;
    }

    protected PortletPreferences doGetPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String defaultPreferences) throws SystemException {
        com.liferay.portal.model.PortletPreferences portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid, portletId);
        if (portletPreferences == null) {
            Portlet portlet = this.portletLocalService.getPortletById(companyId, portletId);
            if (PortletPreferencesThreadLocal.isStrict() && (Validator.isNull((String)defaultPreferences) || portlet != null && portlet.isUndeployedPortlet())) {
                return new PortletPreferencesImpl();
            }
            portletPreferences = this.portletPreferencesLocalService.addPortletPreferences(companyId, ownerId, ownerType, plid, portletId, portlet, defaultPreferences);
        }
        PortletPreferencesImpl portletPreferencesImpl = (PortletPreferencesImpl)PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)portletPreferences.getPreferences());
        return portletPreferencesImpl;
    }
}

