/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.sender.DirectSynchronousMessageSender;
import com.liferay.portal.kernel.messaging.sender.SynchronousMessageSender;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ClassName;
import com.liferay.portal.model.impl.ClassNameImpl;
import com.liferay.portal.service.PortalService;
import com.liferay.portal.service.base.PortalServiceBaseImpl;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;

@JSONWebService(mode=JSONWebServiceMode.MANUAL)
public class PortalServiceImpl
extends PortalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(PortalServiceImpl.class);

    public String getAutoDeployDirectory() throws SystemException {
        return PrefsPropsUtil.getString("auto.deploy.deploy.dir", PropsValues.AUTO_DEPLOY_DEPLOY_DIR);
    }

    @JSONWebService
    public int getBuildNumber() {
        return ReleaseInfo.getBuildNumber();
    }

    public void testAddClassName_Rollback(String classNameValue) throws SystemException {
        this.addClassName(classNameValue);
        throw new SystemException();
    }

    public void testAddClassName_Success(String classNameValue) throws SystemException {
        this.addClassName(classNameValue);
    }

    public void testAddClassNameAndTestTransactionPortletBar_PortalRollback(String transactionPortletBarText) throws SystemException {
        this.addClassName(PortalService.class.getName());
        this.addTransactionPortletBar(transactionPortletBarText, false);
        throw new SystemException();
    }

    public void testAddClassNameAndTestTransactionPortletBar_PortletRollback(String transactionPortletBarText) throws SystemException {
        this.addClassName(PortalService.class.getName());
        this.addTransactionPortletBar(transactionPortletBarText, true);
    }

    public void testAddClassNameAndTestTransactionPortletBar_Success(String transactionPortletBarText) throws SystemException {
        this.addClassName(PortalService.class.getName());
        this.addTransactionPortletBar(transactionPortletBarText, false);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void testAutoSyncHibernateSessionStateOnTxCreation() throws SystemException {
        ClassName className = this.classNameLocalService.addClassName("testAutoSyncHibernateSessionStateOnTxCreation1");
        try {
            EntityCacheUtil.clearCache();
            className = this.classNamePersistence.fetchByPrimaryKey(className.getClassNameId());
            Session currentSession = this.classNamePersistence.getCurrentSession();
            if (!currentSession.contains((Object)className)) {
                throw new IllegalStateException("Entities are not available in Hibernate's first level cache");
            }
            ClassNameImpl newClassName = new ClassNameImpl();
            newClassName.setPrimaryKey(className.getClassNameId());
            String newValue = "testAutoSyncHibernateSessionStateOnTxCreation2";
            newClassName.setValue(newValue);
            this.classNameLocalService.updateClassName((ClassName)newClassName);
            if (currentSession.contains((Object)className)) {
                throw new IllegalStateException("Entities are still available in Hibernate's first level cache");
            }
            EntityCacheUtil.clearCache();
            className = this.classNamePersistence.fetchByPrimaryKey(className.getClassNameId());
            if (!newValue.equals(className.getValue())) {
                throw new IllegalStateException("Expected " + newValue + " but found " + className.getClassName());
            }
        }
        finally {
            this.classNameLocalService.deleteClassName(className);
        }
    }

    public void testCounterIncrement_Rollback() throws SystemException {
        int counterIncrement = PropsValues.COUNTER_INCREMENT;
        int i2 = 0;
        while (i2 < counterIncrement * 2) {
            this.counterLocalService.increment();
            ++i2;
        }
        throw new SystemException();
    }

    public void testDeleteClassName() throws PortalException, SystemException {
        this.classNamePersistence.removeByValue(PortalService.class.getName());
    }

    public int testGetBuildNumber() {
        return this.portalService.getBuildNumber();
    }

    public void testGetUserId() {
        long userId = 0L;
        try {
            userId = this.getUserId();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("User id " + userId));
        }
    }

    public boolean testHasClassName() throws SystemException {
        int count = this.classNamePersistence.countByValue(PortalService.class.getName());
        return count > 0;
    }

    protected void addClassName(String classNameValue) throws SystemException {
        long classNameId = this.counterLocalService.increment();
        ClassName className = this.classNamePersistence.create(classNameId);
        className.setValue(classNameValue);
        this.classNamePersistence.update((BaseModel)className);
    }

    protected void addTransactionPortletBar(String transactionPortletBarText, boolean rollback) throws SystemException {
        try {
            Message message = new Message();
            message.put("rollback", (Object)rollback);
            message.put("text", (Object)transactionPortletBarText);
            SynchronousMessageSender synchronousMessageSender = (SynchronousMessageSender)PortalBeanLocatorUtil.locate((String)DirectSynchronousMessageSender.class.getName());
            synchronousMessageSender.send("liferay/test_transaction", message);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }
}

