/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.GroupedModel;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.PermissionedModel;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.base.PermissionServiceBaseImpl;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.service.permission.TeamPermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.permission.BookmarksEntryPermission;
import com.liferay.portlet.bookmarks.service.permission.BookmarksFolderPermission;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journal.service.permission.JournalFeedPermission;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import com.liferay.portlet.polls.model.PollsQuestion;
import com.liferay.portlet.polls.service.permission.PollsQuestionPermission;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.service.permission.ShoppingCategoryPermission;
import com.liferay.portlet.shopping.service.permission.ShoppingItemPermission;
import com.liferay.portlet.softwarecatalog.model.SCFrameworkVersion;
import com.liferay.portlet.softwarecatalog.model.SCProductEntry;
import com.liferay.portlet.softwarecatalog.service.permission.SCFrameworkVersionPermission;
import com.liferay.portlet.softwarecatalog.service.permission.SCProductEntryPermission;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;
import com.liferay.portlet.wiki.service.permission.WikiPagePermission;
import java.util.List;

public class PermissionServiceImpl
extends PermissionServiceBaseImpl {
    public void checkPermission(long groupId, String name, long primKey) throws PortalException, SystemException {
        this.checkPermission(this.getPermissionChecker(), groupId, name, String.valueOf(primKey));
    }

    public void checkPermission(long groupId, String name, String primKey) throws PortalException, SystemException {
        this.checkPermission(this.getPermissionChecker(), groupId, name, primKey);
    }

    protected void checkPermission(PermissionChecker permissionChecker, long groupId, String name, String primKey) throws PortalException, SystemException {
        if (name.equals(BlogsEntry.class.getName())) {
            BlogsEntryPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(BookmarksEntry.class.getName())) {
            BookmarksEntryPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(BookmarksFolder.class.getName())) {
            BookmarksFolderPermission.check(permissionChecker, groupId, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(DLFileEntry.class.getName())) {
            DLFileEntryPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(DLFolder.class.getName())) {
            DLFolderPermission.check(permissionChecker, groupId, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(Group.class.getName())) {
            GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)GetterUtil.getLong((String)primKey), (String)"PERMISSIONS");
        } else if (name.equals(JournalArticle.class.getName())) {
            JournalArticlePermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(JournalFeed.class.getName())) {
            JournalFeedPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(Layout.class.getName())) {
            LayoutPermissionUtil.check((PermissionChecker)permissionChecker, (long)GetterUtil.getLong((String)primKey), (String)"PERMISSIONS");
        } else if (name.equals(MBCategory.class.getName())) {
            MBCategoryPermission.check(permissionChecker, groupId, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(MBMessage.class.getName())) {
            MBMessagePermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(PollsQuestion.class.getName())) {
            PollsQuestionPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(SCFrameworkVersion.class.getName())) {
            SCFrameworkVersionPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(SCProductEntry.class.getName())) {
            SCProductEntryPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(ShoppingCategory.class.getName())) {
            ShoppingCategoryPermission.check(permissionChecker, groupId, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(ShoppingItem.class.getName())) {
            ShoppingItemPermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(Team.class.getName())) {
            long teamId = GetterUtil.getLong((String)primKey);
            Team team = this.teamPersistence.findByPrimaryKey(teamId);
            GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)team.getGroupId(), (String)"MANAGE_TEAMS");
        } else if (name.equals(User.class.getName())) {
            long userId = GetterUtil.getLong((String)primKey);
            User user = this.userPersistence.findByPrimaryKey(userId);
            UserPermissionUtil.check((PermissionChecker)permissionChecker, (long)userId, (long[])user.getOrganizationIds(), (String)"PERMISSIONS");
        } else if (name.equals(WikiNode.class.getName())) {
            WikiNodePermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (name.equals(WikiPage.class.getName())) {
            WikiPagePermission.check(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS");
        } else if (primKey != null && primKey.contains("_LAYOUT_")) {
            int pos = primKey.indexOf("_LAYOUT_");
            long plid = GetterUtil.getLong((String)primKey.substring(0, pos));
            String portletId = primKey.substring(pos + "_LAYOUT_".length());
            PortletPermissionUtil.check((PermissionChecker)permissionChecker, (long)plid, (String)portletId, (String)"CONFIGURATION");
        } else if (!permissionChecker.hasPermission(groupId, name, primKey, "PERMISSIONS")) {
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)name);
            if (assetRendererFactory != null) {
                try {
                    if (assetRendererFactory.hasPermission(permissionChecker, GetterUtil.getLong((String)primKey), "PERMISSIONS")) {
                        return;
                    }
                }
                catch (Exception exception) {}
            }
            long ownerId = 0L;
            if (this.resourceBlockLocalService.isSupported(name)) {
                PermissionedModel permissionedModel = this.resourceBlockLocalService.getPermissionedModel(name, GetterUtil.getLong((String)primKey));
                if (permissionedModel instanceof GroupedModel) {
                    GroupedModel groupedModel = (GroupedModel)permissionedModel;
                    ownerId = groupedModel.getUserId();
                } else if (permissionedModel instanceof AuditedModel) {
                    AuditedModel auditedModel = (AuditedModel)permissionedModel;
                    ownerId = auditedModel.getUserId();
                }
            } else {
                ResourcePermission resourcePermission = this.resourcePermissionLocalService.getResourcePermission(permissionChecker.getCompanyId(), name, 4, primKey, permissionChecker.getOwnerRoleId());
                ownerId = resourcePermission.getOwnerId();
            }
            if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), name, primKey, ownerId, "PERMISSIONS")) {
                return;
            }
            Role role = null;
            if (name.equals(Role.class.getName())) {
                long roleId = GetterUtil.getLong((String)primKey);
                role = this.rolePersistence.findByPrimaryKey(roleId);
            }
            if (role != null && role.isTeam()) {
                Team team = this.teamPersistence.findByPrimaryKey(role.getClassPK());
                TeamPermissionUtil.check((PermissionChecker)permissionChecker, (long)team.getTeamId(), (String)"PERMISSIONS");
            } else {
                List resourceActions = ResourceActionsUtil.getResourceActions((String)name);
                if (!resourceActions.contains("DEFINE_PERMISSIONS") || !permissionChecker.hasPermission(groupId, name, primKey, "DEFINE_PERMISSIONS")) {
                    throw new PrincipalException();
                }
            }
        }
    }
}

