/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.OrgLabor;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.User;
import com.liferay.portal.model.Website;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.membershippolicy.OrganizationMembershipPolicyUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.OrganizationServiceBaseImpl;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.permission.PasswordPolicyPermissionUtil;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.usersadmin.util.UsersAdminUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OrganizationServiceImpl
extends OrganizationServiceBaseImpl {
    public void addGroupOrganizations(long groupId, long[] organizationIds) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
        this.organizationLocalService.addGroupOrganizations(groupId, organizationIds);
    }

    public Organization addOrganization(long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, boolean site, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addOrganization(parentOrganizationId, name, type, regionId, countryId, statusId, comments, site, addresses, emailAddresses, orgLabors, phones, websites, serviceContext);
    }

    public Organization addOrganization(long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, boolean site, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addOrganization(parentOrganizationId, name, type, regionId, countryId, statusId, comments, site, serviceContext);
    }

    public Organization addOrganization(long parentOrganizationId, String name, String type, long regionId, long countryId, int statusId, String comments, boolean site, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException, SystemException {
        boolean indexingEnabled = serviceContext.isIndexingEnabled();
        serviceContext.setIndexingEnabled(false);
        try {
            Organization organization = this.addOrganization(parentOrganizationId, name, type, regionId, countryId, statusId, comments, site, serviceContext);
            UsersAdminUtil.updateAddresses((String)Organization.class.getName(), (long)organization.getOrganizationId(), addresses);
            UsersAdminUtil.updateEmailAddresses((String)Organization.class.getName(), (long)organization.getOrganizationId(), emailAddresses);
            UsersAdminUtil.updateOrgLabors((long)organization.getOrganizationId(), orgLabors);
            UsersAdminUtil.updatePhones((String)Organization.class.getName(), (long)organization.getOrganizationId(), phones);
            UsersAdminUtil.updateWebsites((String)Organization.class.getName(), (long)organization.getOrganizationId(), websites);
            if (indexingEnabled) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(Organization.class);
                indexer.reindex((Object)organization);
            }
            Organization organization2 = organization;
            return organization2;
        }
        finally {
            serviceContext.setIndexingEnabled(indexingEnabled);
        }
    }

    public Organization addOrganization(long parentOrganizationId, String name, String type, long regionId, long countryId, int statusId, String comments, boolean site, ServiceContext serviceContext) throws PortalException, SystemException {
        if (!OrganizationPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)parentOrganizationId, (String)"MANAGE_SUBORGANIZATIONS") && !PortalPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (String)"ADD_ORGANIZATION")) {
            throw new PrincipalException("User " + this.getUserId() + " does not have permissions to add " + "an organization with parent " + parentOrganizationId);
        }
        Organization organization = this.organizationLocalService.addOrganization(this.getUserId(), parentOrganizationId, name, type, regionId, countryId, statusId, comments, site, serviceContext);
        OrganizationMembershipPolicyUtil.verifyPolicy((Organization)organization);
        return organization;
    }

    public void addPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) throws PortalException, SystemException {
        PasswordPolicyPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)passwordPolicyId, (String)"UPDATE");
        this.organizationLocalService.addPasswordPolicyOrganizations(passwordPolicyId, organizationIds);
    }

    public void deleteLogo(long organizationId) throws PortalException, SystemException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"UPDATE");
        this.organizationLocalService.deleteLogo(organizationId);
    }

    public void deleteOrganization(long organizationId) throws PortalException, SystemException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"DELETE");
        this.organizationLocalService.deleteOrganization(organizationId);
    }

    public List<Organization> getManageableOrganizations(String actionId, int max) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            return this.organizationLocalService.search(permissionChecker.getCompanyId(), -1L, null, null, null, null, null, 0, max);
        }
        LinkedHashMap<String, List> params = new LinkedHashMap<String, List>();
        List userOrganizations = this.organizationLocalService.getUserOrganizations(permissionChecker.getUserId());
        params.put("organizationsTree", userOrganizations);
        List manageableOrganizations = this.organizationLocalService.search(permissionChecker.getCompanyId(), -1L, null, null, null, null, params, 0, max);
        manageableOrganizations = ListUtil.copy((List)manageableOrganizations);
        Iterator itr = manageableOrganizations.iterator();
        while (itr.hasNext()) {
            Organization organization = (Organization)itr.next();
            if (OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)organization, (String)actionId)) continue;
            itr.remove();
        }
        return manageableOrganizations;
    }

    public Organization getOrganization(long organizationId) throws PortalException, SystemException {
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"VIEW");
        return this.organizationLocalService.getOrganization(organizationId);
    }

    public long getOrganizationId(long companyId, String name) throws PortalException, SystemException {
        long organizationId = this.organizationLocalService.getOrganizationId(companyId, name);
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)organizationId, (String)"VIEW");
        return organizationId;
    }

    public List<Organization> getOrganizations(long companyId, long parentOrganizationId) throws SystemException {
        return this.organizationPersistence.filterFindByC_P(companyId, parentOrganizationId);
    }

    public List<Organization> getOrganizations(long companyId, long parentOrganizationId, int start, int end) throws SystemException {
        return this.organizationPersistence.filterFindByC_P(companyId, parentOrganizationId, start, end);
    }

    public int getOrganizationsCount(long companyId, long parentOrganizationId) throws SystemException {
        return this.organizationPersistence.filterCountByC_P(companyId, parentOrganizationId);
    }

    public List<Organization> getUserOrganizations(long userId) throws PortalException, SystemException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        return this.organizationLocalService.getUserOrganizations(userId);
    }

    public void setGroupOrganizations(long groupId, long[] organizationIds) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
        this.organizationLocalService.setGroupOrganizations(groupId, organizationIds);
    }

    public void unsetGroupOrganizations(long groupId, long[] organizationIds) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
        this.organizationLocalService.unsetGroupOrganizations(groupId, organizationIds);
    }

    public void unsetPasswordPolicyOrganizations(long passwordPolicyId, long[] organizationIds) throws PortalException, SystemException {
        PasswordPolicyPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)passwordPolicyId, (String)"UPDATE");
        this.organizationLocalService.unsetPasswordPolicyOrganizations(passwordPolicyId, organizationIds);
    }

    public Organization updateOrganization(long organizationId, long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, boolean site, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.updateOrganization(organizationId, parentOrganizationId, name, type, regionId, countryId, statusId, comments, site, addresses, emailAddresses, orgLabors, phones, websites, serviceContext);
    }

    public Organization updateOrganization(long organizationId, long parentOrganizationId, String name, String type, boolean recursable, long regionId, long countryId, int statusId, String comments, boolean site, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.updateOrganization(organizationId, parentOrganizationId, name, type, regionId, countryId, statusId, comments, site, serviceContext);
    }

    public Organization updateOrganization(long organizationId, long parentOrganizationId, String name, String type, long regionId, long countryId, int statusId, String comments, boolean site, List<Address> addresses, List<EmailAddress> emailAddresses, List<OrgLabor> orgLabors, List<Phone> phones, List<Website> websites, ServiceContext serviceContext) throws PortalException, SystemException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        OrganizationPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Organization)organization, (String)"UPDATE");
        if (organization.getParentOrganizationId() != parentOrganizationId) {
            if (parentOrganizationId == 0L) {
                PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_ORGANIZATION");
            } else if (!OrganizationPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)parentOrganizationId, (String)"MANAGE_SUBORGANIZATIONS") && !PortalPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (String)"ADD_ORGANIZATION")) {
                throw new PrincipalException("User " + this.getUserId() + " does not have permissions " + "to move organization " + organizationId + "to " + "parent " + parentOrganizationId);
            }
        }
        if (addresses != null) {
            UsersAdminUtil.updateAddresses((String)Organization.class.getName(), (long)organizationId, addresses);
        }
        if (emailAddresses != null) {
            UsersAdminUtil.updateEmailAddresses((String)Organization.class.getName(), (long)organizationId, emailAddresses);
        }
        if (orgLabors != null) {
            UsersAdminUtil.updateOrgLabors((long)organizationId, orgLabors);
        }
        if (phones != null) {
            UsersAdminUtil.updatePhones((String)Organization.class.getName(), (long)organizationId, phones);
        }
        if (websites != null) {
            UsersAdminUtil.updateWebsites((String)Organization.class.getName(), (long)organizationId, websites);
        }
        User user = this.getUser();
        Organization oldOrganization = organization;
        List oldAssetCategories = this.assetCategoryLocalService.getCategories(Organization.class.getName(), organizationId);
        List oldAssetTags = this.assetTagLocalService.getTags(Organization.class.getName(), organizationId);
        ExpandoBridge oldExpandoBridge = oldOrganization.getExpandoBridge();
        Map oldExpandoAttributes = oldExpandoBridge.getAttributes();
        organization = this.organizationLocalService.updateOrganization(user.getCompanyId(), organizationId, parentOrganizationId, name, type, regionId, countryId, statusId, comments, site, serviceContext);
        OrganizationMembershipPolicyUtil.verifyPolicy((Organization)organization, (Organization)oldOrganization, (List)oldAssetCategories, (List)oldAssetTags, (Map)oldExpandoAttributes);
        return organization;
    }

    public Organization updateOrganization(long organizationId, long parentOrganizationId, String name, String type, long regionId, long countryId, int statusId, String comments, boolean site, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.updateOrganization(organizationId, parentOrganizationId, name, type, regionId, countryId, statusId, comments, site, null, null, null, null, null, serviceContext);
    }
}

