/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.DummyWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.layoutconfiguration.util.velocity.InitColumnProcessor;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.PluginSetting;
import com.liferay.portal.model.impl.LayoutTemplateImpl;
import com.liferay.portal.service.base.LayoutTemplateLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;

public class LayoutTemplateLocalServiceImpl
extends LayoutTemplateLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(LayoutTemplateLocalServiceImpl.class);
    private static Map<String, LayoutTemplate> _portalCustom = new LinkedHashMap<String, LayoutTemplate>();
    private static Map<String, LayoutTemplate> _portalStandard = new LinkedHashMap<String, LayoutTemplate>();
    private static Map<String, Map<String, LayoutTemplate>> _themes = new LinkedHashMap<String, Map<String, LayoutTemplate>>();
    private static Map<String, LayoutTemplate> _warCustom = new LinkedHashMap<String, LayoutTemplate>();
    private static Map<String, LayoutTemplate> _warStandard = new LinkedHashMap<String, LayoutTemplate>();

    public String getContent(String layoutTemplateId, boolean standard, String themeId) throws SystemException {
        LayoutTemplate layoutTemplate = this.getLayoutTemplate(layoutTemplateId, standard, themeId);
        if (layoutTemplate == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Layout template " + layoutTemplateId + " does not exist"));
            }
            if ((layoutTemplate = this.getLayoutTemplate(PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID, standard, themeId)) == null) {
                _log.error((Object)("Layout template " + layoutTemplateId + " and default layout template " + PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID + " do not exist"));
                return "";
            }
        }
        if (PropsValues.LAYOUT_TEMPLATE_CACHE_ENABLED) {
            return layoutTemplate.getContent();
        }
        try {
            return layoutTemplate.getUncachedContent();
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public LayoutTemplate getLayoutTemplate(String layoutTemplateId, boolean standard, String themeId) {
        if (Validator.isNull((String)layoutTemplateId)) {
            return null;
        }
        LayoutTemplate layoutTemplate = null;
        if (themeId != null && (layoutTemplate = standard ? this._getThemesStandard(themeId).get(layoutTemplateId) : this._getThemesCustom(themeId).get(layoutTemplateId)) != null) {
            return layoutTemplate;
        }
        if (standard) {
            layoutTemplate = _warStandard.get(layoutTemplateId);
            if (layoutTemplate == null) {
                layoutTemplate = _portalStandard.get(layoutTemplateId);
            }
        } else {
            layoutTemplate = _warCustom.get(layoutTemplateId);
            if (layoutTemplate == null) {
                layoutTemplate = _portalCustom.get(layoutTemplateId);
            }
        }
        return layoutTemplate;
    }

    public List<LayoutTemplate> getLayoutTemplates() {
        ArrayList<LayoutTemplate> customLayoutTemplates = new ArrayList<LayoutTemplate>(_portalCustom.size() + _warCustom.size());
        customLayoutTemplates.addAll(ListUtil.fromMapValues(_portalCustom));
        customLayoutTemplates.addAll(ListUtil.fromMapValues(_warCustom));
        return customLayoutTemplates;
    }

    public List<LayoutTemplate> getLayoutTemplates(String themeId) {
        String layoutTemplateId;
        Map<String, LayoutTemplate> _themesCustom = this._getThemesCustom(themeId);
        ArrayList<LayoutTemplate> customLayoutTemplates = new ArrayList<LayoutTemplate>(_portalCustom.size() + _warCustom.size() + _themesCustom.size());
        for (Map.Entry<String, LayoutTemplate> entry : _portalCustom.entrySet()) {
            layoutTemplateId = entry.getKey();
            LayoutTemplate layoutTemplate = entry.getValue();
            LayoutTemplate themeCustomLayoutTemplate = _themesCustom.get(layoutTemplateId);
            if (themeCustomLayoutTemplate != null) {
                customLayoutTemplates.add(themeCustomLayoutTemplate);
                continue;
            }
            LayoutTemplate warCustomLayoutTemplate = _warCustom.get(layoutTemplateId);
            if (warCustomLayoutTemplate != null) {
                customLayoutTemplates.add(warCustomLayoutTemplate);
                continue;
            }
            customLayoutTemplates.add(layoutTemplate);
        }
        for (Map.Entry<String, LayoutTemplate> entry : _warCustom.entrySet()) {
            layoutTemplateId = entry.getKey();
            if (_portalCustom.containsKey(layoutTemplateId) || _themesCustom.containsKey(layoutTemplateId)) continue;
            customLayoutTemplates.add(_warCustom.get(layoutTemplateId));
        }
        for (Map.Entry<String, LayoutTemplate> entry : _themesCustom.entrySet()) {
            layoutTemplateId = entry.getKey();
            if (_portalCustom.containsKey(layoutTemplateId) || _warCustom.containsKey(layoutTemplateId)) continue;
            customLayoutTemplates.add(_themesCustom.get(layoutTemplateId));
        }
        return customLayoutTemplates;
    }

    public String getWapContent(String layoutTemplateId, boolean standard, String themeId) throws SystemException {
        LayoutTemplate layoutTemplate = this.getLayoutTemplate(layoutTemplateId, standard, themeId);
        if (layoutTemplate == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Layout template " + layoutTemplateId + " does not exist"));
            }
            if ((layoutTemplate = this.getLayoutTemplate(PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID, standard, themeId)) == null) {
                _log.error((Object)("Layout template " + layoutTemplateId + " and default layout template " + PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID + " do not exist"));
                return "";
            }
        }
        if (PropsValues.LAYOUT_TEMPLATE_CACHE_ENABLED) {
            return layoutTemplate.getWapContent();
        }
        try {
            return layoutTemplate.getUncachedWapContent();
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public List<ObjectValuePair<String, Boolean>> init(ServletContext servletContext, String[] xmls, PluginPackage pluginPackage) {
        return this.init(null, servletContext, xmls, pluginPackage);
    }

    public List<ObjectValuePair<String, Boolean>> init(String servletContextName, ServletContext servletContext, String[] xmls, PluginPackage pluginPackage) {
        ArrayList<ObjectValuePair<String, Boolean>> layoutTemplateIdOVPs = new ArrayList<ObjectValuePair<String, Boolean>>();
        try {
            int i2 = 0;
            while (i2 < xmls.length) {
                Set<ObjectValuePair<String, Boolean>> curLayoutTemplateIdOVPs = this._readLayoutTemplates(servletContextName, servletContext, xmls[i2], pluginPackage);
                for (ObjectValuePair<String, Boolean> layoutTemplateIdOVP : curLayoutTemplateIdOVPs) {
                    if (layoutTemplateIdOVPs.contains(layoutTemplateIdOVP)) continue;
                    layoutTemplateIdOVPs.add(layoutTemplateIdOVP);
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return layoutTemplateIdOVPs;
    }

    public void readLayoutTemplate(String servletContextName, ServletContext servletContext, Set<ObjectValuePair<String, Boolean>> layoutTemplateIdOVPs, Element element, boolean standard, String themeId, PluginPackage pluginPackage) {
        Map<String, LayoutTemplate> layoutTemplates = null;
        layoutTemplates = themeId != null ? (standard ? this._getThemesStandard(themeId) : this._getThemesCustom(themeId)) : (servletContextName != null ? (standard ? _warStandard : _warCustom) : (standard ? _portalStandard : _portalCustom));
        List layoutTemplateElements = element.elements("layout-template");
        for (Element layoutTemplateElement : layoutTemplateElements) {
            LayoutTemplate layoutTemplateModel;
            String layoutTemplateId = layoutTemplateElement.attributeValue("id");
            if (layoutTemplateIdOVPs != null) {
                ObjectValuePair layoutTemplateIdOVP = new ObjectValuePair((Object)layoutTemplateId, (Object)standard);
                layoutTemplateIdOVPs.add((ObjectValuePair<String, Boolean>)layoutTemplateIdOVP);
            }
            if ((layoutTemplateModel = layoutTemplates.get(layoutTemplateId)) == null) {
                layoutTemplateModel = new LayoutTemplateImpl(layoutTemplateId);
                layoutTemplates.put(layoutTemplateId, layoutTemplateModel);
            }
            PluginSetting pluginSetting = this.pluginSettingLocalService.getDefaultPluginSetting();
            layoutTemplateModel.setPluginPackage(pluginPackage);
            layoutTemplateModel.setServletContext(servletContext);
            if (servletContextName != null) {
                layoutTemplateModel.setServletContextName(servletContextName);
            }
            layoutTemplateModel.setStandard(standard);
            layoutTemplateModel.setThemeId(themeId);
            layoutTemplateModel.setName(GetterUtil.getString((String)layoutTemplateElement.attributeValue("name"), (String)layoutTemplateModel.getName()));
            layoutTemplateModel.setTemplatePath(GetterUtil.getString((String)layoutTemplateElement.elementText("template-path"), (String)layoutTemplateModel.getTemplatePath()));
            layoutTemplateModel.setWapTemplatePath(GetterUtil.getString((String)layoutTemplateElement.elementText("wap-template-path"), (String)layoutTemplateModel.getWapTemplatePath()));
            layoutTemplateModel.setThumbnailPath(GetterUtil.getString((String)layoutTemplateElement.elementText("thumbnail-path"), (String)layoutTemplateModel.getThumbnailPath()));
            String content = null;
            try {
                content = HttpUtil.URLtoString((URL)servletContext.getResource(layoutTemplateModel.getTemplatePath()));
            }
            catch (Exception e2) {
                _log.error((Object)("Unable to get content at template path " + layoutTemplateModel.getTemplatePath() + ": " + e2.getMessage()));
            }
            if (Validator.isNull((String)content)) {
                _log.error((Object)("No content found at template path " + layoutTemplateModel.getTemplatePath()));
            } else {
                StringBundler sb = new StringBundler(3);
                sb.append(themeId);
                if (standard) {
                    sb.append("_STANDARD_");
                } else {
                    sb.append("_CUSTOM_");
                }
                sb.append(layoutTemplateId);
                String velocityTemplateId = sb.toString();
                layoutTemplateModel.setContent(content);
                layoutTemplateModel.setColumns(this._getColumns(velocityTemplateId, content));
            }
            if (Validator.isNull((String)layoutTemplateModel.getWapTemplatePath())) {
                _log.error((Object)("The element wap-template-path is not defined for " + layoutTemplateId));
            } else {
                String wapContent = null;
                try {
                    wapContent = HttpUtil.URLtoString((URL)servletContext.getResource(layoutTemplateModel.getWapTemplatePath()));
                }
                catch (Exception e3) {
                    _log.error((Object)("Unable to get content at WAP template path " + layoutTemplateModel.getWapTemplatePath() + ": " + e3.getMessage()));
                }
                if (Validator.isNull((String)wapContent)) {
                    _log.error((Object)("No content found at WAP template path " + layoutTemplateModel.getWapTemplatePath()));
                } else {
                    layoutTemplateModel.setWapContent(wapContent);
                }
            }
            Element rolesElement = layoutTemplateElement.element("roles");
            if (rolesElement != null) {
                List roleNameElements = rolesElement.elements("role-name");
                for (Element roleNameElement : roleNameElements) {
                    pluginSetting.addRole(roleNameElement.getText());
                }
            }
            layoutTemplateModel.setDefaultPluginSetting(pluginSetting);
        }
    }

    public void uninstallLayoutTemplate(String layoutTemplateId, boolean standard) {
        String templateId = null;
        try {
            if (standard) {
                templateId = "null_STANDARD_" + layoutTemplateId;
                TemplateResourceLoaderUtil.clearCache((String)"vm", (String)templateId);
                _warStandard.remove(layoutTemplateId);
            } else {
                templateId = "null_CUSTOM_" + layoutTemplateId;
                TemplateResourceLoaderUtil.clearCache((String)"vm", (String)templateId);
                _warCustom.remove(layoutTemplateId);
            }
        }
        catch (Exception e2) {
            _log.error((Object)("Unable to uninstall layout template " + layoutTemplateId), (Throwable)e2);
        }
    }

    public void uninstallLayoutTemplates(String themeId) {
        Map<String, LayoutTemplate> _themesStandard = this._getThemesStandard(themeId);
        for (Map.Entry<String, LayoutTemplate> entry : _themesStandard.entrySet()) {
            LayoutTemplate layoutTemplate = entry.getValue();
            String templateId = String.valueOf(themeId) + "_STANDARD_" + layoutTemplate.getLayoutTemplateId();
            try {
                TemplateResourceLoaderUtil.clearCache((String)"vm", (String)templateId);
            }
            catch (Exception e2) {
                _log.error((Object)("Unable to uninstall layout template " + layoutTemplate.getLayoutTemplateId()), (Throwable)e2);
            }
        }
        _themesStandard.clear();
        Map<String, LayoutTemplate> _themesCustom = this._getThemesCustom(themeId);
        for (Map.Entry<String, LayoutTemplate> entry : _themesCustom.entrySet()) {
            LayoutTemplate layoutTemplate = entry.getValue();
            String templateId = String.valueOf(themeId) + "_CUSTOM_" + layoutTemplate.getLayoutTemplateId();
            try {
                TemplateResourceLoaderUtil.clearCache((String)"vm", (String)templateId);
            }
            catch (Exception e3) {
                _log.error((Object)("Unable to uninstall layout template " + layoutTemplate.getLayoutTemplateId()), (Throwable)e3);
            }
        }
        _themesCustom.clear();
    }

    private List<String> _getColumns(String velocityTemplateId, String velocityTemplateContent) {
        try {
            InitColumnProcessor processor = new InitColumnProcessor();
            Template template = TemplateManagerUtil.getTemplate((String)"vm", (TemplateResource)new StringTemplateResource(velocityTemplateId, velocityTemplateContent), (boolean)false);
            template.put("processor", (Object)processor);
            template.processTemplate((Writer)new DummyWriter());
            return ListUtil.sort(processor.getColumns());
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
            return new ArrayList<String>();
        }
    }

    private Map<String, LayoutTemplate> _getThemesCustom(String themeId) {
        String key = themeId.concat("_CUSTOM_");
        Map<String, LayoutTemplate> layoutTemplates = _themes.get(key);
        if (layoutTemplates == null) {
            layoutTemplates = new LinkedHashMap<String, LayoutTemplate>();
            _themes.put(key, layoutTemplates);
        }
        return layoutTemplates;
    }

    private Map<String, LayoutTemplate> _getThemesStandard(String themeId) {
        String key = String.valueOf(themeId) + "_STANDARD_";
        Map<String, LayoutTemplate> layoutTemplates = _themes.get(key);
        if (layoutTemplates == null) {
            layoutTemplates = new LinkedHashMap<String, LayoutTemplate>();
            _themes.put(key, layoutTemplates);
        }
        return layoutTemplates;
    }

    private Set<ObjectValuePair<String, Boolean>> _readLayoutTemplates(String servletContextName, ServletContext servletContext, String xml, PluginPackage pluginPackage) throws Exception {
        Element customElement;
        HashSet<ObjectValuePair<String, Boolean>> layoutTemplateIdOVPs = new HashSet<ObjectValuePair<String, Boolean>>();
        if (xml == null) {
            return layoutTemplateIdOVPs;
        }
        Document document = SAXReaderUtil.read((String)xml, (boolean)true);
        Element rootElement = document.getRootElement();
        Element standardElement = rootElement.element("standard");
        if (standardElement != null) {
            this.readLayoutTemplate(servletContextName, servletContext, layoutTemplateIdOVPs, standardElement, true, null, pluginPackage);
        }
        if ((customElement = rootElement.element("custom")) != null) {
            this.readLayoutTemplate(servletContextName, servletContext, layoutTemplateIdOVPs, customElement, false, null, pluginPackage);
        }
        return layoutTemplateIdOVPs;
    }
}

