/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.RequiredLayoutSetPrototypeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.LayoutSetPrototypeLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutSetPrototypeLocalServiceImpl
extends LayoutSetPrototypeLocalServiceBaseImpl {
    public LayoutSetPrototype addLayoutSetPrototype(long userId, long companyId, Map<Locale, String> nameMap, String description, boolean active, boolean layoutsUpdateable, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        long layoutSetPrototypeId = this.counterLocalService.increment();
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypePersistence.create(layoutSetPrototypeId);
        layoutSetPrototype.setUuid(serviceContext.getUuid());
        layoutSetPrototype.setCompanyId(companyId);
        layoutSetPrototype.setUserId(userId);
        layoutSetPrototype.setUserName(user.getFullName());
        layoutSetPrototype.setCreateDate(serviceContext.getCreateDate(now));
        layoutSetPrototype.setModifiedDate(serviceContext.getModifiedDate(now));
        layoutSetPrototype.setNameMap(nameMap);
        layoutSetPrototype.setDescription(description);
        layoutSetPrototype.setActive(active);
        UnicodeProperties settingsProperties = layoutSetPrototype.getSettingsProperties();
        settingsProperties.put("layoutsUpdateable", String.valueOf(layoutsUpdateable));
        layoutSetPrototype.setSettingsProperties(settingsProperties);
        this.layoutSetPrototypePersistence.update((BaseModel)layoutSetPrototype);
        if (userId > 0L) {
            this.resourceLocalService.addResources(companyId, 0L, userId, LayoutSetPrototype.class.getName(), layoutSetPrototype.getLayoutSetPrototypeId(), false, false, false);
        }
        String friendlyURL = "/template-" + layoutSetPrototype.getLayoutSetPrototypeId();
        Group group = this.groupLocalService.addGroup(userId, 0L, LayoutSetPrototype.class.getName(), layoutSetPrototype.getLayoutSetPrototypeId(), 0L, layoutSetPrototype.getName(LocaleUtil.getDefault()), null, 0, friendlyURL, false, true, serviceContext);
        if (GetterUtil.getBoolean((Object)serviceContext.getAttribute("addDefaultLayout"), (boolean)true)) {
            this.layoutLocalService.addLayout(userId, group.getGroupId(), true, 0L, "home", null, null, "portlet", false, "/home", serviceContext);
        }
        return layoutSetPrototype;
    }

    @Override
    public LayoutSetPrototype deleteLayoutSetPrototype(LayoutSetPrototype layoutSetPrototype) throws PortalException, SystemException {
        if (this.layoutSetPersistence.countByLayoutSetPrototypeUuid(layoutSetPrototype.getUuid()) > 0) {
            throw new RequiredLayoutSetPrototypeException();
        }
        Group group = layoutSetPrototype.getGroup();
        this.groupLocalService.deleteGroup(group);
        this.resourceLocalService.deleteResource(layoutSetPrototype.getCompanyId(), LayoutSetPrototype.class.getName(), 4, layoutSetPrototype.getLayoutSetPrototypeId());
        this.layoutSetPrototypePersistence.remove((BaseModel)layoutSetPrototype);
        PermissionCacheUtil.clearCache();
        return layoutSetPrototype;
    }

    @Override
    public LayoutSetPrototype deleteLayoutSetPrototype(long layoutSetPrototypeId) throws PortalException, SystemException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypePersistence.findByPrimaryKey(layoutSetPrototypeId);
        return this.deleteLayoutSetPrototype(layoutSetPrototype);
    }

    public void deleteNondefaultLayoutSetPrototypes(long companyId) throws PortalException, SystemException {
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        List layoutSetPrototypes = this.layoutSetPrototypePersistence.findByCompanyId(companyId);
        for (LayoutSetPrototype layoutSetPrototype : layoutSetPrototypes) {
            if (layoutSetPrototype.getUserId() == defaultUserId) continue;
            this.deleteLayoutSetPrototype(layoutSetPrototype);
        }
    }

    public LayoutSetPrototype fetchLayoutSetPrototypeByUuidAndCompanyId(String uuid, long companyId) throws SystemException {
        return this.layoutSetPrototypePersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public LayoutSetPrototype getLayoutSetPrototypeByUuid(String uuid) throws PortalException, SystemException {
        return this.layoutSetPrototypePersistence.findByUuid_First(uuid, null);
    }

    public LayoutSetPrototype getLayoutSetPrototypeByUuidAndCompanyId(String uuid, long companyId) throws PortalException, SystemException {
        return this.layoutSetPrototypePersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<LayoutSetPrototype> search(long companyId, Boolean active, int start, int end, OrderByComparator obc) throws SystemException {
        if (active != null) {
            return this.layoutSetPrototypePersistence.findByC_A(companyId, active.booleanValue(), start, end, obc);
        }
        return this.layoutSetPrototypePersistence.findByCompanyId(companyId, start, end, obc);
    }

    public int searchCount(long companyId, Boolean active) throws SystemException {
        if (active != null) {
            return this.layoutSetPrototypePersistence.countByC_A(companyId, active.booleanValue());
        }
        return this.layoutSetPrototypePersistence.countByCompanyId(companyId);
    }

    public LayoutSetPrototype updateLayoutSetPrototype(long layoutSetPrototypeId, Map<Locale, String> nameMap, String description, boolean active, boolean layoutsUpdateable, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypePersistence.findByPrimaryKey(layoutSetPrototypeId);
        layoutSetPrototype.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        layoutSetPrototype.setNameMap(nameMap);
        layoutSetPrototype.setDescription(description);
        layoutSetPrototype.setActive(active);
        UnicodeProperties settingsProperties = layoutSetPrototype.getSettingsProperties();
        settingsProperties.put("layoutsUpdateable", String.valueOf(layoutsUpdateable));
        layoutSetPrototype.setSettingsProperties(settingsProperties);
        this.layoutSetPrototypePersistence.update((BaseModel)layoutSetPrototype);
        Group group = this.groupLocalService.getLayoutSetPrototypeGroup(layoutSetPrototype.getCompanyId(), layoutSetPrototypeId);
        group.setName(layoutSetPrototype.getName(LocaleUtil.getDefault()));
        this.groupPersistence.update((BaseModel)group);
        return layoutSetPrototype;
    }

    public LayoutSetPrototype updateLayoutSetPrototype(long layoutSetPrototypeId, String settings) throws PortalException, SystemException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypePersistence.findByPrimaryKey(layoutSetPrototypeId);
        layoutSetPrototype.setModifiedDate(new Date());
        layoutSetPrototype.setSettings(settings);
        this.layoutSetPrototypePersistence.update((BaseModel)layoutSetPrototype);
        UnicodeProperties settingsProperties = layoutSetPrototype.getSettingsProperties();
        if (!settingsProperties.containsKey((Object)"customJspServletContextName")) {
            return layoutSetPrototype;
        }
        Group group = this.groupLocalService.getLayoutSetPrototypeGroup(layoutSetPrototype.getCompanyId(), layoutSetPrototypeId);
        UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
        typeSettingsProperties.setProperty("customJspServletContextName", settingsProperties.getProperty("customJspServletContextName"));
        group.setTypeSettings(typeSettingsProperties.toString());
        this.groupPersistence.update((BaseModel)group);
        return layoutSetPrototype;
    }
}

