/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.impl.VirtualLayout;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.sites.util.SitesUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.annotation.Order;

@Order(value=2)
public class LayoutLocalServiceVirtualLayoutsAdvice
implements MethodInterceptor {
    private static final Class<?>[] _TYPES_L = new Class[]{Long.TYPE};
    private static final Class<?>[] _TYPES_L_B_L = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE};
    private static final Class<?>[] _TYPES_L_B_L_B_I_I = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE};
    private static Log _log = LogFactoryUtil.getLog(LayoutLocalServiceVirtualLayoutsAdvice.class);
    private static ThreadLocal<Long> _virtualLayoutTargetGroupId = new AutoResetThreadLocal(LayoutLocalServiceVirtualLayoutsAdvice.class + "._virtualLayoutTargetGroupId", (Object)0L);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object[] parameterTypes;
        Object[] arguments;
        if (MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return methodInvocation.proceed();
        }
        Method method = methodInvocation.getMethod();
        String methodName = method.getName();
        if (MergeLayoutPrototypesThreadLocal.isMergeComplete((String)methodName, (Object[])(arguments = methodInvocation.getArguments()), (Class[])(parameterTypes = method.getParameterTypes()))) {
            return methodInvocation.proceed();
        }
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        if (methodName.equals("getLayout") && (Arrays.equals(parameterTypes, _TYPES_L) || Arrays.equals(parameterTypes, _TYPES_L_B_L))) {
            Layout layout = (Layout)methodInvocation.proceed();
            if (Validator.isNull((String)layout.getLayoutPrototypeUuid()) && Validator.isNull((String)layout.getSourcePrototypeLayoutUuid())) {
                return layout;
            }
            Group group = layout.getGroup();
            LayoutSet layoutSet = layout.getLayoutSet();
            try {
                MergeLayoutPrototypesThreadLocal.setInProgress((boolean)true);
                WorkflowThreadLocal.setEnabled((boolean)false);
                SitesUtil.mergeLayoutPrototypeLayout((Group)group, (Layout)layout);
                if (!Validator.isNotNull((String)layout.getSourcePrototypeLayoutUuid()) || SitesUtil.isLayoutModifiedSinceLastMerge((Layout)layout)) return methodInvocation.proceed();
                SitesUtil.mergeLayoutSetPrototypeLayouts((Group)group, (LayoutSet)layoutSet);
                return methodInvocation.proceed();
            }
            finally {
                MergeLayoutPrototypesThreadLocal.setMergeComplete((String)methodName, (Object[])arguments, (Class[])parameterTypes);
                WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
            }
        } else {
            if (!methodName.equals("getLayouts") || !Arrays.equals(parameterTypes, _TYPES_L_B_L) && !Arrays.equals(parameterTypes, _TYPES_L_B_L_B_I_I)) return methodInvocation.proceed();
            long groupId = (Long)arguments[0];
            boolean privateLayout = (Boolean)arguments[1];
            long parentLayoutId = (Long)arguments[2];
            try {
                long targetGroupId;
                Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
                this.mergeLayoutSetPrototypeLayouts(methodName, arguments, (Class<?>[])parameterTypes, group, layoutSet, privateLayout, workflowEnabled);
                List layouts = (List)methodInvocation.proceed();
                if (PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
                    return layouts;
                }
                if (group.isUser()) {
                    _virtualLayoutTargetGroupId.set(group.getGroupId());
                    if (parentLayoutId != 0L) return this.addChildUserGroupLayouts(group, layouts);
                    return this.addUserGroupLayouts(group, layoutSet, layouts, parentLayoutId);
                }
                if (!group.isUserGroup() || parentLayoutId == 0L || (targetGroupId = _virtualLayoutTargetGroupId.get().longValue()) == 0L) return layouts;
                Group targetGroup = GroupLocalServiceUtil.getGroup((long)targetGroupId);
                return this.addChildUserGroupLayouts(targetGroup, layouts);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
                throw e2;
            }
        }
    }

    protected List<Layout> addChildUserGroupLayouts(Group group, List<Layout> layouts) throws Exception {
        layouts = ListUtil.copy(layouts);
        ArrayList<Layout> childLayouts = new ArrayList<Layout>();
        Iterator iterator = layouts.iterator();
        while (iterator.hasNext()) {
            Layout layout;
            Object childLayout = layout = (Layout)iterator.next();
            Group layoutGroup = layout.getGroup();
            if (layoutGroup.isUserGroup()) {
                childLayout = new VirtualLayout(layout, group);
            }
            childLayouts.add((Layout)childLayout);
        }
        return childLayouts;
    }

    protected List<Layout> addUserGroupLayouts(Group group, LayoutSet layoutSet, List<Layout> layouts, long parentLayoutId) throws Exception {
        layouts = ListUtil.copy(layouts);
        List userUserGroups = UserGroupLocalServiceUtil.getUserUserGroups((long)group.getClassPK());
        for (UserGroup userGroup : userUserGroups) {
            Group userGroupGroup = userGroup.getGroup();
            List userGroupLayouts = LayoutLocalServiceUtil.getLayouts((long)userGroupGroup.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (long)parentLayoutId);
            for (Layout userGroupLayout : userGroupLayouts) {
                VirtualLayout virtualLayout = new VirtualLayout(userGroupLayout, group);
                layouts.add(virtualLayout);
            }
        }
        return layouts;
    }

    protected List<Layout> getPrototypeLinkedLayouts(long groupId, boolean privateLayout) throws SystemException {
        Class<?> clazz = this.getClass();
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(Layout.class, (ClassLoader)clazz.getClassLoader());
        Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
        dynamicQuery.add(groupIdProperty.eq((Object)groupId));
        Property layoutPrototypeUuidProperty = PropertyFactoryUtil.forName((String)"layoutPrototypeUuid");
        dynamicQuery.add(layoutPrototypeUuidProperty.isNotNull());
        Property privateLayoutProperty = PropertyFactoryUtil.forName((String)"privateLayout");
        dynamicQuery.add(privateLayoutProperty.eq((Object)privateLayout));
        Property sourcePrototypeLayoutUuidProperty = PropertyFactoryUtil.forName((String)"sourcePrototypeLayoutUuid");
        dynamicQuery.add(sourcePrototypeLayoutUuidProperty.isNotNull());
        return LayoutLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
    }

    /*
     * Exception decompiling
     */
    protected void mergeLayoutSetPrototypeLayouts(String methodName, Object[] arguments, Class<?>[] parameterTypes, Group group, LayoutSet layoutSet, boolean privateLayout, boolean workflowEnabled) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

