/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.LayoutFriendlyURLException;
import com.liferay.portal.LayoutNameException;
import com.liferay.portal.LayoutParentLayoutIdException;
import com.liferay.portal.LayoutTypeException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.bean.IdentifiableBean;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutFriendlyURL;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.service.persistence.LayoutFriendlyURLPersistence;
import com.liferay.portal.service.persistence.LayoutPersistence;
import com.liferay.portal.service.persistence.LayoutSetPersistence;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.comparator.LayoutPriorityComparator;
import com.liferay.portlet.sites.util.SitesUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutLocalServiceHelper
implements IdentifiableBean {
    @BeanReference(type=LayoutFriendlyURLPersistence.class)
    protected LayoutFriendlyURLPersistence layoutFriendlyURLPersistence;
    @BeanReference(type=LayoutPersistence.class)
    protected LayoutPersistence layoutPersistence;
    @BeanReference(type=LayoutSetPersistence.class)
    protected LayoutSetPersistence layoutSetPersistence;
    private static final int _PRIORITY_BUFFER = 1000000;
    private String _beanIdentifier;

    public String getBeanIdentifier() {
        return this._beanIdentifier;
    }

    public String getFriendlyURL(long groupId, boolean privateLayout, long layoutId, String name, String friendlyURL) throws PortalException, SystemException {
        if (Validator.isNotNull((String)(friendlyURL = this.getFriendlyURL(friendlyURL)))) {
            return friendlyURL;
        }
        String originalFriendlyURL = friendlyURL = "/" + this.getFriendlyURL(name);
        int i2 = 1;
        while (true) {
            try {
                this.validateFriendlyURL(groupId, privateLayout, layoutId, friendlyURL);
            }
            catch (LayoutFriendlyURLException lfurle) {
                int type = lfurle.getType();
                if (type != 6) {
                    friendlyURL = "/" + layoutId;
                    break;
                }
                friendlyURL = String.valueOf(originalFriendlyURL) + i2;
                ++i2;
                continue;
            }
            break;
        }
        return friendlyURL;
    }

    public String getFriendlyURL(String friendlyURL) {
        return FriendlyURLNormalizerUtil.normalize((String)friendlyURL);
    }

    public Map<Locale, String> getFriendlyURLMap(long groupId, boolean privateLayout, long layoutId, String name, Map<Locale, String> friendlyURLMap) throws PortalException, SystemException {
        Locale[] locales;
        HashMap<Locale, String> newFriendlyURLMap = new HashMap<Locale, String>();
        Locale[] localeArray = locales = LanguageUtil.getAvailableLocales();
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String friendlyURL = friendlyURLMap.get(locale);
            if (Validator.isNotNull((String)friendlyURL)) {
                friendlyURL = this.getFriendlyURL(groupId, privateLayout, layoutId, name, friendlyURL);
                newFriendlyURLMap.put(locale, friendlyURL);
            }
            ++n2;
        }
        if (newFriendlyURLMap.isEmpty()) {
            String friendlyURL = this.getFriendlyURL(groupId, privateLayout, layoutId, name, "");
            newFriendlyURLMap.put(LocaleUtil.getDefault(), friendlyURL);
        }
        return newFriendlyURLMap;
    }

    public int getNextPriority(long groupId, boolean privateLayout, long parentLayoutId, String sourcePrototypeLayoutUuid, int defaultPriority) throws SystemException {
        try {
            LayoutSet layoutSet;
            int priority = defaultPriority;
            if (priority < 0) {
                Layout layout = this.layoutPersistence.findByG_P_P_First(groupId, privateLayout, parentLayoutId, (OrderByComparator)new LayoutPriorityComparator(false));
                priority = layout.getPriority() + 1;
            }
            if (priority < 1000000 && Validator.isNull((String)sourcePrototypeLayoutUuid) && Validator.isNotNull((String)(layoutSet = this.layoutSetPersistence.fetchByG_P(groupId, privateLayout)).getLayoutSetPrototypeUuid())) {
                priority += 1000000;
            }
            return priority;
        }
        catch (NoSuchLayoutException noSuchLayoutException) {
            return 0;
        }
    }

    public long getParentLayoutId(long groupId, boolean privateLayout, long parentLayoutId) throws SystemException {
        Layout parentLayout;
        if (parentLayoutId != 0L && (parentLayout = this.layoutPersistence.fetchByG_P_L(groupId, privateLayout, parentLayoutId)) == null) {
            parentLayoutId = 0L;
        }
        return parentLayoutId;
    }

    public boolean hasLayoutSetPrototypeLayout(LayoutSetPrototype layoutSetPrototype, String layoutUuid) throws PortalException, SystemException {
        Layout layout = this.layoutPersistence.fetchByUUID_G_P(layoutUuid, layoutSetPrototype.getGroupId(), true);
        return layout != null;
    }

    public void setBeanIdentifier(String beanIdentifier) {
        this._beanIdentifier = beanIdentifier;
    }

    public void validate(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, String name, String type, boolean hidden, Map<Locale, String> friendlyURLMap) throws PortalException, SystemException {
        this.validateName(name);
        boolean firstLayout = false;
        if (parentLayoutId == 0L) {
            List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId, 0, 1);
            if (layouts.size() == 0) {
                firstLayout = true;
            } else {
                long firstLayoutId = ((Layout)layouts.get(0)).getLayoutId();
                if (firstLayoutId == layoutId) {
                    firstLayout = true;
                }
            }
        }
        if (firstLayout) {
            this.validateFirstLayout(type);
        }
        if (!PortalUtil.isLayoutParentable((String)type) && this.layoutPersistence.countByG_P_P(groupId, privateLayout, layoutId) > 0) {
            throw new LayoutTypeException(1);
        }
        this.validateFriendlyURLs(groupId, privateLayout, layoutId, friendlyURLMap);
    }

    public void validateFirstLayout(String type) throws PortalException {
        if (Validator.isNull((String)type) || !PortalUtil.isLayoutFirstPageable((String)type)) {
            LayoutTypeException lte = new LayoutTypeException(2);
            lte.setLayoutType(type);
            throw lte;
        }
    }

    public void validateFriendlyURL(long groupId, boolean privateLayout, long layoutId, String friendlyURL) throws PortalException, SystemException {
        if (Validator.isNull((String)friendlyURL)) {
            return;
        }
        int exceptionType = LayoutImpl.validateFriendlyURL(friendlyURL);
        if (exceptionType != -1) {
            throw new LayoutFriendlyURLException(exceptionType);
        }
        List layoutFriendlyURLs = this.layoutFriendlyURLPersistence.findByG_P_F(groupId, privateLayout, friendlyURL);
        for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
            Layout layout = this.layoutPersistence.findByPrimaryKey(layoutFriendlyURL.getPlid());
            if (layout.getLayoutId() == layoutId) continue;
            throw new LayoutFriendlyURLException(6);
        }
        LayoutImpl.validateFriendlyURLKeyword(friendlyURL);
        String layoutIdFriendlyURL = friendlyURL.substring(1);
        if (Validator.isNumber((String)layoutIdFriendlyURL) && !layoutIdFriendlyURL.equals(String.valueOf(layoutId))) {
            LayoutFriendlyURLException lfurle = new LayoutFriendlyURLException(8);
            lfurle.setKeywordConflict(layoutIdFriendlyURL);
            throw lfurle;
        }
    }

    public void validateFriendlyURLs(long groupId, boolean privateLayout, long layoutId, Map<Locale, String> friendlyURLMap) throws PortalException, SystemException {
        for (Map.Entry<Locale, String> entry : friendlyURLMap.entrySet()) {
            String friendlyURL = entry.getValue();
            this.validateFriendlyURL(groupId, privateLayout, layoutId, friendlyURL);
        }
    }

    public void validateName(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new LayoutNameException();
        }
    }

    public void validateName(String name, String languageId) throws PortalException {
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        if (defaultLanguageId.equals(languageId)) {
            this.validateName(name);
        }
    }

    public void validateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException, SystemException {
        List layouts;
        long firstLayoutId;
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        if (parentLayoutId == layout.getParentLayoutId()) {
            return;
        }
        if (parentLayoutId == 0L) {
            return;
        }
        Layout parentLayout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, parentLayoutId);
        if (!PortalUtil.isLayoutParentable((Layout)parentLayout)) {
            throw new LayoutParentLayoutIdException(1);
        }
        if (!SitesUtil.isLayoutSortable((Layout)parentLayout)) {
            throw new LayoutParentLayoutIdException(5);
        }
        if (PortalUtil.isLayoutDescendant((Layout)layout, (long)parentLayoutId)) {
            throw new LayoutParentLayoutIdException(2);
        }
        if (layout.getParentLayoutId() == 0L && (firstLayoutId = ((Layout)(layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, 0L, 0, 2)).get(0)).getLayoutId()) == layoutId) {
            Layout secondLayout = (Layout)layouts.get(1);
            try {
                this.validateFirstLayout(secondLayout.getType());
            }
            catch (LayoutTypeException layoutTypeException) {
                throw new LayoutParentLayoutIdException(3);
            }
        }
    }
}

