/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchImageException;
import com.liferay.portal.image.HookFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.Hook;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.base.ImageLocalServiceBaseImpl;
import com.liferay.portal.webserver.WebServerServletTokenUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;

public class ImageLocalServiceImpl
extends ImageLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(ImageLocalServiceImpl.class);

    @Override
    public Image deleteImage(long imageId) throws PortalException, SystemException {
        Image image;
        block4: {
            if (imageId <= 0L) {
                return null;
            }
            image = this.getImage(imageId);
            if (image != null) {
                this.imagePersistence.remove((BaseModel)image);
                Hook hook = HookFactory.getInstance();
                try {
                    hook.deleteImage(image);
                }
                catch (NoSuchImageException nsie) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)nsie, (Throwable)nsie);
                }
            }
        }
        return image;
    }

    public Image getCompanyLogo(long imageId) {
        Image image = this.getImage(imageId);
        if (image == null) {
            image = ImageToolUtil.getDefaultCompanyLogo();
        }
        return image;
    }

    @Override
    public Image getImage(long imageId) {
        block3: {
            if (imageId > 0L) {
                try {
                    return this.imagePersistence.fetchByPrimaryKey(imageId);
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to get image " + imageId + ": " + e2.getMessage()));
                }
            }
        }
        return null;
    }

    public Image getImageOrDefault(long imageId) {
        Image image = this.getImage(imageId);
        if (image == null) {
            image = ImageToolUtil.getDefaultSpacer();
        }
        return image;
    }

    public List<Image> getImages() throws SystemException {
        return this.imagePersistence.findAll();
    }

    public List<Image> getImagesBySize(int size) throws SystemException {
        return this.imagePersistence.findByLtSize(size);
    }

    public Image updateImage(long imageId, byte[] bytes) throws PortalException, SystemException {
        Image image = null;
        try {
            image = ImageToolUtil.getImage((byte[])bytes);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return this.updateImage(imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
    }

    public Image updateImage(long imageId, byte[] bytes, String type, int height, int width, int size) throws PortalException, SystemException {
        Image image = this.imagePersistence.fetchByPrimaryKey(imageId);
        if (image == null) {
            image = this.imagePersistence.create(imageId);
        }
        image.setModifiedDate(new Date());
        image.setType(type);
        image.setHeight(height);
        image.setWidth(width);
        image.setSize(size);
        Hook hook = HookFactory.getInstance();
        hook.updateImage(image, type, bytes);
        this.imagePersistence.update((BaseModel)image);
        WebServerServletTokenUtil.resetToken((long)imageId);
        return image;
    }

    public Image updateImage(long imageId, File file) throws PortalException, SystemException {
        Image image = null;
        try {
            image = ImageToolUtil.getImage((File)file);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return this.updateImage(imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
    }

    public Image updateImage(long imageId, InputStream is) throws PortalException, SystemException {
        Image image = null;
        try {
            image = ImageToolUtil.getImage((InputStream)is);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return this.updateImage(imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
    }

    public Image updateImage(long imageId, InputStream is, boolean cleanUpStream) throws PortalException, SystemException {
        Image image = null;
        try {
            image = ImageToolUtil.getImage((InputStream)is, (boolean)cleanUpStream);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return this.updateImage(imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
    }
}

