/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.EmailAddressException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.EmailAddressLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import java.util.Date;
import java.util.List;

public class EmailAddressLocalServiceImpl
extends EmailAddressLocalServiceBaseImpl {
    public EmailAddress addEmailAddress(long userId, String className, long classPK, String address, int typeId, boolean primary) throws PortalException, SystemException {
        return this.addEmailAddress(userId, className, classPK, address, typeId, primary, new ServiceContext());
    }

    public EmailAddress addEmailAddress(long userId, String className, long classPK, String address, int typeId, boolean primary, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        this.validate(0L, user.getCompanyId(), classNameId, classPK, address, typeId, primary);
        long emailAddressId = this.counterLocalService.increment();
        EmailAddress emailAddress = this.emailAddressPersistence.create(emailAddressId);
        emailAddress.setUuid(serviceContext.getUuid());
        emailAddress.setCompanyId(user.getCompanyId());
        emailAddress.setUserId(user.getUserId());
        emailAddress.setUserName(user.getFullName());
        emailAddress.setCreateDate(serviceContext.getCreateDate(now));
        emailAddress.setModifiedDate(serviceContext.getModifiedDate(now));
        emailAddress.setClassNameId(classNameId);
        emailAddress.setClassPK(classPK);
        emailAddress.setAddress(address);
        emailAddress.setTypeId(typeId);
        emailAddress.setPrimary(primary);
        this.emailAddressPersistence.update((BaseModel)emailAddress);
        return emailAddress;
    }

    public void deleteEmailAddresses(long companyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        List emailAddresses = this.emailAddressPersistence.findByC_C_C(companyId, classNameId, classPK);
        for (EmailAddress emailAddress : emailAddresses) {
            this.deleteEmailAddress(emailAddress);
        }
    }

    public EmailAddress fetchEmailAddressByUuidAndCompanyId(String uuid, long companyId) throws SystemException {
        return this.emailAddressPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public List<EmailAddress> getEmailAddresses() throws SystemException {
        return this.emailAddressPersistence.findAll();
    }

    public List<EmailAddress> getEmailAddresses(long companyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.emailAddressPersistence.findByC_C_C(companyId, classNameId, classPK);
    }

    public EmailAddress updateEmailAddress(long emailAddressId, String address, int typeId, boolean primary) throws PortalException, SystemException {
        this.validate(emailAddressId, 0L, 0L, 0L, address, typeId, primary);
        EmailAddress emailAddress = this.emailAddressPersistence.findByPrimaryKey(emailAddressId);
        emailAddress.setModifiedDate(new Date());
        emailAddress.setAddress(address);
        emailAddress.setTypeId(typeId);
        emailAddress.setPrimary(primary);
        this.emailAddressPersistence.update((BaseModel)emailAddress);
        return emailAddress;
    }

    protected void validate(long emailAddressId, long companyId, long classNameId, long classPK, boolean primary) throws SystemException {
        if (primary) {
            List emailAddresses = this.emailAddressPersistence.findByC_C_C_P(companyId, classNameId, classPK, primary);
            for (EmailAddress emailAddress : emailAddresses) {
                if (emailAddressId > 0L && emailAddress.getEmailAddressId() == emailAddressId) continue;
                emailAddress.setPrimary(false);
                this.emailAddressPersistence.update((BaseModel)emailAddress);
            }
        }
    }

    protected void validate(long emailAddressId, long companyId, long classNameId, long classPK, String address, int typeId, boolean primary) throws PortalException, SystemException {
        if (!Validator.isEmailAddress((String)address)) {
            throw new EmailAddressException();
        }
        if (emailAddressId > 0L) {
            EmailAddress emailAddress = this.emailAddressPersistence.findByPrimaryKey(emailAddressId);
            companyId = emailAddress.getCompanyId();
            classNameId = emailAddress.getClassNameId();
            classPK = emailAddress.getClassPK();
        }
        this.listTypeService.validate(typeId, classNameId, ".emailAddress");
        this.validate(emailAddressId, companyId, classNameId, classPK, primary);
    }
}

