/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackRegistryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.BackgroundTaskLocalServiceBaseImpl;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class BackgroundTaskLocalServiceImpl
extends BackgroundTaskLocalServiceBaseImpl {
    public BackgroundTask addBackgroundTask(long userId, long groupId, String name, String[] servletContextNames, Class<?> taskExecutorClass, Map<String, Serializable> taskContextMap, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        final long backgroundTaskId = this.counterLocalService.increment();
        BackgroundTask backgroundTask = this.backgroundTaskPersistence.create(backgroundTaskId);
        backgroundTask.setCompanyId(user.getCompanyId());
        backgroundTask.setCreateDate(serviceContext.getCreateDate(now));
        backgroundTask.setGroupId(groupId);
        backgroundTask.setModifiedDate(serviceContext.getModifiedDate(now));
        backgroundTask.setUserId(userId);
        backgroundTask.setUserName(user.getFullName());
        backgroundTask.setName(name);
        backgroundTask.setServletContextNames(StringUtil.merge((Object[])servletContextNames));
        backgroundTask.setTaskExecutorClassName(taskExecutorClass.getName());
        if (taskContextMap != null) {
            String taskContext = JSONFactoryUtil.serialize(taskContextMap);
            backgroundTask.setTaskContext(taskContext);
        }
        backgroundTask.setStatus(0);
        this.backgroundTaskPersistence.update((BaseModel)backgroundTask);
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Message message = new Message();
                message.put("backgroundTaskId", (Object)backgroundTaskId);
                MessageBusUtil.sendMessage((String)"liferay/background_task", (Message)message);
                return null;
            }
        });
        return backgroundTask;
    }

    public void addBackgroundTaskAttachment(long userId, long backgroundTaskId, String fileName, File file) throws PortalException, SystemException {
        BackgroundTask backgroundTask = this.getBackgroundTask(backgroundTaskId);
        Folder folder = backgroundTask.addAttachmentsFolder();
        PortletFileRepositoryUtil.addPortletFileEntry((long)backgroundTask.getGroupId(), (long)userId, (String)BackgroundTask.class.getName(), (long)backgroundTask.getPrimaryKey(), (String)"189", (long)folder.getFolderId(), (File)file, (String)fileName, null);
    }

    public void addBackgroundTaskAttachment(long userId, long backgroundTaskId, String fileName, InputStream inputStream) throws PortalException, SystemException {
        BackgroundTask backgroundTask = this.getBackgroundTask(backgroundTaskId);
        Folder folder = backgroundTask.addAttachmentsFolder();
        PortletFileRepositoryUtil.addPortletFileEntry((long)backgroundTask.getGroupId(), (long)userId, (String)BackgroundTask.class.getName(), (long)backgroundTask.getPrimaryKey(), (String)"189", (long)folder.getFolderId(), (InputStream)inputStream, (String)fileName, null);
    }

    @Override
    public BackgroundTask deleteBackgroundTask(BackgroundTask backgroundTask) throws PortalException, SystemException {
        long folderId = backgroundTask.getAttachmentsFolderId();
        if (folderId != 0L) {
            PortletFileRepositoryUtil.deleteFolder((long)folderId);
        }
        return (BackgroundTask)this.backgroundTaskPersistence.remove((BaseModel)backgroundTask);
    }

    @Override
    public BackgroundTask fetchBackgroundTask(long backgroundTaskId) throws SystemException {
        return this.backgroundTaskPersistence.fetchByPrimaryKey(backgroundTaskId);
    }

    public BackgroundTask fetchFirstBackgroundTask(String taskExecutorClassName, int status) throws SystemException {
        return this.fetchFirstBackgroundTask(taskExecutorClassName, status, null);
    }

    public BackgroundTask fetchFirstBackgroundTask(String taskExecutorClassName, int status, OrderByComparator orderByComparator) throws SystemException {
        return this.backgroundTaskPersistence.fetchByT_S_First(taskExecutorClassName, status, orderByComparator);
    }

    @Override
    public BackgroundTask getBackgroundTask(long backgroundTaskId) throws PortalException, SystemException {
        return this.backgroundTaskPersistence.findByPrimaryKey(backgroundTaskId);
    }

    public List<BackgroundTask> getBackgroundTasks(long groupId, String taskExecutorClassName) throws SystemException {
        return this.backgroundTaskPersistence.findByG_T(groupId, taskExecutorClassName);
    }

    public List<BackgroundTask> getBackgroundTasks(long groupId, String taskExecutorClassName, int status) throws SystemException {
        return this.backgroundTaskPersistence.findByG_T_S(groupId, taskExecutorClassName, status);
    }

    public List<BackgroundTask> getBackgroundTasks(String taskExecutorClassName, int status) throws SystemException {
        return this.backgroundTaskPersistence.findByT_S(taskExecutorClassName, status);
    }

    public List<BackgroundTask> getBackgroundTasks(String taskExecutorClassName, int status, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.backgroundTaskPersistence.findByT_S(taskExecutorClassName, status, start, end, orderByComparator);
    }

    public void resumeBackgroundTask(long backgroundTaskId) throws SystemException {
        BackgroundTask backgroundTask = this.backgroundTaskPersistence.fetchByPrimaryKey(backgroundTaskId);
        if (backgroundTask == null || backgroundTask.getStatus() != 4) {
            return;
        }
        Message message = new Message();
        message.put("backgroundTaskId", (Object)backgroundTaskId);
        MessageBusUtil.sendMessage((String)"liferay/background_task", (Message)message);
    }

    public BackgroundTask updateBackgroundTask(long backgroundTaskId, Map<String, Serializable> taskContextMap, int status, ServiceContext serviceContext) throws PortalException, SystemException {
        Date now = new Date();
        BackgroundTask backgroundTask = this.backgroundTaskPersistence.findByPrimaryKey(backgroundTaskId);
        backgroundTask.setModifiedDate(serviceContext.getModifiedDate(now));
        if (taskContextMap != null) {
            String taskContext = JSONFactoryUtil.serialize(taskContextMap);
            backgroundTask.setTaskContext(taskContext);
        }
        if (status == 2 || status == 3) {
            backgroundTask.setCompleted(true);
            backgroundTask.setCompletionDate(now);
        }
        backgroundTask.setStatus(status);
        this.backgroundTaskPersistence.update((BaseModel)backgroundTask);
        return backgroundTask;
    }
}

