/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Repository;
import com.liferay.portal.model.RepositorySoap;
import com.liferay.portal.service.RepositoryServiceUtil;
import java.rmi.RemoteException;

public class RepositoryServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(RepositoryServiceSoap.class);

    public static void checkRepository(long repositoryId) throws RemoteException {
        try {
            RepositoryServiceUtil.checkRepository((long)repositoryId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void deleteRepository(long repositoryId) throws RemoteException {
        try {
            RepositoryServiceUtil.deleteRepository((long)repositoryId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static RepositorySoap getRepository(long repositoryId) throws RemoteException {
        try {
            Repository returnValue = RepositoryServiceUtil.getRepository((long)repositoryId);
            return RepositorySoap.toSoapModel((Repository)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static String[] getSupportedConfigurations(long classNameId) throws RemoteException {
        try {
            String[] returnValue = RepositoryServiceUtil.getSupportedConfigurations((long)classNameId);
            return returnValue;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static String[] getSupportedParameters(long classNameId, String configuration) throws RemoteException {
        try {
            String[] returnValue = RepositoryServiceUtil.getSupportedParameters((long)classNameId, (String)configuration);
            return returnValue;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static UnicodeProperties getTypeSettingsProperties(long repositoryId) throws RemoteException {
        try {
            UnicodeProperties returnValue = RepositoryServiceUtil.getTypeSettingsProperties((long)repositoryId);
            return returnValue;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void updateRepository(long repositoryId, String name, String description) throws RemoteException {
        try {
            RepositoryServiceUtil.updateRepository((long)repositoryId, (String)name, (String)description);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }
}

