/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutReference;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(LayoutServiceHttp.class);
    private static final Class<?>[] _addLayoutParameterTypes0 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Map.class, Map.class, Map.class, Map.class, Map.class, String.class, Boolean.TYPE, String.class, ServiceContext.class};
    private static final Class<?>[] _addLayoutParameterTypes1 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Map.class, Map.class, Map.class, Map.class, Map.class, String.class, String.class, Boolean.TYPE, Map.class, ServiceContext.class};
    private static final Class<?>[] _addLayoutParameterTypes2 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, String.class, String.class, String.class, String.class, Boolean.TYPE, String.class, ServiceContext.class};
    private static final Class<?>[] _addTempFileEntryParameterTypes3 = new Class[]{Long.TYPE, String.class, String.class, InputStream.class, String.class};
    private static final Class<?>[] _deleteLayoutParameterTypes4 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, ServiceContext.class};
    private static final Class<?>[] _deleteLayoutParameterTypes5 = new Class[]{Long.TYPE, ServiceContext.class};
    private static final Class<?>[] _deleteTempFileEntryParameterTypes6 = new Class[]{Long.TYPE, String.class, String.class};
    private static final Class<?>[] _exportLayoutsParameterTypes7 = new Class[]{Long.TYPE, Boolean.TYPE, long[].class, Map.class, Date.class, Date.class};
    private static final Class<?>[] _exportLayoutsParameterTypes8 = new Class[]{Long.TYPE, Boolean.TYPE, Map.class, Date.class, Date.class};
    private static final Class<?>[] _exportLayoutsAsFileParameterTypes9 = new Class[]{Long.TYPE, Boolean.TYPE, long[].class, Map.class, Date.class, Date.class};
    private static final Class<?>[] _exportLayoutsAsFileInBackgroundParameterTypes10 = new Class[]{String.class, Long.TYPE, Boolean.TYPE, long[].class, Map.class, Date.class, Date.class};
    private static final Class<?>[] _exportPortletInfoParameterTypes11 = new Class[]{Long.TYPE, Long.TYPE, String.class, Map.class, Date.class, Date.class};
    private static final Class<?>[] _exportPortletInfoAsFileParameterTypes12 = new Class[]{Long.TYPE, Long.TYPE, String.class, Map.class, Date.class, Date.class};
    private static final Class<?>[] _exportPortletInfoAsFileInBackgroundParameterTypes13 = new Class[]{String.class, Long.TYPE, Long.TYPE, String.class, Map.class, Date.class, Date.class};
    private static final Class<?>[] _getAncestorLayoutsParameterTypes14 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getDefaultPlidParameterTypes15 = new Class[]{Long.TYPE, Long.TYPE, Boolean.TYPE, String.class};
    private static final Class<?>[] _getDefaultPlidParameterTypes16 = new Class[]{Long.TYPE, Long.TYPE, String.class};
    private static final Class<?>[] _getLayoutByUuidAndGroupIdParameterTypes17 = new Class[]{String.class, Long.TYPE, Boolean.TYPE};
    private static final Class<?>[] _getLayoutNameParameterTypes18 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, String.class};
    private static final Class<?>[] _getLayoutReferencesParameterTypes19 = new Class[]{Long.TYPE, String.class, String.class, String.class};
    private static final Class<?>[] _getLayoutsParameterTypes20 = new Class[]{Long.TYPE, Boolean.TYPE};
    private static final Class<?>[] _getLayoutsParameterTypes21 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE};
    private static final Class<?>[] _getLayoutsParameterTypes22 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getTempFileEntryNamesParameterTypes23 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _importLayoutsParameterTypes24 = new Class[]{Long.TYPE, Boolean.TYPE, Map.class, byte[].class};
    private static final Class<?>[] _importLayoutsParameterTypes25 = new Class[]{Long.TYPE, Boolean.TYPE, Map.class, File.class};
    private static final Class<?>[] _importLayoutsParameterTypes26 = new Class[]{Long.TYPE, Boolean.TYPE, Map.class, InputStream.class};
    private static final Class<?>[] _importLayoutsInBackgroundParameterTypes27 = new Class[]{String.class, Long.TYPE, Boolean.TYPE, Map.class, File.class};
    private static final Class<?>[] _importPortletInfoParameterTypes28 = new Class[]{Long.TYPE, Long.TYPE, String.class, Map.class, File.class};
    private static final Class<?>[] _importPortletInfoParameterTypes29 = new Class[]{Long.TYPE, Long.TYPE, String.class, Map.class, InputStream.class};
    private static final Class<?>[] _importPortletInfoInBackgroundParameterTypes30 = new Class[]{String.class, Long.TYPE, Long.TYPE, String.class, Map.class, File.class};
    private static final Class<?>[] _importPortletInfoInBackgroundParameterTypes31 = new Class[]{String.class, Long.TYPE, Long.TYPE, String.class, Map.class, InputStream.class};
    private static final Class<?>[] _schedulePublishToLiveParameterTypes32 = new Class[]{Long.TYPE, Long.TYPE, Boolean.TYPE, Map.class, Map.class, String.class, Date.class, Date.class, String.class, String.class, Date.class, Date.class, String.class};
    private static final Class<?>[] _schedulePublishToRemoteParameterTypes33 = new Class[]{Long.TYPE, Boolean.TYPE, Map.class, Map.class, String.class, Integer.TYPE, String.class, Boolean.TYPE, Long.TYPE, Boolean.TYPE, Date.class, Date.class, String.class, String.class, Date.class, Date.class, String.class};
    private static final Class<?>[] _setLayoutsParameterTypes34 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, long[].class, ServiceContext.class};
    private static final Class<?>[] _unschedulePublishToLiveParameterTypes35 = new Class[]{Long.TYPE, String.class, String.class};
    private static final Class<?>[] _unschedulePublishToRemoteParameterTypes36 = new Class[]{Long.TYPE, String.class, String.class};
    private static final Class<?>[] _updateLayoutParameterTypes37 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Map.class, Map.class, Map.class, Map.class, Map.class, String.class, Boolean.TYPE, Map.class, Boolean.class, byte[].class, ServiceContext.class};
    private static final Class<?>[] _updateLayoutParameterTypes38 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Map.class, Map.class, Map.class, Map.class, Map.class, String.class, Boolean.TYPE, String.class, Boolean.class, byte[].class, ServiceContext.class};
    private static final Class<?>[] _updateLayoutParameterTypes39 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, String.class};
    private static final Class<?>[] _updateLookAndFeelParameterTypes40 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, String.class, String.class, String.class, Boolean.TYPE};
    private static final Class<?>[] _updateNameParameterTypes41 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, String.class, String.class};
    private static final Class<?>[] _updateNameParameterTypes42 = new Class[]{Long.TYPE, String.class, String.class};
    private static final Class<?>[] _updateParentLayoutIdParameterTypes43 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE};
    private static final Class<?>[] _updateParentLayoutIdParameterTypes44 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _updatePriorityParameterTypes45 = new Class[]{Long.TYPE, Boolean.TYPE, Long.TYPE, Integer.TYPE};
    private static final Class<?>[] _updatePriorityParameterTypes46 = new Class[]{Long.TYPE, Integer.TYPE};
    private static final Class<?>[] _validateImportLayoutsFileParameterTypes47 = new Class[]{Long.TYPE, Boolean.TYPE, Map.class, File.class};

    public static Layout addLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "addLayout", (Class[])_addLayoutParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parentLayoutId, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURL, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout addLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "addLayout", (Class[])_addLayoutParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parentLayoutId, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, friendlyURLMap, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout addLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "addLayout", (Class[])_addLayoutParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parentLayoutId, name, title, description, type, hidden, friendlyURL, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static FileEntry addTempFileEntry(HttpPrincipal httpPrincipal, long groupId, String fileName, String tempFolderName, InputStream inputStream, String mimeType) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "addTempFileEntry", (Class[])_addTempFileEntryParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, fileName, tempFolderName, inputStream, mimeType});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (FileEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "deleteLayout", (Class[])_deleteLayoutParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, serviceContext});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteLayout(HttpPrincipal httpPrincipal, long plid, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "deleteLayout", (Class[])_deleteLayoutParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, serviceContext});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteTempFileEntry(HttpPrincipal httpPrincipal, long groupId, String fileName, String tempFolderName) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "deleteTempFileEntry", (Class[])_deleteTempFileEntryParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, fileName, tempFolderName});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static byte[] exportLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "exportLayouts", (Class[])_exportLayoutsParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutIds, parameterMap, startDate, endDate});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (byte[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static byte[] exportLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "exportLayouts", (Class[])_exportLayoutsParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parameterMap, startDate, endDate});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (byte[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static File exportLayoutsAsFile(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "exportLayoutsAsFile", (Class[])_exportLayoutsAsFileParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutIds, parameterMap, startDate, endDate});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (File)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long exportLayoutsAsFileInBackground(HttpPrincipal httpPrincipal, String taskName, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "exportLayoutsAsFileInBackground", (Class[])_exportLayoutsAsFileInBackgroundParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{taskName, groupId, privateLayout, layoutIds, parameterMap, startDate, endDate});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Long)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static byte[] exportPortletInfo(HttpPrincipal httpPrincipal, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "exportPortletInfo", (Class[])_exportPortletInfoParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, groupId, portletId, parameterMap, startDate, endDate});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (byte[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static File exportPortletInfoAsFile(HttpPrincipal httpPrincipal, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "exportPortletInfoAsFile", (Class[])_exportPortletInfoAsFileParameterTypes12);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, groupId, portletId, parameterMap, startDate, endDate});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (File)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long exportPortletInfoAsFileInBackground(HttpPrincipal httpPrincipal, String taskName, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "exportPortletInfoAsFileInBackground", (Class[])_exportPortletInfoAsFileInBackgroundParameterTypes13);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{taskName, plid, groupId, portletId, parameterMap, startDate, endDate});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Long)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Layout> getAncestorLayouts(HttpPrincipal httpPrincipal, long plid) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "getAncestorLayouts", (Class[])_getAncestorLayoutsParameterTypes14);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long getDefaultPlid(HttpPrincipal httpPrincipal, long groupId, long scopeGroupId, boolean privateLayout, String portletId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "getDefaultPlid", (Class[])_getDefaultPlidParameterTypes15);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, scopeGroupId, privateLayout, portletId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Long)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long getDefaultPlid(HttpPrincipal httpPrincipal, long groupId, long scopeGroupId, String portletId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "getDefaultPlid", (Class[])_getDefaultPlidParameterTypes16);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, scopeGroupId, portletId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Long)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout getLayoutByUuidAndGroupId(HttpPrincipal httpPrincipal, String uuid, long groupId, boolean privateLayout) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "getLayoutByUuidAndGroupId", (Class[])_getLayoutByUuidAndGroupIdParameterTypes17);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{uuid, groupId, privateLayout});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static String getLayoutName(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, String languageId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "getLayoutName", (Class[])_getLayoutNameParameterTypes18);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, languageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (String)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static LayoutReference[] getLayoutReferences(HttpPrincipal httpPrincipal, long companyId, String portletId, String preferencesKey, String preferencesValue) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "getLayoutReferences", (Class[])_getLayoutReferencesParameterTypes19);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, portletId, preferencesKey, preferencesValue});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (LayoutReference[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Layout> getLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "getLayouts", (Class[])_getLayoutsParameterTypes20);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Layout> getLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long parentLayoutId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "getLayouts", (Class[])_getLayoutsParameterTypes21);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parentLayoutId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Layout> getLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, int start, int end) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "getLayouts", (Class[])_getLayoutsParameterTypes22);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parentLayoutId, incomplete, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static String[] getTempFileEntryNames(HttpPrincipal httpPrincipal, long groupId, String tempFolderName) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "getTempFileEntryNames", (Class[])_getTempFileEntryNamesParameterTypes23);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, tempFolderName});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (String[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, byte[] bytes) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "importLayouts", (Class[])_importLayoutsParameterTypes24);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parameterMap, bytes});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "importLayouts", (Class[])_importLayoutsParameterTypes25);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parameterMap, file});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "importLayouts", (Class[])_importLayoutsParameterTypes26);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parameterMap, is});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long importLayoutsInBackground(HttpPrincipal httpPrincipal, String taskName, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "importLayoutsInBackground", (Class[])_importLayoutsInBackgroundParameterTypes27);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{taskName, groupId, privateLayout, parameterMap, file});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Long)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importPortletInfo(HttpPrincipal httpPrincipal, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "importPortletInfo", (Class[])_importPortletInfoParameterTypes28);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, groupId, portletId, parameterMap, file});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void importPortletInfo(HttpPrincipal httpPrincipal, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "importPortletInfo", (Class[])_importPortletInfoParameterTypes29);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, groupId, portletId, parameterMap, is});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long importPortletInfoInBackground(HttpPrincipal httpPrincipal, String taskName, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "importPortletInfoInBackground", (Class[])_importPortletInfoInBackgroundParameterTypes30);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{taskName, plid, groupId, portletId, parameterMap, file});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Long)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static long importPortletInfoInBackground(HttpPrincipal httpPrincipal, String taskName, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "importPortletInfoInBackground", (Class[])_importPortletInfoInBackgroundParameterTypes31);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{taskName, plid, groupId, portletId, parameterMap, is});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Long)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void schedulePublishToLive(HttpPrincipal httpPrincipal, long sourceGroupId, long targetGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String scope, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "schedulePublishToLive", (Class[])_schedulePublishToLiveParameterTypes32);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{sourceGroupId, targetGroupId, privateLayout, layoutIdMap, parameterMap, scope, startDate, endDate, groupName, cronText, schedulerStartDate, schedulerEndDate, description});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void schedulePublishToRemote(HttpPrincipal httpPrincipal, long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "schedulePublishToRemote", (Class[])_schedulePublishToRemoteParameterTypes33);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{sourceGroupId, privateLayout, layoutIdMap, parameterMap, remoteAddress, remotePort, remotePathContext, secureConnection, remoteGroupId, remotePrivateLayout, startDate, endDate, groupName, cronText, schedulerStartDate, schedulerEndDate, description});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void setLayouts(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long parentLayoutId, long[] layoutIds, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "setLayouts", (Class[])_setLayoutsParameterTypes34);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parentLayoutId, layoutIds, serviceContext});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unschedulePublishToLive(HttpPrincipal httpPrincipal, long groupId, String jobName, String groupName) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "unschedulePublishToLive", (Class[])_unschedulePublishToLiveParameterTypes35);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, jobName, groupName});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unschedulePublishToRemote(HttpPrincipal httpPrincipal, long groupId, String jobName, String groupName) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "unschedulePublishToRemote", (Class[])_unschedulePublishToRemoteParameterTypes36);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, jobName, groupName});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, Map<Locale, String> friendlyURLMap, Boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "updateLayout", (Class[])_updateLayoutParameterTypes37);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, parentLayoutId, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURLMap, iconImage, iconBytes, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, String friendlyURL, Boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "updateLayout", (Class[])_updateLayoutParameterTypes38);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, parentLayoutId, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURL, iconImage, iconBytes, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateLayout(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "updateLayout", (Class[])_updateLayoutParameterTypes39);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, typeSettings});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateLookAndFeel(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css, boolean wapTheme) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "updateLookAndFeel", (Class[])_updateLookAndFeelParameterTypes40);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, themeId, colorSchemeId, css, wapTheme});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateName(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "updateName", (Class[])_updateNameParameterTypes41);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, name, languageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateName(HttpPrincipal httpPrincipal, long plid, String name, String languageId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "updateName", (Class[])_updateNameParameterTypes42);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, name, languageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateParentLayoutId(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "updateParentLayoutId", (Class[])_updateParentLayoutIdParameterTypes43);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, parentLayoutId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updateParentLayoutId(HttpPrincipal httpPrincipal, long plid, long parentPlid) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "updateParentLayoutId", (Class[])_updateParentLayoutIdParameterTypes44);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, parentPlid});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updatePriority(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, long layoutId, int priority) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "updatePriority", (Class[])_updatePriorityParameterTypes45);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, layoutId, priority});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Layout updatePriority(HttpPrincipal httpPrincipal, long plid, int priority) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "updatePriority", (Class[])_updatePriorityParameterTypes46);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{plid, priority});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Layout)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void validateImportLayoutsFile(HttpPrincipal httpPrincipal, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(LayoutServiceUtil.class, "validateImportLayoutsFile", (Class[])_validateImportLayoutsFileParameterTypes47);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, privateLayout, parameterMap, file});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                if (e2 instanceof SystemException) {
                    throw (SystemException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

