/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.GroupSoap;
import com.liferay.portal.model.OrganizationSoap;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.UserGroupSoap;
import com.liferay.portal.model.impl.OrganizationModelImpl;
import com.liferay.portal.model.impl.UserGroupModelImpl;
import com.liferay.portal.service.GroupServiceUtil;
import com.liferay.portal.service.ServiceContext;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;

public class GroupServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(GroupServiceSoap.class);

    public static GroupSoap addGroup(long parentGroupId, long liveGroupId, String name, String description, int type, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws RemoteException {
        try {
            Group returnValue = GroupServiceUtil.addGroup((long)parentGroupId, (long)liveGroupId, (String)name, (String)description, (int)type, (String)friendlyURL, (boolean)site, (boolean)active, (ServiceContext)serviceContext);
            return GroupSoap.toSoapModel((Group)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap addGroup(long parentGroupId, String name, String description, int type, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws RemoteException {
        try {
            Group returnValue = GroupServiceUtil.addGroup((long)parentGroupId, (String)name, (String)description, (int)type, (String)friendlyURL, (boolean)site, (boolean)active, (ServiceContext)serviceContext);
            return GroupSoap.toSoapModel((Group)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap addGroup(String name, String description, int type, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws RemoteException {
        try {
            Group returnValue = GroupServiceUtil.addGroup((String)name, (String)description, (int)type, (String)friendlyURL, (boolean)site, (boolean)active, (ServiceContext)serviceContext);
            return GroupSoap.toSoapModel((Group)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void addRoleGroups(long roleId, long[] groupIds) throws RemoteException {
        try {
            GroupServiceUtil.addRoleGroups((long)roleId, (long[])groupIds);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void checkRemoteStagingGroup(long groupId) throws RemoteException {
        try {
            GroupServiceUtil.checkRemoteStagingGroup((long)groupId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void deleteGroup(long groupId) throws RemoteException {
        try {
            GroupServiceUtil.deleteGroup((long)groupId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap getCompanyGroup(long companyId) throws RemoteException {
        try {
            Group returnValue = GroupServiceUtil.getCompanyGroup((long)companyId);
            return GroupSoap.toSoapModel((Group)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap getGroup(long groupId) throws RemoteException {
        try {
            Group returnValue = GroupServiceUtil.getGroup((long)groupId);
            return GroupSoap.toSoapModel((Group)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap getGroup(long companyId, String name) throws RemoteException {
        try {
            Group returnValue = GroupServiceUtil.getGroup((long)companyId, (String)name);
            return GroupSoap.toSoapModel((Group)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap[] getGroups(long companyId, long parentGroupId, boolean site) throws RemoteException {
        try {
            List returnValue = GroupServiceUtil.getGroups((long)companyId, (long)parentGroupId, (boolean)site);
            return GroupSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap[] getManageableSites(Collection<Portlet> portlets, int max) throws RemoteException {
        try {
            List returnValue = GroupServiceUtil.getManageableSites(portlets, (int)max);
            return GroupSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap[] getOrganizationsGroups(OrganizationSoap[] organizations) throws RemoteException {
        try {
            List returnValue = GroupServiceUtil.getOrganizationsGroups(OrganizationModelImpl.toModels(organizations));
            return GroupSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap getUserGroup(long companyId, long userId) throws RemoteException {
        try {
            Group returnValue = GroupServiceUtil.getUserGroup((long)companyId, (long)userId);
            return GroupSoap.toSoapModel((Group)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap[] getUserGroupsGroups(UserGroupSoap[] userGroups) throws RemoteException {
        try {
            List returnValue = GroupServiceUtil.getUserGroupsGroups(UserGroupModelImpl.toModels(userGroups));
            return GroupSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap[] getUserOrganizationsGroups(long userId, int start, int end) throws RemoteException {
        try {
            List returnValue = GroupServiceUtil.getUserOrganizationsGroups((long)userId, (int)start, (int)end);
            return GroupSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap[] getUserPlaces(long userId, String[] classNames, boolean includeControlPanel, int max) throws RemoteException {
        try {
            List returnValue = GroupServiceUtil.getUserPlaces((long)userId, (String[])classNames, (boolean)includeControlPanel, (int)max);
            return GroupSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap[] getUserPlaces(long userId, String[] classNames, int max) throws RemoteException {
        try {
            List returnValue = GroupServiceUtil.getUserPlaces((long)userId, (String[])classNames, (int)max);
            return GroupSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap[] getUserPlaces(long userId, String[] classNames, String name, boolean active, boolean includeControlPanel, int start, int end) throws RemoteException {
        try {
            List returnValue = GroupServiceUtil.getUserPlaces((long)userId, (String[])classNames, (String)name, (boolean)active, (boolean)includeControlPanel, (int)start, (int)end);
            return GroupSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap[] getUserPlaces(String[] classNames, int max) throws RemoteException {
        try {
            List returnValue = GroupServiceUtil.getUserPlaces((String[])classNames, (int)max);
            return GroupSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static int getUserPlacesCount() throws RemoteException {
        try {
            int returnValue = GroupServiceUtil.getUserPlacesCount();
            return returnValue;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap[] getUserSites() throws RemoteException {
        try {
            List returnValue = GroupServiceUtil.getUserSites();
            return GroupSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static boolean hasUserGroup(long userId, long groupId) throws RemoteException {
        try {
            boolean returnValue = GroupServiceUtil.hasUserGroup((long)userId, (long)groupId);
            return returnValue;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap[] search(long companyId, String name, String description, String[] params, int start, int end) throws RemoteException {
        try {
            List returnValue = GroupServiceUtil.search((long)companyId, (String)name, (String)description, (String[])params, (int)start, (int)end);
            return GroupSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static int searchCount(long companyId, String name, String description, String[] params) throws RemoteException {
        try {
            int returnValue = GroupServiceUtil.searchCount((long)companyId, (String)name, (String)description, (String[])params);
            return returnValue;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void setRoleGroups(long roleId, long[] groupIds) throws RemoteException {
        try {
            GroupServiceUtil.setRoleGroups((long)roleId, (long[])groupIds);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void unsetRoleGroups(long roleId, long[] groupIds) throws RemoteException {
        try {
            GroupServiceUtil.unsetRoleGroups((long)roleId, (long[])groupIds);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap updateFriendlyURL(long groupId, String friendlyURL) throws RemoteException {
        try {
            Group returnValue = GroupServiceUtil.updateFriendlyURL((long)groupId, (String)friendlyURL);
            return GroupSoap.toSoapModel((Group)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap updateGroup(long groupId, long parentGroupId, String name, String description, int type, String friendlyURL, boolean active, ServiceContext serviceContext) throws RemoteException {
        try {
            Group returnValue = GroupServiceUtil.updateGroup((long)groupId, (long)parentGroupId, (String)name, (String)description, (int)type, (String)friendlyURL, (boolean)active, (ServiceContext)serviceContext);
            return GroupSoap.toSoapModel((Group)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static GroupSoap updateGroup(long groupId, String typeSettings) throws RemoteException {
        try {
            Group returnValue = GroupServiceUtil.updateGroup((long)groupId, (String)typeSettings);
            return GroupSoap.toSoapModel((Group)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }
}

