/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.UserPasswordException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.security.pwd.BasicToolkit;
import com.liferay.portal.util.PropsUtil;
import com.liferay.util.PwdGenerator;

public class RegExpToolkit
extends BasicToolkit {
    private static Log _log = LogFactoryUtil.getLog(RegExpToolkit.class);
    private String _charset;
    private int _length;
    private String _pattern = PropsUtil.get("passwords.regexptoolkit.pattern");

    public RegExpToolkit() {
        this._charset = PropsUtil.get("passwords.regexptoolkit.charset");
        this._length = GetterUtil.getInteger((String)PropsUtil.get("passwords.regexptoolkit.length"));
    }

    public String generate(PasswordPolicy passwordPolicy) {
        return PwdGenerator.getSecurePassword((String)this._charset, (int)this._length);
    }

    public void validate(long userId, String password1, String password2, PasswordPolicy passwordPolicy) throws PortalException {
        boolean value = password1.matches(this._pattern);
        if (!value) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("User " + userId + " attempted an invalid password"));
            }
            throw new UserPasswordException(3);
        }
    }
}

