/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.PwdEncryptorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.pwd.PasswordEncryptor;
import com.liferay.portal.util.PropsUtil;

public class PasswordEncryptorUtil {
    public static final String PASSWORDS_ENCRYPTION_ALGORITHM = GetterUtil.getString((String)PropsUtil.get("passwords.encryption.algorithm")).toUpperCase();
    public static final String TYPE_BCRYPT = "BCRYPT";
    public static final String TYPE_CRYPT = "CRYPT";
    public static final String TYPE_MD2 = "MD2";
    public static final String TYPE_MD5 = "MD5";
    public static final String TYPE_NONE = "NONE";
    public static final String TYPE_PBKDF2 = "PBKDF2";
    public static final String TYPE_SHA = "SHA";
    public static final String TYPE_SHA_256 = "SHA-256";
    public static final String TYPE_SHA_384 = "SHA-384";
    public static final String TYPE_SSHA = "SSHA";
    public static final String TYPE_UFC_CRYPT = "UFC-CRYPT";
    private static Log _log = LogFactoryUtil.getLog(PasswordEncryptorUtil.class);
    private static PasswordEncryptor _passwordEncryptor;

    public static String encrypt(String plainTextPassword) throws PwdEncryptorException {
        return PasswordEncryptorUtil.encrypt(plainTextPassword, null);
    }

    public static String encrypt(String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        long startTime = 0L;
        if (_log.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
        }
        try {
            String string = PasswordEncryptorUtil.encrypt(PASSWORDS_ENCRYPTION_ALGORITHM, plainTextPassword, encryptedPassword);
            return string;
        }
        finally {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Password encrypted in " + (System.currentTimeMillis() - startTime) + "ms"));
            }
        }
    }

    public static String encrypt(String algorithm, String plainTextPassword, String encryptedPassword) throws PwdEncryptorException {
        return _passwordEncryptor.encrypt(algorithm, plainTextPassword, encryptedPassword);
    }

    public PasswordEncryptor getPasswordEncryptor() {
        return _passwordEncryptor;
    }

    public void setPasswordEncryptor(PasswordEncryptor passwordEncryptor) {
        _passwordEncryptor = passwordEncryptor;
    }
}

