/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerBag;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutPrototypePermissionUtil;
import com.liferay.portal.service.permission.LayoutSetPrototypePermissionUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PermissionCheckerBagImpl
implements PermissionCheckerBag {
    private Map<Long, Boolean> _groupAdmins = new HashMap<Long, Boolean>();
    private Map<Long, Boolean> _groupOwners = new HashMap<Long, Boolean>();
    private List<Group> _groups;
    private Map<Long, Boolean> _organizationAdmins = new HashMap<Long, Boolean>();
    private Map<Long, Boolean> _organizationOwners = new HashMap<Long, Boolean>();
    private long[] _roleIds;
    private List<Role> _roles;
    private List<Group> _userGroups;
    private long _userId;
    private List<Group> _userOrgGroups;
    private List<Organization> _userOrgs;
    private List<Group> _userUserGroupGroups;

    public PermissionCheckerBagImpl() {
    }

    public PermissionCheckerBagImpl(long userId, List<Group> userGroups, List<Organization> userOrgs, List<Group> userOrgGroups, List<Group> userUserGroupGroups, List<Group> groups, List<Role> roles) {
        this._userId = userId;
        this._userGroups = userGroups;
        this._userOrgs = userOrgs;
        this._userOrgGroups = userOrgGroups;
        this._userUserGroupGroups = userUserGroupGroups;
        this._groups = groups;
        this._roles = roles;
    }

    public List<Group> getGroups() {
        return this._groups;
    }

    public long[] getRoleIds() {
        if (this._roleIds == null) {
            List<Role> roles = this.getRoles();
            long[] roleIds = new long[roles.size()];
            int i2 = 0;
            while (i2 < roles.size()) {
                Role role = roles.get(i2);
                roleIds[i2] = role.getRoleId();
                ++i2;
            }
            Arrays.sort(roleIds);
            this._roleIds = roleIds;
        }
        return this._roleIds;
    }

    public List<Role> getRoles() {
        return this._roles;
    }

    public List<Group> getUserGroups() {
        return this._userGroups;
    }

    public List<Group> getUserOrgGroups() {
        return this._userOrgGroups;
    }

    public List<Organization> getUserOrgs() {
        return this._userOrgs;
    }

    public List<Group> getUserUserGroupGroups() {
        return this._userUserGroupGroups;
    }

    public boolean isCommunityAdmin(PermissionChecker permissionChecker, Group group) throws Exception {
        return this.isGroupAdmin(permissionChecker, group);
    }

    public boolean isCommunityOwner(PermissionChecker permissionChecker, Group group) throws Exception {
        return this.isGroupOwner(permissionChecker, group);
    }

    public boolean isGroupAdmin(PermissionChecker permissionChecker, Group group) throws Exception {
        Boolean value = this._groupAdmins.get(group.getGroupId());
        if (value == null) {
            value = this.isGroupAdminImpl(permissionChecker, group);
            this._groupAdmins.put(group.getGroupId(), value);
        }
        return value;
    }

    public boolean isGroupMember(PermissionChecker permissionChecker, Group group) throws Exception {
        for (Role role : this._roles) {
            String name = role.getName();
            if (!name.equals("Site Member")) continue;
            return true;
        }
        return this._userGroups.contains(group);
    }

    public boolean isGroupOwner(PermissionChecker permissionChecker, Group group) throws Exception {
        Boolean value = this._groupOwners.get(group.getGroupId());
        if (value == null) {
            value = this.isGroupOwnerImpl(permissionChecker, group);
            this._groupOwners.put(group.getGroupId(), value);
        }
        return value;
    }

    public boolean isOrganizationAdmin(PermissionChecker permissionChecker, Organization organization) throws Exception {
        Boolean value = this._organizationAdmins.get(organization.getOrganizationId());
        if (value == null) {
            value = this.isOrganizationAdminImpl(permissionChecker, organization);
            this._organizationAdmins.put(organization.getOrganizationId(), value);
        }
        return value;
    }

    public boolean isOrganizationOwner(PermissionChecker permissionChecker, Organization organization) throws Exception {
        Boolean value = this._organizationOwners.get(organization.getOrganizationId());
        if (value == null) {
            value = this.isOrganizationOwnerImpl(permissionChecker, organization);
            this._organizationOwners.put(organization.getOrganizationId(), value);
        }
        return value;
    }

    protected boolean isGroupAdminImpl(PermissionChecker permissionChecker, Group group) throws PortalException, SystemException {
        if (group.isSite() && (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this._userId, (long)group.getGroupId(), (String)"Site Administrator", (boolean)true) || UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this._userId, (long)group.getGroupId(), (String)"Site Owner", (boolean)true))) {
            return true;
        }
        if (group.isCompany()) {
            return permissionChecker.isCompanyAdmin();
        }
        if (group.isLayoutPrototype()) {
            return LayoutPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"UPDATE");
        }
        if (group.isLayoutSetPrototype()) {
            return LayoutSetPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"UPDATE");
        }
        if (group.isOrganization()) {
            long organizationId = group.getOrganizationId();
            while (organizationId != 0L) {
                Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
                Group organizationGroup = organization.getGroup();
                long organizationGroupId = organizationGroup.getGroupId();
                if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this._userId, (long)organizationGroupId, (String)"Organization Administrator", (boolean)true) || UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this._userId, (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                    return true;
                }
                organizationId = organization.getParentOrganizationId();
            }
        }
        return false;
    }

    protected boolean isGroupOwnerImpl(PermissionChecker permissionChecker, Group group) throws PortalException, SystemException {
        long userId;
        if (group.isSite() && UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this._userId, (long)group.getGroupId(), (String)"Site Owner", (boolean)true)) {
            return true;
        }
        if (group.isLayoutPrototype()) {
            return LayoutPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"UPDATE");
        }
        if (group.isLayoutSetPrototype()) {
            return LayoutSetPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"UPDATE");
        }
        if (group.isOrganization()) {
            long organizationId = group.getOrganizationId();
            while (organizationId != 0L) {
                Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
                Group organizationGroup = organization.getGroup();
                long organizationGroupId = organizationGroup.getGroupId();
                if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this._userId, (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                    return true;
                }
                organizationId = organization.getParentOrganizationId();
            }
        } else if (group.isUser() && (userId = group.getClassPK()) == this._userId) {
            return true;
        }
        return false;
    }

    protected boolean isOrganizationAdminImpl(PermissionChecker permissionChecker, Organization organization) throws PortalException, SystemException {
        while (organization != null) {
            Group organizationGroup = organization.getGroup();
            long organizationGroupId = organizationGroup.getGroupId();
            if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this._userId, (long)organizationGroupId, (String)"Organization Administrator", (boolean)true) || UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this._userId, (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                return true;
            }
            organization = organization.getParentOrganization();
        }
        return false;
    }

    protected boolean isOrganizationOwnerImpl(PermissionChecker permissionChecker, Organization organization) throws PortalException, SystemException {
        while (organization != null) {
            Group organizationGroup = organization.getGroup();
            long organizationGroupId = organizationGroup.getGroupId();
            if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)this._userId, (long)organizationGroupId, (String)"Organization Owner", (boolean)true)) {
                return true;
            }
            organization = organization.getParentOrganization();
        }
        return false;
    }
}

