/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap;

import com.liferay.portal.PwdEncryptorException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.ldap.LDAPOperation;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.security.ldap.Modifications;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.security.ldap.PortalToLDAPConverter;
import com.liferay.portal.security.pwd.PasswordEncryptorUtil;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoConverterUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import org.apache.commons.beanutils.PropertyUtils;

public class DefaultPortalToLDAPConverter
implements PortalToLDAPConverter {
    private static final String _DEFAULT_DN = "cn";
    private static final String _OBJECT_CLASS = "objectclass";
    private static Log _log = LogFactoryUtil.getLog(DefaultPortalToLDAPConverter.class);
    private String _groupDNFieldName = "groupName";
    private Map<String, String> _reservedContactFieldNames = new HashMap<String, String>();
    private Map<String, String> _reservedUserFieldNames = new HashMap<String, String>();
    private String _userDNFieldName = "screenName";

    public DefaultPortalToLDAPConverter() {
        this._reservedUserFieldNames.put("group", "group");
        this._reservedUserFieldNames.put("password", "password");
        this._reservedUserFieldNames.put("portrait", "portrait");
        this._reservedUserFieldNames.put("screenName", "screenName");
    }

    public String getGroupDNName(long ldapServerId, UserGroup userGroup, Properties groupMappings) throws Exception {
        Binding groupBinding = PortalLDAPUtil.getGroup(ldapServerId, userGroup.getCompanyId(), userGroup.getName());
        if (groupBinding != null) {
            return PortalLDAPUtil.getNameInNamespace(ldapServerId, userGroup.getCompanyId(), groupBinding);
        }
        StringBundler sb = new StringBundler(5);
        sb.append(GetterUtil.getString((String)groupMappings.getProperty(this._groupDNFieldName), (String)_DEFAULT_DN));
        sb.append("=");
        sb.append(userGroup.getName());
        sb.append(",");
        sb.append(PortalLDAPUtil.getGroupsDN(ldapServerId, userGroup.getCompanyId()));
        return sb.toString();
    }

    public Modifications getLDAPContactModifications(Contact contact, Map<String, Serializable> contactExpandoAttributes, Properties contactMappings, Properties contactExpandoMappings) throws Exception {
        if (contactMappings.isEmpty() && contactExpandoMappings.isEmpty()) {
            return null;
        }
        Modifications modifications = this.getModifications(contact, contactMappings, this._reservedContactFieldNames);
        this.populateCustomAttributeModifications(contact, contact.getExpandoBridge(), contactExpandoAttributes, contactExpandoMappings, modifications);
        return modifications;
    }

    public Attributes getLDAPGroupAttributes(long ldapServerId, UserGroup userGroup, User user, Properties groupMappings, Properties userMappings) throws Exception {
        BasicAttributes attributes = new BasicAttributes(true);
        BasicAttribute objectClass = new BasicAttribute(_OBJECT_CLASS);
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        String[] defaultObjectClasses = PrefsPropsUtil.getStringArray(userGroup.getCompanyId(), "ldap.group.default.object.classes" + postfix, ",");
        int i2 = 0;
        while (i2 < defaultObjectClasses.length) {
            objectClass.add(defaultObjectClasses[i2]);
            ++i2;
        }
        attributes.put(objectClass);
        this.addAttributeMapping(groupMappings.getProperty("groupName"), userGroup.getName(), (Attributes)attributes);
        this.addAttributeMapping(groupMappings.getProperty("description"), userGroup.getDescription(), (Attributes)attributes);
        this.addAttributeMapping(groupMappings.getProperty("user"), this.getUserDNName(ldapServerId, user, userMappings), (Attributes)attributes);
        return attributes;
    }

    public Modifications getLDAPGroupModifications(long ldapServerId, UserGroup userGroup, User user, Properties groupMappings, Properties userMappings, LDAPOperation ldapOperation) throws Exception {
        Modifications modifications = Modifications.getInstance();
        String groupDN = this.getGroupDNName(ldapServerId, userGroup, groupMappings);
        String userDN = this.getUserDNName(ldapServerId, user, userMappings);
        if (PortalLDAPUtil.isGroupMember(ldapServerId, user.getCompanyId(), groupDN, userDN)) {
            if (ldapOperation == LDAPOperation.REMOVE) {
                modifications.addItem(3, groupMappings.getProperty("user"), userDN);
            }
        } else if (ldapOperation == LDAPOperation.ADD) {
            modifications.addItem(1, groupMappings.getProperty("user"), userDN);
        }
        return modifications;
    }

    public Attributes getLDAPUserAttributes(long ldapServerId, User user, Properties userMappings) throws SystemException {
        BasicAttributes attributes = new BasicAttributes(true);
        BasicAttribute objectClass = new BasicAttribute(_OBJECT_CLASS);
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        String[] defaultObjectClasses = PrefsPropsUtil.getStringArray(user.getCompanyId(), "ldap.user.default.object.classes" + postfix, ",");
        int i2 = 0;
        while (i2 < defaultObjectClasses.length) {
            objectClass.add(defaultObjectClasses[i2]);
            ++i2;
        }
        attributes.put(objectClass);
        this.addAttributeMapping(userMappings.getProperty("uuid"), user.getUuid(), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("screenName"), user.getScreenName(), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("password"), this.getEncryptedPasswordForLDAP(user), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("emailAddress"), user.getEmailAddress(), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("fullName"), user.getFullName(), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("firstName"), user.getFirstName(), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("middleName"), user.getMiddleName(), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("lastName"), user.getLastName(), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("jobTitle"), user.getJobTitle(), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("portrait"), this.getUserPortrait(user), (Attributes)attributes);
        this.addAttributeMapping(userMappings.getProperty("status"), String.valueOf(user.getStatus()), (Attributes)attributes);
        return attributes;
    }

    public Modifications getLDAPUserGroupModifications(long ldapServerId, List<UserGroup> userGroups, User user, Properties userMappings) throws Exception {
        Modifications modifications = Modifications.getInstance();
        String groupMappingAttributeName = userMappings.getProperty("group");
        if (Validator.isNull((String)groupMappingAttributeName)) {
            return modifications;
        }
        Properties groupMappings = LDAPSettingsUtil.getGroupMappings(ldapServerId, user.getCompanyId());
        String userDN = this.getUserDNName(ldapServerId, user, userMappings);
        for (UserGroup userGroup : userGroups) {
            String groupDN = this.getGroupDNName(ldapServerId, userGroup, groupMappings);
            if (PortalLDAPUtil.isUserGroupMember(ldapServerId, user.getCompanyId(), groupDN, userDN)) continue;
            modifications.addItem(1, groupMappingAttributeName, groupDN);
        }
        return modifications;
    }

    public Modifications getLDAPUserModifications(User user, Map<String, Serializable> userExpandoAttributes, Properties userMappings, Properties userExpandoMappings) throws Exception {
        String portraitKey;
        Modifications modifications = this.getModifications(user, userMappings, this._reservedUserFieldNames);
        if (user.isPasswordModified() && Validator.isNotNull((String)user.getPasswordUnencrypted())) {
            String newPassword = this.getEncryptedPasswordForLDAP(user);
            String passwordKey = userMappings.getProperty("password");
            if (passwordKey.equals("unicodePwd")) {
                String newQuotedPassword = "\"".concat(newPassword).concat("\"");
                byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
                this.addModificationItem(new BasicAttribute(passwordKey, newUnicodePassword), modifications);
            } else {
                this.addModificationItem(passwordKey, newPassword, modifications);
            }
        }
        if (Validator.isNotNull((String)(portraitKey = userMappings.getProperty("portrait")))) {
            this.addModificationItem(new BasicAttribute(portraitKey, this.getUserPortrait(user)), modifications);
        }
        this.populateCustomAttributeModifications(user, user.getExpandoBridge(), userExpandoAttributes, userExpandoMappings, modifications);
        return modifications;
    }

    public String getUserDNName(long ldapServerId, User user, Properties userMappings) throws Exception {
        Binding userBinding = PortalLDAPUtil.getUser(ldapServerId, user.getCompanyId(), user.getScreenName(), user.getEmailAddress());
        if (userBinding != null) {
            return PortalLDAPUtil.getNameInNamespace(ldapServerId, user.getCompanyId(), userBinding);
        }
        StringBundler sb = new StringBundler(5);
        sb.append(GetterUtil.getString((String)userMappings.getProperty(this._userDNFieldName), (String)_DEFAULT_DN));
        sb.append("=");
        sb.append(PropertyUtils.getProperty((Object)user, (String)this._userDNFieldName));
        sb.append(",");
        sb.append(PortalLDAPUtil.getUsersDN(ldapServerId, user.getCompanyId()));
        return sb.toString();
    }

    public void setContactReservedFieldNames(List<String> reservedContactFieldNames) {
        for (String reservedContactFieldName : reservedContactFieldNames) {
            this._reservedContactFieldNames.put(reservedContactFieldName, reservedContactFieldName);
        }
    }

    public void setUserDNFieldName(String userDNFieldName) {
        this._userDNFieldName = userDNFieldName;
    }

    public void setUserReservedFieldNames(List<String> reservedUserFieldNames) {
        for (String reservedUserFieldName : reservedUserFieldNames) {
            this._reservedUserFieldNames.put(reservedUserFieldName, reservedUserFieldName);
        }
    }

    protected void addAttributeMapping(String attributeName, Object attributeValue, Attributes attributes) {
        if (Validator.isNotNull((String)attributeName) && attributeValue != null) {
            attributes.put(attributeName, attributeValue);
        }
    }

    protected void addAttributeMapping(String attributeName, String attributeValue, Attributes attributes) {
        if (Validator.isNotNull((String)attributeName) && Validator.isNotNull((String)attributeValue)) {
            attributes.put(attributeName, attributeValue);
        }
    }

    protected void addModificationItem(BasicAttribute basicAttribute, Modifications modifications) {
        if (Validator.isNotNull((Object)basicAttribute)) {
            modifications.addItem(basicAttribute);
        }
    }

    protected void addModificationItem(String attributeName, String attributeValue, Modifications modifications) {
        if (Validator.isNotNull((String)attributeName) && Validator.isNotNull((String)attributeValue)) {
            modifications.addItem(attributeName, attributeValue);
        }
    }

    protected String getEncryptedPasswordForLDAP(User user) throws SystemException {
        String password = user.getPasswordUnencrypted();
        if (Validator.isNull((String)password)) {
            return password;
        }
        String algorithm = PrefsPropsUtil.getString(user.getCompanyId(), "ldap.auth.password.encryption.algorithm");
        if (Validator.isNull((String)algorithm)) {
            return password;
        }
        try {
            StringBundler sb = new StringBundler(4);
            sb.append("{");
            sb.append(algorithm);
            sb.append("}");
            sb.append(PasswordEncryptorUtil.encrypt(algorithm, password, null));
            return sb.toString();
        }
        catch (PwdEncryptorException pee) {
            throw new SystemException((Throwable)pee);
        }
    }

    protected Modifications getModifications(Object object, Properties objectMappings, Map<String, String> reservedFieldNames) {
        Modifications modifications = Modifications.getInstance();
        for (Map.Entry<Object, Object> entry : objectMappings.entrySet()) {
            String fieldName = (String)entry.getKey();
            if (reservedFieldNames.containsKey(fieldName)) continue;
            String ldapAttributeName = (String)entry.getValue();
            try {
                Object attributeValue = PropertyUtils.getProperty((Object)object, (String)fieldName);
                if (attributeValue == null) continue;
                this.addModificationItem(ldapAttributeName, attributeValue.toString(), modifications);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to map field " + fieldName + " to class " + object.getClass()), (Throwable)e2);
            }
        }
        return modifications;
    }

    protected byte[] getUserPortrait(User user) {
        byte[] bytes;
        block4: {
            bytes = null;
            if (user.getPortraitId() == 0L) {
                return bytes;
            }
            Image image = null;
            try {
                image = ImageLocalServiceUtil.getImage((long)user.getPortraitId());
                if (image != null) {
                    bytes = image.getTextObj();
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)("Unable to get the portrait for user " + user.getUserId()), (Throwable)e2);
            }
        }
        return bytes;
    }

    protected void populateCustomAttributeModifications(Object object, ExpandoBridge expandoBridge, Map<String, Serializable> expandoAttributes, Properties expandoMappings, Modifications modifications) {
        if (expandoAttributes == null || expandoAttributes.isEmpty()) {
            return;
        }
        for (Map.Entry<Object, Object> entry : expandoMappings.entrySet()) {
            String fieldName = (String)entry.getKey();
            String ldapAttributeName = (String)entry.getValue();
            Serializable fieldValue = expandoAttributes.get(fieldName);
            if (fieldValue == null) continue;
            try {
                int type = expandoBridge.getAttributeType(fieldName);
                String value = ExpandoConverterUtil.getStringFromAttribute(type, fieldValue);
                this.addModificationItem(ldapAttributeName, value, modifications);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to map field " + fieldName + " to class " + object.getClass()), (Throwable)e2);
            }
        }
    }
}

