/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.lang;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.ServiceLoader;
import com.liferay.portal.security.lang.PortalSecurityManager;
import com.liferay.portal.util.PropsValues;
import java.util.List;

public class SecurityManagerUtil {
    private static Log _log = LogFactoryUtil.getLog(SecurityManagerUtil.class);
    private static SecurityManager _originalSecurityManager;
    private static PortalSecurityManager _portalSecurityManager;
    private static PortalSecurityManagerStrategy _portalSecurityManagerStrategy;

    public static void applySmartStrategy() {
        if (_portalSecurityManagerStrategy == PortalSecurityManagerStrategy.SMART && _originalSecurityManager == null && ServerDetector.isWebSphere()) {
            System.setSecurityManager(null);
        }
    }

    public static PortalSecurityManager getPortalSecurityManager() {
        return _portalSecurityManager;
    }

    public static void init() {
        if (_portalSecurityManagerStrategy != null) {
            return;
        }
        _originalSecurityManager = System.getSecurityManager();
        _portalSecurityManagerStrategy = PropsValues.TCK_URL ? PortalSecurityManagerStrategy.NONE : PortalSecurityManagerStrategy.parse(PropsValues.PORTAL_SECURITY_MANAGER_STRATEGY);
        if (_portalSecurityManagerStrategy == PortalSecurityManagerStrategy.LIFERAY || _portalSecurityManagerStrategy == PortalSecurityManagerStrategy.SMART) {
            SecurityManagerUtil.loadPortalSecurityManager();
            if (_portalSecurityManager == null) {
                _portalSecurityManagerStrategy = PortalSecurityManagerStrategy.DEFAULT;
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"No portal security manager implementation was located. Continuing with the default security strategy.");
                }
                return;
            }
        }
        if (_portalSecurityManagerStrategy == PortalSecurityManagerStrategy.LIFERAY) {
            System.setSecurityManager((SecurityManager)((Object)_portalSecurityManager));
        } else if (_portalSecurityManagerStrategy == PortalSecurityManagerStrategy.NONE) {
            System.setSecurityManager(null);
        }
    }

    public static boolean isActive() {
        if (_portalSecurityManager == null) {
            return false;
        }
        return _portalSecurityManager.isActive();
    }

    public static boolean isDefault() {
        SecurityManagerUtil.init();
        return _portalSecurityManagerStrategy == PortalSecurityManagerStrategy.DEFAULT;
    }

    public static boolean isLiferay() {
        SecurityManagerUtil.init();
        return _portalSecurityManagerStrategy == PortalSecurityManagerStrategy.LIFERAY;
    }

    public static boolean isNone() {
        SecurityManagerUtil.init();
        return _portalSecurityManagerStrategy == PortalSecurityManagerStrategy.NONE;
    }

    public static boolean isPACLDisabled() {
        return SecurityManagerUtil.isDefault() || SecurityManagerUtil.isNone();
    }

    public static boolean isSmart() {
        SecurityManagerUtil.init();
        return _portalSecurityManagerStrategy == PortalSecurityManagerStrategy.SMART;
    }

    private static void loadPortalSecurityManager() {
        try {
            List portalSecurityManagers = ServiceLoader.load(PortalSecurityManager.class);
            if (portalSecurityManagers.isEmpty()) {
                return;
            }
            _portalSecurityManager = (PortalSecurityManager)portalSecurityManagers.get(0);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    private static enum PortalSecurityManagerStrategy {
        DEFAULT,
        LIFERAY,
        NONE,
        SMART;


        public static PortalSecurityManagerStrategy parse(String value) {
            if (value.equals("default")) {
                return DEFAULT;
            }
            if (value.equals("liferay")) {
                return LIFERAY;
            }
            if (value.equals("smart")) {
                return SMART;
            }
            return NONE;
        }
    }
}

