/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.security.auth.AccessControlContext;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.security.auth.AuthVerifier;
import com.liferay.portal.security.auth.AuthVerifierResult;
import com.liferay.portal.security.auth.AutoLoginException;
import com.liferay.portal.security.auth.BaseAutoLogin;
import com.liferay.portlet.login.util.LoginUtil;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BasicAuthHeaderAutoLogin
extends BaseAutoLogin
implements AuthVerifier {
    private static final String _BASIC_REALM = "Basic realm=\"PortalRealm\"";
    private static Log _log = LogFactoryUtil.getLog(BasicAuthHeaderAutoLogin.class);

    public String getAuthType() {
        return "BASIC";
    }

    public AuthVerifierResult verify(AccessControlContext accessControlContext, Properties properties) throws AuthException {
        try {
            AuthVerifierResult authVerifierResult = new AuthVerifierResult();
            String[] credentials = this.login(accessControlContext.getRequest(), accessControlContext.getResponse());
            if (credentials != null) {
                authVerifierResult.setPassword(credentials[1]);
                authVerifierResult.setState(AuthVerifierResult.State.SUCCESS);
                authVerifierResult.setUserId(Long.valueOf(credentials[0]).longValue());
            } else {
                boolean forcedBasicAuth = MapUtil.getBoolean((Map)accessControlContext.getSettings(), (String)"basic_auth");
                if (forcedBasicAuth) {
                    HttpServletResponse response = accessControlContext.getResponse();
                    response.setHeader("WWW-Authenticate", _BASIC_REALM);
                    response.setStatus(401);
                    authVerifierResult.setState(AuthVerifierResult.State.INVALID_CREDENTIALS);
                }
            }
            return authVerifierResult;
        }
        catch (AutoLoginException ale) {
            throw new AuthException((Throwable)ale);
        }
    }

    protected String[] doLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int pos;
        String authorization = request.getHeader("Authorization");
        if (authorization == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(authorization);
        if (!st.hasMoreTokens()) {
            return null;
        }
        String basic = st.nextToken();
        if (!basic.equalsIgnoreCase("BASIC")) {
            return null;
        }
        String encodedCredentials = st.nextToken();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Encoded credentials are " + encodedCredentials));
        }
        String decodedCredentials = new String(Base64.decode((String)encodedCredentials));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Decoded credentials are " + decodedCredentials));
        }
        if ((pos = decodedCredentials.indexOf(58)) == -1) {
            return null;
        }
        String login = GetterUtil.getString((String)decodedCredentials.substring(0, pos));
        String password = decodedCredentials.substring(pos + 1);
        long userId = LoginUtil.getAuthenticatedUserId(request, login, password, null);
        String[] credentials = new String[]{String.valueOf(userId), password, Boolean.TRUE.toString()};
        return credentials;
    }
}

