/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.QueryTranslator;
import com.liferay.portal.kernel.search.StringQueryImpl;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.search.lucene.BooleanQueryImpl;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.search.lucene.LuceneQueryImpl;
import com.liferay.portal.search.lucene.TermQueryImpl;
import com.liferay.portal.search.lucene.TermRangeQueryImpl;
import java.lang.reflect.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

@DoPrivileged
public class QueryTranslatorImpl
implements QueryTranslator {
    private static Log _log = LogFactoryUtil.getLog(QueryTranslatorImpl.class);
    private static Field _textField = null;

    static {
        try {
            _textField = Term.class.getDeclaredField("text");
            _textField.setAccessible(true);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public Object translate(com.liferay.portal.kernel.search.Query query) throws ParseException {
        if (query instanceof BooleanQueryImpl) {
            return ((BooleanQueryImpl)query).getBooleanQuery();
        }
        if (query instanceof LuceneQueryImpl) {
            return ((LuceneQueryImpl)query).getQuery();
        }
        if (query instanceof StringQueryImpl) {
            QueryParser queryParser = new QueryParser(LuceneHelperUtil.getVersion(), "", LuceneHelperUtil.getAnalyzer());
            try {
                return queryParser.parse(query.toString());
            }
            catch (org.apache.lucene.queryParser.ParseException pe) {
                throw new ParseException((Throwable)pe);
            }
        }
        if (query instanceof TermQueryImpl) {
            return ((TermQueryImpl)query).getTermQuery();
        }
        if (query instanceof TermRangeQueryImpl) {
            return ((TermRangeQueryImpl)query).getTermRangeQuery();
        }
        return null;
    }

    public Object translateForSolr(com.liferay.portal.kernel.search.Query query) {
        Object queryObject = query.getWrappedQuery();
        if (queryObject instanceof Query) {
            this.adjustQuery((Query)queryObject);
        }
        return query;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void adjustQuery(Query query) {
        if (query instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            BooleanClause[] booleanClauseArray = booleanQuery.getClauses();
            int n = booleanClauseArray.length;
            int n2 = 0;
            while (n2 < n) {
                BooleanClause booleanClause = booleanClauseArray[n2];
                this.adjustQuery(booleanClause.getQuery());
                ++n2;
            }
            return;
        } else if (query instanceof TermQuery) {
            TermQuery termQuery = (TermQuery)query;
            Term term = termQuery.getTerm();
            try {
                String text = term.text();
                if (!text.matches("^\\s*[^\"].*\\s+.*[^\"]\\s*$(?m)")) return;
                text = "\"".concat(text).concat("\"");
                _textField.set(term, text);
                return;
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
            return;
        } else {
            if (!(query instanceof WildcardQuery)) return;
            WildcardQuery wildcardQuery = (WildcardQuery)query;
            Term term = wildcardQuery.getTerm();
            try {
                String text = term.text();
                if (!text.matches("^\\s*\\*.*(?m)")) return;
                text = text.replaceFirst("\\*", "");
                _textField.set(term, text);
                return;
            }
            catch (Exception e3) {
                _log.error((Object)e3, (Throwable)e3);
            }
        }
    }
}

