/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.NGramHolder;
import com.liferay.portal.kernel.search.NGramHolderBuilderUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.SpellCheckIndexWriter;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.search.lucene.IndexAccessor;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.search.lucene.SpellCheckerUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.spell.PlainTextDictionary;
import org.apache.lucene.util.ReaderUtil;

public class LuceneSpellCheckIndexWriter
implements SpellCheckIndexWriter {
    private static final int _MINIMUM_WORD_LENGTH = 3;
    private static Log _log = LogFactoryUtil.getLog(LuceneSpellCheckIndexWriter.class);

    public void clearDictionaryIndexes(SearchContext searchContext) throws SearchException {
        Term term = new Term("portletId", "3");
        try {
            LuceneHelperUtil.deleteDocuments(searchContext.getCompanyId(), term);
        }
        catch (IOException e2) {
            throw new SearchException((Throwable)e2);
        }
    }

    public void indexDictionaries(SearchContext searchContext) throws SearchException {
        try {
            String[] stringArray = PropsValues.LUCENE_SPELL_CHECKER_SUPPORTED_LOCALES;
            int n = PropsValues.LUCENE_SPELL_CHECKER_SUPPORTED_LOCALES.length;
            int n2 = 0;
            while (n2 < n) {
                String languageId = stringArray[n2];
                this.indexDictionary(searchContext.getCompanyId(), languageId);
                ++n2;
            }
        }
        catch (Exception e2) {
            throw new SearchException((Throwable)e2);
        }
    }

    public void indexDictionary(SearchContext searchContext) throws SearchException {
        try {
            this.indexDictionary(searchContext.getCompanyId(), searchContext.getLanguageId());
        }
        catch (Exception e2) {
            throw new SearchException((Throwable)e2);
        }
    }

    protected void addField(Document document, String fieldName, String fieldValue, Field.Store fieldStore, FieldInfo.IndexOptions indexOptions, boolean omitNorms) {
        Field field = new Field(fieldName, fieldValue, fieldStore, Field.Index.NOT_ANALYZED);
        field.setIndexOptions(indexOptions);
        field.setOmitNorms(omitNorms);
        document.add((Fieldable)field);
    }

    protected void addNGramFields(Document document, Map<String, String> nGrams) {
        for (Map.Entry<String, String> entry : nGrams.entrySet()) {
            String fieldName = entry.getKey();
            String fieldValue = entry.getValue();
            this.addField(document, fieldName, fieldValue, Field.Store.NO, FieldInfo.IndexOptions.DOCS_ONLY, true);
        }
    }

    protected Document createDocument(String localizedFieldName, String word, String languageId) throws SearchException {
        Document document = new Document();
        this.addField(document, "languageId", languageId, Field.Store.NO, FieldInfo.IndexOptions.DOCS_ONLY, true);
        this.addField(document, "portletId", "3", Field.Store.YES, FieldInfo.IndexOptions.DOCS_ONLY, true);
        this.addField(document, localizedFieldName, word, Field.Store.YES, FieldInfo.IndexOptions.DOCS_ONLY, true);
        NGramHolder nGramHolder = NGramHolderBuilderUtil.buildNGramHolder((String)word);
        this.addNGramFields(document, nGramHolder.getNGramEnds());
        Map nGrams = nGramHolder.getNGrams();
        for (Map.Entry entry : nGrams.entrySet()) {
            String fieldName = (String)entry.getKey();
            for (String nGram : (List)entry.getValue()) {
                this.addField(document, fieldName, nGram, Field.Store.NO, FieldInfo.IndexOptions.DOCS_AND_FREQS, false);
            }
        }
        this.addNGramFields(document, nGramHolder.getNGramStarts());
        return document;
    }

    protected URL getResource(String name) {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader.getResource(name);
    }

    protected void indexDictionary(long companyId, String languageId) throws Exception {
        String[] dictionaryFileNames;
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Start indexing dictionaries for " + languageId));
        }
        IndexAccessor indexAccessor = LuceneHelperUtil.getIndexAccessor(companyId);
        String[] stringArray = dictionaryFileNames = PropsUtil.getArray("lucene.spell.checker.dictionary", new Filter(languageId));
        int n = dictionaryFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                IndexSearcher indexSearcher;
                InputStream inputStream;
                block9: {
                    block10: {
                        String dictionaryFileName = stringArray[n2];
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)("Indexing dictionary " + dictionaryFileName));
                        }
                        inputStream = null;
                        indexSearcher = null;
                        URL url = this.getResource(dictionaryFileName);
                        inputStream = url.openStream();
                        if (inputStream != null) break block9;
                        if (!_log.isWarnEnabled()) break block10;
                        _log.warn((Object)("Unable to read " + dictionaryFileName));
                    }
                    StreamUtil.cleanUp((InputStream)inputStream);
                    LuceneHelperUtil.cleanUp(indexSearcher);
                    break block11;
                }
                try {
                    String localizedFieldName = DocumentImpl.getLocalizedName((String)languageId, (String)"spellCheckWord");
                    indexSearcher = LuceneHelperUtil.getSearcher(indexAccessor.getCompanyId(), true);
                    ArrayList<IndexReader> indexReaders = new ArrayList<IndexReader>();
                    if (indexSearcher.maxDoc() > 0) {
                        ReaderUtil.gatherSubReaders(indexReaders, (IndexReader)indexSearcher.getIndexReader());
                    }
                    ArrayList<Document> documents = new ArrayList<Document>();
                    PlainTextDictionary dictionary = new PlainTextDictionary(inputStream);
                    Iterator iterator = dictionary.getWordsIterator();
                    while (iterator.hasNext()) {
                        String word = (String)iterator.next();
                        boolean validWord = this.isValidWord(localizedFieldName, word, indexReaders);
                        if (!validWord) continue;
                        Document document = this.createDocument(localizedFieldName, word, languageId);
                        documents.add(document);
                    }
                    indexAccessor.addDocuments(documents);
                }
                catch (Throwable throwable) {
                    StreamUtil.cleanUp(inputStream);
                    LuceneHelperUtil.cleanUp(indexSearcher);
                    throw throwable;
                }
                StreamUtil.cleanUp((InputStream)inputStream);
                LuceneHelperUtil.cleanUp(indexSearcher);
            }
            ++n2;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Finished indexing dictionaries for " + languageId));
        }
    }

    protected boolean isValidWord(String localizedFieldName, String word, List<IndexReader> indexReaders) throws IOException {
        if (word.length() < 3) {
            return false;
        }
        return !SpellCheckerUtil.isValidWord(localizedFieldName, word, indexReaders);
    }
}

