/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.search.CollatorUtil;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.NGramHolder;
import com.liferay.portal.kernel.search.NGramHolderBuilderUtil;
import com.liferay.portal.kernel.search.QuerySuggester;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.TokenizerUtil;
import com.liferay.portal.search.lucene.DefaultRelevancyChecker;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.search.lucene.RelevancyChecker;
import com.liferay.portal.search.lucene.SpellCheckerUtil;
import com.liferay.portal.search.lucene.StringDistanceRelevancyChecker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.lucene.util.ReaderUtil;

public class LuceneQuerySuggester
implements QuerySuggester {
    private float _boostEnd = 1.0f;
    private float _boostStart = 2.0f;
    private RelevancyChecker _relevancyChecker = new DefaultRelevancyChecker();
    private StringDistance _stringDistance;
    private Comparator<SuggestWord> _suggestWordComparator = SuggestWordQueue.DEFAULT_COMPARATOR;

    public void setBoostEnd(float boostEnd) {
        this._boostEnd = boostEnd;
    }

    public void setBoostStart(float boostStart) {
        this._boostStart = boostStart;
    }

    public void setStringDistance(StringDistance stringDistance) {
        this._stringDistance = stringDistance;
    }

    public void setSuggestWordComparator(Comparator<SuggestWord> suggestWordComparator) {
        this._suggestWordComparator = suggestWordComparator;
    }

    public String spellCheckKeywords(SearchContext searchContext) throws SearchException {
        String languageId = searchContext.getLanguageId();
        String localizedFieldName = DocumentImpl.getLocalizedName((String)languageId, (String)"spellCheckWord");
        List keywords = TokenizerUtil.tokenize((String)localizedFieldName, (String)searchContext.getKeywords(), (String)languageId);
        Map<String, List<String>> suggestions = this.spellCheckKeywords(keywords, localizedFieldName, searchContext, languageId, 1);
        return CollatorUtil.collate(suggestions, (List)keywords);
    }

    public Map<String, List<String>> spellCheckKeywords(SearchContext searchContext, int max) throws SearchException {
        String languageId = searchContext.getLanguageId();
        String localizedFieldName = DocumentImpl.getLocalizedName((String)languageId, (String)"spellCheckWord");
        List keywords = TokenizerUtil.tokenize((String)localizedFieldName, (String)searchContext.getKeywords(), (String)languageId);
        return this.spellCheckKeywords(keywords, localizedFieldName, searchContext, languageId, max);
    }

    public String[] suggestKeywordQueries(SearchContext searchContext, int max) throws SearchException {
        String[] stringArray;
        IndexSearcher indexSearcher = null;
        try {
            indexSearcher = LuceneHelperUtil.getSearcher(searchContext.getCompanyId(), true);
            BooleanQuery suggestKeywordQuery = new BooleanQuery();
            this.addTermQuery(suggestKeywordQuery, "companyId", String.valueOf(searchContext.getCompanyId()), null, BooleanClause.Occur.MUST);
            String localizedKeywordFieldName = DocumentImpl.getLocalizedName((String)searchContext.getLanguageId(), (String)"keywordSearch");
            QueryParser queryParser = new QueryParser(LuceneHelperUtil.getVersion(), localizedKeywordFieldName, LuceneHelperUtil.getAnalyzer());
            Query query = queryParser.parse(searchContext.getKeywords());
            BooleanClause keywordTermQuery = new BooleanClause(query, BooleanClause.Occur.MUST);
            suggestKeywordQuery.add(keywordTermQuery);
            String languageId = searchContext.getLanguageId();
            this.addTermQuery(suggestKeywordQuery, "languageId", languageId, null, BooleanClause.Occur.MUST);
            this.addTermQuery(suggestKeywordQuery, "portletId", "3", null, BooleanClause.Occur.MUST);
            stringArray = this.search(indexSearcher, (Query)suggestKeywordQuery, localizedKeywordFieldName, this._relevancyChecker, max);
        }
        catch (Exception e2) {
            try {
                throw new SearchException("Unable to suggest query", (Throwable)e2);
            }
            catch (Throwable throwable) {
                LuceneHelperUtil.cleanUp(indexSearcher);
                throw throwable;
            }
        }
        LuceneHelperUtil.cleanUp(indexSearcher);
        return stringArray;
    }

    protected void addNGramTermQuery(BooleanQuery booleanQuery, Map<String, String> nGrams, Float boost, BooleanClause.Occur occur) {
        for (Map.Entry<String, String> nGramEntry : nGrams.entrySet()) {
            String name = nGramEntry.getKey();
            String value = nGramEntry.getValue();
            this.addTermQuery(booleanQuery, name, value, boost, occur);
        }
    }

    protected void addTermQuery(BooleanQuery booleanQuery, String termName, String termValue, Float boost, BooleanClause.Occur occur) {
        TermQuery query = new TermQuery(new Term(termName, termValue));
        if (boost != null) {
            query.setBoost(boost.floatValue());
        }
        BooleanClause booleanClause = new BooleanClause((Query)query, occur);
        booleanQuery.add(booleanClause);
    }

    protected BooleanQuery buildNGramQuery(String word) throws SearchException {
        NGramHolder nGramHolder = NGramHolderBuilderUtil.buildNGramHolder((String)word);
        BooleanQuery booleanQuery = new BooleanQuery();
        if (this._boostEnd > 0.0f) {
            Map nGramEnds = nGramHolder.getNGramEnds();
            this.addNGramTermQuery(booleanQuery, nGramEnds, Float.valueOf(this._boostEnd), BooleanClause.Occur.SHOULD);
        }
        Map nGrams = nGramHolder.getNGrams();
        for (Map.Entry entry : nGrams.entrySet()) {
            String fieldName = (String)entry.getKey();
            for (String nGram : (List)entry.getValue()) {
                this.addTermQuery(booleanQuery, fieldName, nGram, null, BooleanClause.Occur.SHOULD);
            }
        }
        if (this._boostStart > 0.0f) {
            Map nGramStarts = nGramHolder.getNGramStarts();
            this.addNGramTermQuery(booleanQuery, nGramStarts, Float.valueOf(this._boostStart), BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    protected BooleanQuery buildSpellCheckQuery(String word, String languageId) throws SearchException {
        BooleanQuery suggestWordQuery = new BooleanQuery();
        BooleanQuery nGramQuery = this.buildNGramQuery(word);
        BooleanClause booleanNGramQueryClause = new BooleanClause((Query)nGramQuery, BooleanClause.Occur.MUST);
        suggestWordQuery.add(booleanNGramQueryClause);
        this.addTermQuery(suggestWordQuery, "languageId", languageId, null, BooleanClause.Occur.MUST);
        this.addTermQuery(suggestWordQuery, "portletId", "3", null, BooleanClause.Occur.MUST);
        return suggestWordQuery;
    }

    protected String[] search(IndexSearcher indexSearcher, Query query, String fieldName, RelevancyChecker relevancyChecker, int max) throws IOException {
        int maxScoreDocs = max * 10;
        TopDocs topDocs = indexSearcher.search(query, null, maxScoreDocs);
        ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        SuggestWordQueue suggestWordQueue = new SuggestWordQueue(max, this._suggestWordComparator);
        int stop = Math.min(scoreDocs.length, maxScoreDocs);
        int i2 = 0;
        while (i2 < stop) {
            SuggestWord suggestWord = new SuggestWord();
            Document document = indexSearcher.doc(scoreDocs[i2].doc);
            Fieldable fieldable = document.getFieldable(fieldName);
            suggestWord.string = fieldable.stringValue();
            boolean relevant = relevancyChecker.isRelevant(suggestWord);
            if (relevant) {
                suggestWordQueue.insertWithOverflow((Object)suggestWord);
            }
            ++i2;
        }
        String[] words = new String[suggestWordQueue.size()];
        int i3 = suggestWordQueue.size() - 1;
        while (i3 >= 0) {
            SuggestWord suggestWord = (SuggestWord)suggestWordQueue.pop();
            words[i3] = suggestWord.string;
            --i3;
        }
        return words;
    }

    protected Map<String, List<String>> spellCheckKeywords(List<String> keywords, String localizedFieldName, SearchContext searchContext, String languageId, int max) throws SearchException {
        LinkedHashMap<String, List<String>> linkedHashMap;
        IndexSearcher indexSearcher = null;
        try {
            LinkedHashMap<String, List<String>> suggestions = new LinkedHashMap<String, List<String>>();
            float scoresThreshold = searchContext.getScoresThreshold();
            if (scoresThreshold == 0.0f) {
                scoresThreshold = 0.5f;
            }
            indexSearcher = LuceneHelperUtil.getSearcher(searchContext.getCompanyId(), true);
            ArrayList<IndexReader> indexReaders = new ArrayList<IndexReader>();
            if (indexSearcher.maxDoc() > 0) {
                ReaderUtil.gatherSubReaders(indexReaders, (IndexReader)indexSearcher.getIndexReader());
            }
            for (String keyword : keywords) {
                List<Object> suggestionsList = Collections.emptyList();
                if (!SpellCheckerUtil.isValidWord(localizedFieldName, keyword, indexReaders)) {
                    int frequency = indexSearcher.docFreq(new Term(localizedFieldName, keyword));
                    String[] suggestionsArray = null;
                    if (frequency > 0) {
                        suggestionsArray = new String[]{keyword};
                    } else {
                        BooleanQuery suggestWordQuery = this.buildSpellCheckQuery(keyword, languageId);
                        StringDistanceRelevancyChecker relevancyChecker = new StringDistanceRelevancyChecker(keyword, scoresThreshold, this._stringDistance);
                        suggestionsArray = this.search(indexSearcher, (Query)suggestWordQuery, localizedFieldName, relevancyChecker, max);
                    }
                    suggestionsList = Arrays.asList(suggestionsArray);
                }
                suggestions.put(keyword, suggestionsList);
            }
            linkedHashMap = suggestions;
        }
        catch (IOException ioe) {
            try {
                throw new SearchException("Unable to find suggestions", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                LuceneHelperUtil.cleanUp(indexSearcher);
                throw throwable;
            }
        }
        LuceneHelperUtil.cleanUp(indexSearcher);
        return linkedHashMap;
    }
}

