/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.browseengine.bobo.api.BoboBrowser;
import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BoboSubBrowser;
import com.browseengine.bobo.api.Browsable;
import com.browseengine.bobo.api.BrowseHit;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexSearcher;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.QueryTranslatorUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.TokenGroup;

public class LuceneIndexSearcher
extends BaseIndexSearcher {
    private static Log _log = LogFactoryUtil.getLog(LuceneIndexSearcher.class);
    private static Field _runtimeFacetDataMapField;

    static {
        try {
            _runtimeFacetDataMapField = ReflectionUtil.getDeclaredField(BoboIndexReader.class, (String)"_runtimeFacetDataMap");
        }
        catch (Exception e2) {
            throw new ExceptionInInitializerError(e2);
        }
    }

    /*
     * Exception decompiling
     */
    public Hits search(SearchContext searchContext, com.liferay.portal.kernel.search.Query query) throws SearchException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 9[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public Hits search(String searchEngineId, long companyId, com.liferay.portal.kernel.search.Query query, com.liferay.portal.kernel.search.Sort[] sorts, int start, int end) throws SearchException {
        Hits hits;
        block19: {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Query " + query));
            }
            hits = null;
            IndexSearcher indexSearcher = null;
            Sort luceneSort = null;
            try {
                indexSearcher = LuceneHelperUtil.getSearcher(companyId, true);
                if (sorts != null) {
                    SortField[] sortFields = new SortField[sorts.length];
                    int i2 = 0;
                    while (i2 < sorts.length) {
                        com.liferay.portal.kernel.search.Sort sort = sorts[i2];
                        sortFields[i2] = new SortField(sort.getFieldName(), sort.getType(), sort.isReverse());
                        ++i2;
                    }
                    luceneSort = new Sort(sortFields);
                } else {
                    luceneSort = new Sort();
                }
                long startTime = System.currentTimeMillis();
                TopFieldDocs topFieldDocs = indexSearcher.search((Query)QueryTranslatorUtil.translate((com.liferay.portal.kernel.search.Query)query), null, PropsValues.INDEX_SEARCH_LIMIT, luceneSort);
                long endTime = System.currentTimeMillis();
                float searchTime = (float)(endTime - startTime) / 1000.0f;
                hits = this.toHits(indexSearcher, new HitDocs(topFieldDocs), query, startTime, searchTime, start, end);
            }
            catch (BooleanQuery.TooManyClauses tooManyClauses) {
                int maxClauseCount = BooleanQuery.getMaxClauseCount();
                BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
                try {
                    try {
                        long startTime = System.currentTimeMillis();
                        TopFieldDocs topFieldDocs = indexSearcher.search((Query)QueryTranslatorUtil.translate((com.liferay.portal.kernel.search.Query)query), null, PropsValues.INDEX_SEARCH_LIMIT, luceneSort);
                        long endTime = System.currentTimeMillis();
                        float searchTime = (float)(endTime - startTime) / 1000.0f;
                        hits = this.toHits(indexSearcher, new HitDocs(topFieldDocs), query, startTime, searchTime, start, end);
                    }
                    catch (Exception e2) {
                        throw new SearchException((Throwable)e2);
                    }
                }
                finally {
                    BooleanQuery.setMaxClauseCount((int)maxClauseCount);
                }
                LuceneHelperUtil.cleanUp(indexSearcher);
                break block19;
            }
            catch (ParseException pe) {
                _log.error((Object)("Query " + query), (Throwable)pe);
                HitsImpl hitsImpl = new HitsImpl();
                LuceneHelperUtil.cleanUp(indexSearcher);
                return hitsImpl;
            }
            catch (Exception e3) {
                throw new SearchException((Throwable)e3);
                {
                    catch (Throwable throwable) {
                        LuceneHelperUtil.cleanUp(indexSearcher);
                        throw throwable;
                    }
                }
            }
            LuceneHelperUtil.cleanUp(indexSearcher);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Search found " + hits.getLength() + " results in " + hits.getSearchTime() + "ms"));
        }
        return hits;
    }

    protected void cleanUp(BoboBrowser boboBrowser) {
        Browsable[] browsables;
        if (boboBrowser == null) {
            return;
        }
        try {
            boboBrowser.close();
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
        }
        Browsable[] browsableArray = browsables = boboBrowser.getSubBrowsers();
        int n = browsables.length;
        int n2 = 0;
        while (n2 < n) {
            Browsable browsable = browsableArray[n2];
            if (browsable instanceof BoboSubBrowser) {
                BoboSubBrowser boboSubBrowser = (BoboSubBrowser)browsable;
                BoboIndexReader boboIndexReader = boboSubBrowser.getIndexReader();
                try {
                    ThreadLocal threadLocal = (ThreadLocal)_runtimeFacetDataMapField.get(boboIndexReader);
                    threadLocal.remove();
                    _runtimeFacetDataMapField.set(boboIndexReader, null);
                }
                catch (Exception e2) {
                    _log.error((Object)"Unable to clean up BoboIndexReader#_runtimeFacetDataMap", (Throwable)e2);
                }
            }
            ++n2;
        }
    }

    protected DocumentImpl getDocument(org.apache.lucene.document.Document oldDocument) {
        DocumentImpl newDocument = new DocumentImpl();
        List oldFieldables = oldDocument.getFields();
        for (Fieldable oldFieldable : oldFieldables) {
            com.liferay.portal.kernel.search.Field newField = null;
            String[] values = oldDocument.getValues(oldFieldable.name());
            newField = values != null && values.length > 1 ? new com.liferay.portal.kernel.search.Field(oldFieldable.name(), values) : new com.liferay.portal.kernel.search.Field(oldFieldable.name(), oldFieldable.stringValue());
            newField.setNumeric(oldFieldable instanceof NumericField);
            newField.setTokenized(oldFieldable.isTokenized());
            newDocument.add(newField);
        }
        return newDocument;
    }

    protected Set<String> getQueryTerms(com.liferay.portal.kernel.search.Query query) {
        HashSet<String> queryTerms = new HashSet();
        try {
            queryTerms = LuceneHelperUtil.getQueryTerms((Query)QueryTranslatorUtil.translate((com.liferay.portal.kernel.search.Query)query));
        }
        catch (ParseException pe) {
            _log.error((Object)("Query " + query), (Throwable)pe);
        }
        return queryTerms;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getSnippet(org.apache.lucene.document.Document doc, com.liferay.portal.kernel.search.Query query, String field, Locale locale, Document hitDoc, Set<String> matchingTerms) throws IOException {
        String snippetField = DocumentImpl.getLocalizedName((Locale)locale, (String)field);
        String snippet = null;
        try {
            Query luceneQuery = (Query)QueryTranslatorUtil.translate((com.liferay.portal.kernel.search.Query)query);
            Object[] values = doc.getValues(snippetField);
            TermCollectingFormatter termCollectingFormatter = new TermCollectingFormatter();
            if (values != null && values.length > 0) {
                snippet = LuceneHelperUtil.getSnippet(luceneQuery, snippetField, StringUtil.merge((Object[])values), termCollectingFormatter);
            }
            if (values == null || values.length == 0 || Validator.isNull(snippet)) {
                snippetField = field;
                values = doc.getValues(snippetField);
                if (Validator.isNull((Object[])values)) {
                    return "";
                }
                snippet = LuceneHelperUtil.getSnippet(luceneQuery, field, StringUtil.merge((Object[])values), termCollectingFormatter);
            }
            if (Validator.isNull((String)snippet)) {
                return "";
            }
            matchingTerms.addAll(termCollectingFormatter.getTerms());
        }
        catch (ParseException pe) {
            _log.error((Object)("Query " + query), (Throwable)pe);
        }
        hitDoc.addText("snippet".concat("_").concat(snippetField), snippet);
        return snippet;
    }

    protected Hits toHits(IndexSearcher indexSearcher, HitDocs hitDocs, com.liferay.portal.kernel.search.Query query, long startTime, float searchTime, int start, int end) throws IOException, ParseException {
        int subsetTotal;
        int length = hitDocs.getTotalHits();
        if (start == -1 && end == -1) {
            start = 0;
            end = length;
        }
        Set<Object> queryTerms = new HashSet();
        IndexReader indexReader = indexSearcher.getIndexReader();
        ArrayList indexedFieldNames = new ArrayList(indexReader.getFieldNames(IndexReader.FieldOption.INDEXED));
        Query luceneQuery = (Query)QueryTranslatorUtil.translate((com.liferay.portal.kernel.search.Query)query);
        int scoredFieldNamesCount = LuceneHelperUtil.countScoredFieldNames(luceneQuery, ArrayUtil.toStringArray((Object[])indexedFieldNames.toArray()));
        HitsImpl hits = new HitsImpl();
        if (start < 0 || start > end) {
            return hits;
        }
        if (end > length) {
            end = length;
        }
        if (start > end) {
            start = end;
        }
        if ((subsetTotal = end - start) > PropsValues.INDEX_SEARCH_LIMIT) {
            subsetTotal = PropsValues.INDEX_SEARCH_LIMIT;
        }
        ArrayList<DocumentImpl> subsetDocs = new ArrayList<DocumentImpl>(subsetTotal);
        ArrayList<Float> subsetScores = new ArrayList<Float>(subsetTotal);
        QueryConfig queryConfig = query.getQueryConfig();
        int i2 = start;
        while (i2 < start + subsetTotal) {
            int docId = hitDocs.getDocId(i2);
            org.apache.lucene.document.Document document = indexSearcher.doc(docId);
            DocumentImpl subsetDocument = this.getDocument(document);
            if (queryConfig.isHighlightEnabled()) {
                Locale locale = queryConfig.getLocale();
                this.getSnippet(document, query, "content", locale, (Document)subsetDocument, queryTerms);
                this.getSnippet(document, query, "description", locale, (Document)subsetDocument, queryTerms);
                this.getSnippet(document, query, "title", locale, (Document)subsetDocument, queryTerms);
            }
            subsetDocs.add(subsetDocument);
            Float subsetScore = Float.valueOf(hitDocs.getScore(i2));
            if (scoredFieldNamesCount > 0) {
                subsetScore = Float.valueOf(subsetScore.floatValue() / (float)scoredFieldNamesCount);
            }
            subsetScores.add(subsetScore);
            if (_log.isDebugEnabled()) {
                try {
                    Explanation explanation = indexSearcher.explain(luceneQuery, docId);
                    _log.debug((Object)explanation.toString());
                }
                catch (Exception exception) {}
            }
            ++i2;
        }
        if (!queryConfig.isHighlightEnabled()) {
            queryTerms = this.getQueryTerms(query);
        }
        hits.setDocs(subsetDocs.toArray(new Document[subsetDocs.size()]));
        hits.setLength(length);
        hits.setQuery(query);
        hits.setQueryTerms(queryTerms.toArray(new String[queryTerms.size()]));
        hits.setScores(subsetScores.toArray(new Float[subsetScores.size()]));
        hits.setSearchTime(searchTime);
        hits.setStart(startTime);
        return hits;
    }

    private class HitDocs {
        private BrowseHit[] _browseHits;
        private TopFieldDocs _topFieldDocs;

        public HitDocs(BrowseHit[] browseHits) {
            this._browseHits = browseHits;
        }

        public HitDocs(TopFieldDocs topFieldDocs) {
            this._topFieldDocs = topFieldDocs;
        }

        public int getDocId(int i2) {
            if (this._topFieldDocs != null) {
                ScoreDoc scoreDoc = this._topFieldDocs.scoreDocs[i2];
                return scoreDoc.doc;
            }
            if (this._browseHits != null) {
                return this._browseHits[i2].getDocid();
            }
            throw new IllegalStateException();
        }

        public float getScore(int i2) {
            if (this._topFieldDocs != null) {
                ScoreDoc scoreDoc = this._topFieldDocs.scoreDocs[i2];
                return scoreDoc.score;
            }
            if (this._browseHits != null) {
                return this._browseHits[i2].getScore();
            }
            throw new IllegalStateException();
        }

        public int getTotalHits() {
            if (this._topFieldDocs != null) {
                return this._topFieldDocs.totalHits;
            }
            if (this._browseHits != null) {
                return this._browseHits.length;
            }
            throw new IllegalStateException();
        }
    }

    private class TermCollectingFormatter
    implements Formatter {
        private Set<String> _terms = new HashSet<String>();

        private TermCollectingFormatter() {
        }

        public Set<String> getTerms() {
            return this._terms;
        }

        public String highlightTerm(String originalText, TokenGroup tokenGroup) {
            if (tokenGroup.getTotalScore() > 0.0f) {
                this._terms.add(originalText);
            }
            return originalText;
        }
    }
}

