/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.beanshell;

import bsh.Interpreter;
import com.liferay.portal.kernel.scripting.BaseScriptingExecutor;
import com.liferay.portal.kernel.scripting.ExecutionException;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.util.ClassLoaderUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BeanShellExecutor
extends BaseScriptingExecutor {
    public static final String LANGUAGE = "beanshell";

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String script, ClassLoader ... classLoaders) throws ScriptingException {
        Interpreter interpreter;
        block7: {
            if (allowedClasses != null) {
                throw new ExecutionException("Constrained execution not supported for BeanShell");
            }
            interpreter = new Interpreter();
            for (Map.Entry<String, Object> entry : inputObjects.entrySet()) {
                interpreter.set(entry.getKey(), entry.getValue());
            }
            if (classLoaders != null && classLoaders.length > 0) {
                ClassLoader aggregateClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (ClassLoader[])classLoaders);
                interpreter.setClassLoader(aggregateClassLoader);
            }
            interpreter.eval(script);
            if (outputNames != null) break block7;
            return null;
        }
        try {
            HashMap<String, Object> outputObjects = new HashMap<String, Object>();
            for (String outputName : outputNames) {
                outputObjects.put(outputName, interpreter.get(outputName));
            }
            return outputObjects;
        }
        catch (Exception e2) {
            throw new ScriptingException(e2.getMessage(), (Throwable)e2);
        }
    }

    public String getLanguage() {
        return LANGUAGE;
    }
}

