/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.spi.agent;

import com.liferay.portal.kernel.io.BigEndianCodec;
import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.mailbox.MailboxException;
import com.liferay.portal.kernel.nio.intraband.mailbox.MailboxUtil;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.Direction;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.DistributedRegistry;
import com.liferay.portal.kernel.util.ThreadLocalDistributor;
import com.liferay.portal.kernel.util.ThreadLocalDistributorRegistry;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SPIAgentSerializable
implements Serializable {
    protected ThreadLocalDistributor[] threadLocalDistributors;
    private static Log _log = LogFactoryUtil.getLog(SPIAgentSerializable.class);

    public static Map<String, Serializable> extractDistributedRequestAttributes(HttpServletRequest request, Direction direction) {
        HashMap<String, Serializable> distributedRequestAttributes = new HashMap<String, Serializable>();
        Enumeration enumeration = request.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            if (DistributedRegistry.isDistributed((String)name, (Direction)direction)) {
                Object value = request.getAttribute(name);
                if (value instanceof Serializable) {
                    distributedRequestAttributes.put(name, (Serializable)value);
                    continue;
                }
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Nonserializable distributed request attribute name " + name + " with value " + value));
                continue;
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Nondistributed request attribute name " + name + " with direction " + direction + " and value " + request.getAttribute(name)));
        }
        return distributedRequestAttributes;
    }

    public static Map<String, List<String>> extractRequestHeaders(HttpServletRequest request) {
        Map<String, List<String>> headers = new HashMap<String, List<String>>();
        Enumeration nameEnumeration = request.getHeaderNames();
        while (nameEnumeration.hasMoreElements()) {
            Enumeration valueEnumeration;
            String headerName = (String)nameEnumeration.nextElement();
            if ("Accept-Encoding".equalsIgnoreCase(headerName) || "Cookie".equalsIgnoreCase(headerName) || (valueEnumeration = request.getHeaders(headerName)) == null) continue;
            List<String> values = new ArrayList<String>();
            while (valueEnumeration.hasMoreElements()) {
                values.add((String)valueEnumeration.nextElement());
            }
            if (values.isEmpty()) {
                values = Collections.emptyList();
            }
            headers.put(headerName.toLowerCase(), values);
        }
        if (headers.isEmpty()) {
            headers = Collections.emptyMap();
        }
        return headers;
    }

    public static Map<String, Serializable> extractSessionAttributes(HttpSession session) {
        HashMap<String, Serializable> sessionAttributes = new HashMap<String, Serializable>();
        Enumeration enumeration = session.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            Object value = session.getAttribute(name);
            if (value instanceof Serializable) {
                sessionAttributes.put(name, (Serializable)value);
                continue;
            }
            if (!_log.isWarnEnabled()) continue;
            _log.warn((Object)("Nonserializable session attribute name " + name + " with value " + value));
        }
        return sessionAttributes;
    }

    public static <T extends SPIAgentSerializable> T readFrom(InputStream inputStream) throws IOException {
        byte[] data = new byte[8];
        int length = 0;
        while (length < 8) {
            int count = inputStream.read(data, length, 8 - length);
            if (count < 0) {
                throw new EOFException();
            }
            length += count;
        }
        long receipt = BigEndianCodec.getLong((byte[])data, (int)0);
        ByteBuffer byteBuffer = MailboxUtil.receiveMail((long)receipt);
        if (byteBuffer == null) {
            throw new IllegalArgumentException("No mail with receipt " + receipt);
        }
        Deserializer deserializer = new Deserializer(byteBuffer);
        try {
            return (T)((SPIAgentSerializable)deserializer.readObject());
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
    }

    public void writeTo(RegistrationReference registrationReference, OutputStream outputStream) throws IOException {
        Serializer serializer = new Serializer();
        serializer.writeObject((Serializable)this);
        try {
            byte[] data = new byte[8];
            ByteBuffer byteBuffer = serializer.toByteBuffer();
            long receipt = MailboxUtil.sendMail((RegistrationReference)registrationReference, (ByteBuffer)byteBuffer);
            BigEndianCodec.putLong((byte[])data, (int)0, (long)receipt);
            outputStream.write(data);
            outputStream.flush();
        }
        catch (MailboxException me) {
            throw new IOException(me);
        }
    }

    protected void captureThreadLocals() {
        ThreadLocalDistributor[] threadLocalDistributorArray = this.threadLocalDistributors = ThreadLocalDistributorRegistry.getThreadLocalDistributors();
        int n = this.threadLocalDistributors.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadLocalDistributor threadLocalDistributor = threadLocalDistributorArray[n2];
            threadLocalDistributor.capture();
            ++n2;
        }
    }

    protected void restoreThreadLocals() {
        ThreadLocalDistributor[] threadLocalDistributorArray = this.threadLocalDistributors;
        int n = this.threadLocalDistributors.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadLocalDistributor threadLocalDistributor = threadLocalDistributorArray[n2];
            threadLocalDistributor.restore();
            ++n2;
        }
    }
}

