/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.spi.agent;

import com.liferay.portal.kernel.resiliency.spi.agent.annotation.Direction;
import com.liferay.portal.kernel.servlet.PersistentHttpServletRequestWrapper;
import com.liferay.portal.kernel.upload.FileItem;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.CookieUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.resiliency.spi.agent.SPIAgentSerializable;
import com.liferay.portal.upload.UploadServletRequestImpl;
import com.liferay.portal.util.PortalUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SPIAgentRequest
extends SPIAgentSerializable {
    protected Cookie[] cookies;
    protected Map<String, Serializable> distributedRequestAttributes;
    protected Map<String, List<String>> headerMap;
    protected Map<String, FileItem[]> multipartParameterMap;
    protected Map<String, Serializable> originalSessionAttributes;
    protected Map<String, String[]> parameterMap;
    protected Map<String, List<String>> regularParameterMap;
    protected String serverName;
    protected int serverPort;

    public SPIAgentRequest(HttpServletRequest request) {
        this.cookies = request.getCookies();
        this.distributedRequestAttributes = SPIAgentRequest.extractDistributedRequestAttributes(request, Direction.REQUEST);
        this.headerMap = SPIAgentRequest.extractRequestHeaders(request);
        this.parameterMap = request.getParameterMap();
        this.serverName = request.getServerName();
        this.serverPort = request.getServerPort();
        String contentType = request.getHeader("Content-Type");
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            UploadServletRequest uploadServletRequest = PortalUtil.getUploadServletRequest((HttpServletRequest)request);
            Map multipartParameterMap = uploadServletRequest.getMultipartParameterMap();
            Map regularParameterMap = uploadServletRequest.getRegularParameterMap();
            if (!multipartParameterMap.isEmpty()) {
                this.multipartParameterMap = multipartParameterMap;
            }
            if (!regularParameterMap.isEmpty()) {
                this.regularParameterMap = regularParameterMap;
            }
        }
        HttpSession session = request.getSession();
        this.originalSessionAttributes = SPIAgentRequest.extractSessionAttributes(session);
        this.captureThreadLocals();
    }

    public Map<String, Serializable> getOriginalSessionAttributes() {
        return this.originalSessionAttributes;
    }

    public HttpServletRequest populateRequest(HttpServletRequest request) {
        request = new AgentHttpServletRequestWrapper((HttpServletRequest)request);
        for (Map.Entry<String, Serializable> entry : this.distributedRequestAttributes.entrySet()) {
            request.setAttribute(entry.getKey(), (Object)entry.getValue());
        }
        if (this.multipartParameterMap != null || this.regularParameterMap != null) {
            request = new UploadServletRequestImpl((HttpServletRequest)request, this.multipartParameterMap, this.regularParameterMap);
        }
        this.restoreThreadLocals();
        return request;
    }

    public void populateSessionAttributes(HttpSession httpSession) {
        for (Map.Entry<String, Serializable> entry : this.originalSessionAttributes.entrySet()) {
            httpSession.setAttribute(entry.getKey(), (Object)entry.getValue());
        }
    }

    public String toString() {
        int length = 16 + this.parameterMap.size() * 4;
        if (this.cookies != null) {
            length += this.cookies.length * 2 - 1;
        }
        StringBundler sb = new StringBundler(length);
        sb.append("{cookies=[");
        if (this.cookies != null) {
            Cookie[] cookieArray = this.cookies;
            int n = this.cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                sb.append(CookieUtil.toString((Cookie)cookie));
                sb.append(", ");
                ++n2;
            }
            sb.setIndex(sb.index() - 1);
        }
        sb.append("], distributedRequestAttributes=");
        sb.append(this.distributedRequestAttributes);
        sb.append(", _headerMap=");
        sb.append(this.headerMap);
        sb.append(", _multipartParameterMap=");
        sb.append(this.multipartParameterMap);
        sb.append(", originalSessionAttributes=");
        sb.append(this.originalSessionAttributes);
        sb.append(", parameterMap={");
        for (Map.Entry<String, String[]> entry : this.parameterMap.entrySet()) {
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(Arrays.toString(entry.getValue()));
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append("}, _regularParameterMap=");
        sb.append(this.regularParameterMap);
        sb.append(", _serverName=");
        sb.append(this.serverName);
        sb.append(", _serverPort=");
        sb.append(this.serverPort);
        sb.append("}");
        return sb.toString();
    }

    protected class AgentHttpServletRequestWrapper
    extends PersistentHttpServletRequestWrapper {
        public AgentHttpServletRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public Cookie[] getCookies() {
            return SPIAgentRequest.this.cookies;
        }

        public String getHeader(String name) {
            List<String> values = SPIAgentRequest.this.headerMap.get(name.toLowerCase());
            if (values == null || values.isEmpty()) {
                return null;
            }
            return values.get(0);
        }

        public Enumeration<String> getHeaderNames() {
            return Collections.enumeration(SPIAgentRequest.this.headerMap.keySet());
        }

        public Enumeration<String> getHeaders(String name) {
            List<String> values = SPIAgentRequest.this.headerMap.get(name.toLowerCase());
            if (values == null) {
                values = Collections.emptyList();
            }
            return Collections.enumeration(values);
        }

        public String getParameter(String name) {
            String[] values = SPIAgentRequest.this.parameterMap.get(name);
            if (values != null && values.length > 0) {
                return values[0];
            }
            return null;
        }

        public Map<String, String[]> getParameterMap() {
            return SPIAgentRequest.this.parameterMap;
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(SPIAgentRequest.this.parameterMap.keySet());
        }

        public String[] getParameterValues(String name) {
            return SPIAgentRequest.this.parameterMap.get(name);
        }

        public String getServerName() {
            return SPIAgentRequest.this.serverName;
        }

        public int getServerPort() {
            return SPIAgentRequest.this.serverPort;
        }
    }
}

