/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.service;

import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class ServiceMethodProcessCallable
implements Externalizable,
ProcessCallable<Serializable> {
    private String _beanIdentifier;
    private MethodHandler _methodHandler;
    private String _servletContextName;
    private long _userId;

    public ServiceMethodProcessCallable() {
    }

    public ServiceMethodProcessCallable(String servletContextName, String beanIdentifier, MethodHandler methodHandler) {
        this._servletContextName = servletContextName;
        this._beanIdentifier = beanIdentifier;
        this._methodHandler = methodHandler;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null) {
            this._userId = permissionChecker.getUserId();
        }
    }

    public Serializable call() throws ProcessException {
        String oldName = PrincipalThreadLocal.getName();
        PermissionChecker oldPermissionChecker = PermissionThreadLocal.getPermissionChecker();
        try {
            if (this._userId != 0L) {
                PrincipalThreadLocal.setName((long)this._userId);
                User user = UserLocalServiceUtil.fetchUser((long)this._userId);
                if (user != null) {
                    PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
                    PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
                }
            }
            Object bean = PortletBeanLocatorUtil.locate((String)this._servletContextName, (String)this._beanIdentifier);
            Serializable serializable = (Serializable)this._methodHandler.invoke(bean);
            return serializable;
        }
        catch (Exception e2) {
            throw new ProcessException((Throwable)e2);
        }
        finally {
            PrincipalThreadLocal.setName((String)oldName);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)oldPermissionChecker);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this._beanIdentifier = objectInput.readUTF();
        this._methodHandler = (MethodHandler)objectInput.readObject();
        this._servletContextName = objectInput.readUTF();
        this._userId = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this._beanIdentifier);
        objectOutput.writeObject(this._methodHandler);
        objectOutput.writeUTF(this._servletContextName);
        objectOutput.writeLong(this._userId);
    }
}

