/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.service;

import com.liferay.portal.kernel.bean.IdentifiableBean;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.rpc.IntrabandRPCUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIRegistryUtil;
import com.liferay.portal.kernel.util.ClassLoaderPool;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.resiliency.service.ServiceMethodProcessCallable;
import com.liferay.portal.security.ac.AccessControl;
import com.liferay.portal.security.ac.AccessControlThreadLocal;
import com.liferay.portal.security.ac.AccessControlled;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import org.aopalliance.intercept.MethodInvocation;

public class PortalResiliencyAdvice
extends AnnotationChainableMethodAdvice<AccessControlled> {
    private static Log _log = LogFactoryUtil.getLog(PortalResiliencyAdvice.class);

    @Override
    public Object before(MethodInvocation methodInvocation) throws Throwable {
        AccessControlled accessControlled = (AccessControlled)this.findAnnotation(methodInvocation);
        if (accessControlled == AccessControl.NULL_ACCESS_CONTROLLED) {
            return null;
        }
        boolean remoteAccess = AccessControlThreadLocal.isRemoteAccess();
        if (!remoteAccess) {
            return null;
        }
        Object targetObject = methodInvocation.getThis();
        if (targetObject == null) {
            return null;
        }
        Class<?> targetClass = targetObject.getClass();
        String servletContextName = ClassLoaderPool.getContextName((ClassLoader)targetClass.getClassLoader());
        SPI spi = SPIRegistryUtil.getServletContextSPI((String)servletContextName);
        if (spi == null) {
            this.serviceBeanAopCacheManager.removeMethodInterceptor(methodInvocation, this);
            return null;
        }
        if (!(targetObject instanceof IdentifiableBean)) {
            Class<?> clazz = targetObject.getClass();
            _log.error((Object)("Unable to bridge portal resiliency call for " + clazz.getName() + " because it does not implement " + IdentifiableBean.class.getName()));
            return null;
        }
        IdentifiableBean identifiableBean = (IdentifiableBean)targetObject;
        ServiceMethodProcessCallable serviceMethodProcessCallable = new ServiceMethodProcessCallable(servletContextName, identifiableBean.getBeanIdentifier(), new MethodHandler(methodInvocation.getMethod(), methodInvocation.getArguments()));
        return IntrabandRPCUtil.execute((RegistrationReference)spi.getRegistrationReference(), (ProcessCallable)serviceMethodProcessCallable);
    }

    @Override
    public AccessControlled getNullAnnotation() {
        return AccessControl.NULL_ACCESS_CONTROLLED;
    }
}

