/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.mpi.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.ActionResult;
import com.liferay.portal.kernel.portlet.PortletContainer;
import com.liferay.portal.kernel.portlet.PortletContainerException;
import com.liferay.portal.kernel.resiliency.PortalResiliencyException;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIRegistryUtil;
import com.liferay.portal.kernel.resiliency.spi.agent.SPIAgent;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.util.PropsValues;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.List;
import javax.portlet.Event;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortalResiliencyPortletContainerWrapper
implements PortletContainer {
    private static Log _log = LogFactoryUtil.getLog(PortalResiliencyPortletContainerWrapper.class);
    private PortletContainer _portletContainer;

    public static PortletContainer createPortalResiliencyPortletContainerWrapper(PortletContainer portletContainer) {
        if (PropsValues.PORTAL_RESILIENCY_ENABLED) {
            portletContainer = new PortalResiliencyPortletContainerWrapper(portletContainer);
        }
        return portletContainer;
    }

    public PortalResiliencyPortletContainerWrapper(PortletContainer portletContainer) {
        this._portletContainer = portletContainer;
    }

    public void preparePortlet(HttpServletRequest request, Portlet portlet) throws PortletContainerException {
        this._portletContainer.preparePortlet(request, portlet);
    }

    public ActionResult processAction(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        SPIAgent spiAgent = this.getSPIAgentForPortlet(portlet);
        if (spiAgent == null) {
            return this._portletContainer.processAction(request, response, portlet);
        }
        request.setAttribute("SPI_AGENT_LIFECYCLE", (Object)SPIAgent.Lifecycle.ACTION);
        request.setAttribute("SPI_AGENT_PORTLET", (Object)portlet);
        try {
            spiAgent.service(request, response);
            ActionResult actionResult = (ActionResult)request.getAttribute("SPI_AGENT_ACTION_RESULT");
            return actionResult;
        }
        catch (PortalResiliencyException pre) {
            _log.error((Object)pre, (Throwable)pre);
            ActionResult actionResult = ActionResult.EMPTY_ACTION_RESULT;
            return actionResult;
        }
        finally {
            request.removeAttribute("SPI_AGENT_ACTION_RESULT");
            request.removeAttribute("SPI_AGENT_LIFECYCLE");
            request.removeAttribute("SPI_AGENT_PORTLET");
        }
    }

    public List<Event> processEvent(HttpServletRequest request, HttpServletResponse response, Portlet portlet, Layout layout, Event event) throws PortletContainerException {
        SPIAgent spiAgent = this.getSPIAgentForPortlet(portlet);
        if (spiAgent == null) {
            return this._portletContainer.processEvent(request, response, portlet, layout, event);
        }
        request.setAttribute("SPI_AGENT_EVENT", (Object)event);
        request.setAttribute("SPI_AGENT_LAYOUT", (Object)layout);
        request.setAttribute("SPI_AGENT_LIFECYCLE", (Object)SPIAgent.Lifecycle.EVENT);
        request.setAttribute("SPI_AGENT_PORTLET", (Object)portlet);
        try {
            spiAgent.service(request, response);
            List list = (List)request.getAttribute("SPI_AGENT_EVENT_RESULT");
            return list;
        }
        catch (PortalResiliencyException pre) {
            _log.error((Object)pre, (Throwable)pre);
            List<Event> list = Collections.emptyList();
            return list;
        }
        finally {
            request.removeAttribute("SPI_AGENT_EVENT");
            request.removeAttribute("SPI_AGENT_EVENT_RESULT");
            request.removeAttribute("SPI_AGENT_LAYOUT");
            request.removeAttribute("SPI_AGENT_LIFECYCLE");
            request.removeAttribute("SPI_AGENT_PORTLET");
        }
    }

    public void render(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        SPIAgent spiAgent = this.getSPIAgentForPortlet(portlet);
        if (spiAgent == null) {
            this._portletContainer.render(request, response, portlet);
            return;
        }
        request.setAttribute("SPI_AGENT_LIFECYCLE", (Object)SPIAgent.Lifecycle.RENDER);
        request.setAttribute("SPI_AGENT_PORTLET", (Object)portlet);
        try {
            try {
                spiAgent.service(request, response);
            }
            catch (PortalResiliencyException pre) {
                _log.error((Object)pre, (Throwable)pre);
                request.removeAttribute("SPI_AGENT_LIFECYCLE");
                request.removeAttribute("SPI_AGENT_PORTLET");
            }
        }
        finally {
            request.removeAttribute("SPI_AGENT_LIFECYCLE");
            request.removeAttribute("SPI_AGENT_PORTLET");
        }
    }

    public void serveResource(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws PortletContainerException {
        SPIAgent spiAgent = this.getSPIAgentForPortlet(portlet);
        if (spiAgent == null) {
            this._portletContainer.serveResource(request, response, portlet);
            return;
        }
        request.setAttribute("SPI_AGENT_LIFECYCLE", (Object)SPIAgent.Lifecycle.RESOURCE);
        request.setAttribute("SPI_AGENT_PORTLET", (Object)portlet);
        try {
            try {
                spiAgent.service(request, response);
            }
            catch (PortalResiliencyException pre) {
                _log.error((Object)pre, (Throwable)pre);
                request.removeAttribute("SPI_AGENT_LIFECYCLE");
                request.removeAttribute("SPI_AGENT_PORTLET");
            }
        }
        finally {
            request.removeAttribute("SPI_AGENT_LIFECYCLE");
            request.removeAttribute("SPI_AGENT_PORTLET");
        }
    }

    protected SPIAgent getSPIAgentForPortlet(Portlet portlet) throws PortletContainerException {
        SPI spi = SPIRegistryUtil.getPortletSPI((String)portlet.getRootPortletId());
        if (spi == null) {
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Portlet " + portlet + " is registered to SPI " + spi));
        }
        try {
            return spi.getSPIAgent();
        }
        catch (RemoteException re) {
            throw new PortletContainerException((Throwable)re);
        }
    }
}

