/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository.model;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.repository.liferayrepository.model.LiferayModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.portlet.expando.model.ExpandoBridge;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class LiferayFolder
extends LiferayModel
implements Folder {
    private DLFolder _dlFolder;
    private boolean _escapedModel;

    public LiferayFolder(DLFolder dlFolder) {
        this._dlFolder = dlFolder;
    }

    public LiferayFolder(DLFolder dlFolder, boolean escapedModel) {
        this._dlFolder = dlFolder;
        this._escapedModel = escapedModel;
    }

    public Object clone() {
        LiferayFolder liferayFolder = new LiferayFolder(this._dlFolder, this._escapedModel);
        liferayFolder.setCompanyId(this.getCompanyId());
        liferayFolder.setCreateDate(this.getCreateDate());
        liferayFolder.setGroupId(this.getGroupId());
        liferayFolder.setModifiedDate(this.getModifiedDate());
        liferayFolder.setPrimaryKey(this.getPrimaryKey());
        liferayFolder.setUserId(this.getUserId());
        liferayFolder.setUserName(this.getUserName());
        try {
            liferayFolder.setUserUuid(this.getUserUuid());
        }
        catch (SystemException systemException) {}
        liferayFolder.setUuid(this.getUuid());
        return liferayFolder;
    }

    public boolean containsPermission(PermissionChecker permissionChecker, String actionId) throws PortalException, SystemException {
        return DLFolderPermission.contains(permissionChecker, this._dlFolder, actionId);
    }

    public List<Long> getAncestorFolderIds() throws PortalException, SystemException {
        return this._dlFolder.getAncestorFolderIds();
    }

    public List<Folder> getAncestors() throws PortalException, SystemException {
        return this.toFolders(this._dlFolder.getAncestors());
    }

    public Map<String, Serializable> getAttributes() {
        ExpandoBridge expandoBridge = this.getExpandoBridge();
        return expandoBridge.getAttributes();
    }

    @Override
    public long getCompanyId() {
        return this._dlFolder.getCompanyId();
    }

    public Date getCreateDate() {
        return this._dlFolder.getCreateDate();
    }

    public String getDescription() {
        return this._dlFolder.getDescription();
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return this._dlFolder.getExpandoBridge();
    }

    public long getFolderId() {
        return this._dlFolder.getFolderId();
    }

    public long getGroupId() {
        return this._dlFolder.getGroupId();
    }

    public Date getLastPostDate() {
        return this._dlFolder.getLastPostDate();
    }

    public Object getModel() {
        return this._dlFolder;
    }

    public Class<?> getModelClass() {
        return LiferayFolder.class;
    }

    @Override
    public String getModelClassName() {
        return LiferayFolder.class.getName();
    }

    public Date getModifiedDate() {
        return this._dlFolder.getModifiedDate();
    }

    public String getName() {
        return this._dlFolder.getName();
    }

    public Folder getParentFolder() throws PortalException, SystemException {
        DLFolder dlParentFolder = this._dlFolder.getParentFolder();
        if (dlParentFolder == null) {
            return null;
        }
        return new LiferayFolder(dlParentFolder);
    }

    public long getParentFolderId() {
        return this._dlFolder.getParentFolderId();
    }

    @Override
    public long getPrimaryKey() {
        return this._dlFolder.getPrimaryKey();
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this.getPrimaryKey());
    }

    public long getRepositoryId() {
        return this._dlFolder.getRepositoryId();
    }

    public long getUserId() {
        return this._dlFolder.getUserId();
    }

    public String getUserName() {
        return this._dlFolder.getUserName();
    }

    public String getUserUuid() throws SystemException {
        return this._dlFolder.getUserUuid();
    }

    public String getUuid() {
        return this._dlFolder.getUuid();
    }

    public boolean hasInheritableLock() {
        return this._dlFolder.hasInheritableLock();
    }

    public boolean hasLock() {
        return this._dlFolder.hasLock();
    }

    public boolean isDefaultRepository() {
        return this._dlFolder.getGroupId() == this._dlFolder.getRepositoryId();
    }

    public boolean isEscapedModel() {
        return this._escapedModel;
    }

    public boolean isLocked() {
        return this._dlFolder.isLocked();
    }

    public boolean isMountPoint() {
        return this._dlFolder.isMountPoint();
    }

    public boolean isRoot() {
        return this._dlFolder.isRoot();
    }

    public boolean isSupportsLocking() {
        return !this.isMountPoint();
    }

    public boolean isSupportsMetadata() {
        return !this.isMountPoint();
    }

    public boolean isSupportsMultipleUpload() {
        return !this.isMountPoint();
    }

    public boolean isSupportsShortcuts() {
        return !this.isMountPoint();
    }

    public boolean isSupportsSocial() {
        return !this.isMountPoint();
    }

    public boolean isSupportsSubscribing() {
        return !this.isMountPoint();
    }

    public void setCompanyId(long companyId) {
        this._dlFolder.setCompanyId(companyId);
    }

    public void setCreateDate(Date date) {
        this._dlFolder.setCreateDate(date);
    }

    public void setGroupId(long groupId) {
        this._dlFolder.setGroupId(groupId);
    }

    public void setModifiedDate(Date date) {
        this._dlFolder.setModifiedDate(date);
    }

    public void setPrimaryKey(long primaryKey) {
        this._dlFolder.setPrimaryKey(primaryKey);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public void setUserId(long userId) {
        this._dlFolder.setUserId(userId);
    }

    public void setUserName(String userName) {
        this._dlFolder.setUserName(userName);
    }

    public void setUserUuid(String userUuid) {
        this._dlFolder.setUserUuid(userUuid);
    }

    public void setUuid(String uuid) {
        this._dlFolder.setUuid(uuid);
    }

    public Folder toEscapedModel() {
        if (this.isEscapedModel()) {
            return this;
        }
        return new LiferayFolder(this._dlFolder.toEscapedModel(), true);
    }

    public String toString() {
        return this._dlFolder.toString();
    }

    public Folder toUnescapedModel() {
        if (this.isEscapedModel()) {
            return new LiferayFolder(this._dlFolder.toUnescapedModel(), true);
        }
        return this;
    }
}

