/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository.model;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayModel;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

public class LiferayFileVersion
extends LiferayModel
implements FileVersion {
    private DLFileVersion _dlFileVersion;
    private boolean _escapedModel;

    public LiferayFileVersion(DLFileVersion dlFileVersion) {
        this._dlFileVersion = dlFileVersion;
    }

    public LiferayFileVersion(DLFileVersion dlFileVersion, boolean escapedModel) {
        this._dlFileVersion = dlFileVersion;
        this._escapedModel = escapedModel;
    }

    public Object clone() {
        LiferayFileVersion liferayFileVersion = new LiferayFileVersion(this._dlFileVersion, this._escapedModel);
        liferayFileVersion.setCompanyId(this.getCompanyId());
        liferayFileVersion.setCreateDate(this.getCreateDate());
        liferayFileVersion.setGroupId(this.getGroupId());
        liferayFileVersion.setPrimaryKey(this.getPrimaryKey());
        liferayFileVersion.setUserId(this.getUserId());
        liferayFileVersion.setUserName(this.getUserName());
        try {
            liferayFileVersion.setUserUuid(this.getUserUuid());
        }
        catch (Exception exception) {}
        liferayFileVersion.setUuid(this.getUuid());
        return liferayFileVersion;
    }

    public Map<String, Serializable> getAttributes() {
        ExpandoBridge expandoBridge = this._dlFileVersion.getExpandoBridge();
        return expandoBridge.getAttributes();
    }

    public String getChangeLog() {
        return this._dlFileVersion.getChangeLog();
    }

    @Override
    public long getCompanyId() {
        return this._dlFileVersion.getCompanyId();
    }

    public InputStream getContentStream(boolean incrementCounter) throws PortalException, SystemException {
        return this._dlFileVersion.getContentStream(incrementCounter);
    }

    public Date getCreateDate() {
        return this._dlFileVersion.getCreateDate();
    }

    public String getDescription() {
        return this._dlFileVersion.getDescription();
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return this._dlFileVersion.getExpandoBridge();
    }

    public String getExtension() {
        return this._dlFileVersion.getExtension();
    }

    public String getExtraSettings() {
        return this._dlFileVersion.getExtraSettings();
    }

    public File getFile(boolean incrementCounter) throws PortalException, SystemException {
        return DLFileEntryLocalServiceUtil.getFile((long)PrincipalThreadLocal.getUserId(), (long)this._dlFileVersion.getFileEntryId(), (String)this._dlFileVersion.getVersion(), (boolean)incrementCounter);
    }

    public FileEntry getFileEntry() throws PortalException, SystemException {
        return new LiferayFileEntry(this._dlFileVersion.getFileEntry());
    }

    public long getFileEntryId() {
        return this._dlFileVersion.getFileEntryId();
    }

    public long getFileVersionId() {
        return this._dlFileVersion.getFileVersionId();
    }

    public long getGroupId() {
        return this._dlFileVersion.getGroupId();
    }

    public String getIcon() {
        return this._dlFileVersion.getIcon();
    }

    public String getMimeType() {
        return this._dlFileVersion.getMimeType();
    }

    public Object getModel() {
        return this._dlFileVersion;
    }

    public Class<?> getModelClass() {
        return LiferayFileVersion.class;
    }

    @Override
    public String getModelClassName() {
        return LiferayFileVersion.class.getName();
    }

    public Date getModifiedDate() {
        return this._dlFileVersion.getModifiedDate();
    }

    @Override
    public long getPrimaryKey() {
        return this._dlFileVersion.getPrimaryKey();
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this.getPrimaryKey());
    }

    public long getRepositoryId() {
        return this._dlFileVersion.getRepositoryId();
    }

    public long getSize() {
        return this._dlFileVersion.getSize();
    }

    public int getStatus() {
        return this._dlFileVersion.getStatus();
    }

    public long getStatusByUserId() {
        return this._dlFileVersion.getStatusByUserId();
    }

    public String getStatusByUserName() {
        return this._dlFileVersion.getStatusByUserName();
    }

    public String getStatusByUserUuid() throws SystemException {
        return this._dlFileVersion.getStatusByUserUuid();
    }

    public Date getStatusDate() {
        return this._dlFileVersion.getStatusDate();
    }

    public String getTitle() {
        return this._dlFileVersion.getTitle();
    }

    public DLFolder getTrashContainer() {
        return this._dlFileVersion.getTrashContainer();
    }

    public long getUserId() {
        return this._dlFileVersion.getUserId();
    }

    public String getUserName() {
        return this._dlFileVersion.getUserName();
    }

    public String getUserUuid() throws SystemException {
        return this._dlFileVersion.getUserUuid();
    }

    public String getUuid() {
        return this._dlFileVersion.getUuid();
    }

    public String getVersion() {
        return this._dlFileVersion.getVersion();
    }

    public boolean isApproved() {
        return this._dlFileVersion.isApproved();
    }

    public boolean isDefaultRepository() {
        return this._dlFileVersion.getGroupId() == this._dlFileVersion.getRepositoryId();
    }

    public boolean isDraft() {
        return this._dlFileVersion.isDraft();
    }

    public boolean isEscapedModel() {
        return this._escapedModel;
    }

    public boolean isExpired() {
        return this._dlFileVersion.isExpired();
    }

    public boolean isInTrash() {
        return this._dlFileVersion.isInTrash();
    }

    public boolean isInTrashContainer() {
        return this._dlFileVersion.isInTrashContainer();
    }

    public boolean isPending() {
        return this._dlFileVersion.isPending();
    }

    public void setCompanyId(long companyId) {
        this._dlFileVersion.setCompanyId(companyId);
    }

    public void setCreateDate(Date date) {
        this._dlFileVersion.setCreateDate(date);
    }

    public void setGroupId(long groupId) {
        this._dlFileVersion.setGroupId(groupId);
    }

    public void setModifiedDate(Date date) {
    }

    public void setPrimaryKey(long primaryKey) {
        this._dlFileVersion.setPrimaryKey(primaryKey);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public void setUserId(long userId) {
        this._dlFileVersion.setUserId(userId);
    }

    public void setUserName(String userName) {
        this._dlFileVersion.setUserName(userName);
    }

    public void setUserUuid(String userUuid) {
        this._dlFileVersion.setUserUuid(userUuid);
    }

    public void setUuid(String uuid) {
        this._dlFileVersion.setUuid(uuid);
    }

    public FileVersion toEscapedModel() {
        if (this.isEscapedModel()) {
            return this;
        }
        return new LiferayFileVersion(this._dlFileVersion.toEscapedModel(), true);
    }

    public String toString() {
        return this._dlFileVersion.toString();
    }

    public FileVersion toUnescapedModel() {
        if (this.isEscapedModel()) {
            return new LiferayFileVersion(this._dlFileVersion.toUnescapedModel(), true);
        }
        return this;
    }
}

