/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.cmis.model;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.repository.cmis.CMISRepository;
import com.liferay.portal.repository.cmis.model.CMISModel;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.service.CMISRepositoryLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.service.DLAppHelperLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;

public class CMISFileVersion
extends CMISModel
implements FileVersion {
    private static Log _log = LogFactoryUtil.getLog(CMISFileVersion.class);
    private CMISRepository _cmisRepository;
    private Document _document;
    private long _fileVersionId;
    private String _uuid;

    public CMISFileVersion(CMISRepository cmisRepository, String uuid, long fileVersionId, Document document) {
        this._cmisRepository = cmisRepository;
        this._uuid = uuid;
        this._fileVersionId = fileVersionId;
        this._document = document;
    }

    public Object clone() {
        CMISFileVersion cmisFileVersion = new CMISFileVersion(this._cmisRepository, this._uuid, this._fileVersionId, this._document);
        cmisFileVersion.setCompanyId(this.getCompanyId());
        this.setFileVersionId(this.getFileVersionId());
        cmisFileVersion.setGroupId(this.getGroupId());
        try {
            cmisFileVersion.setParentFolder(this.getParentFolder());
        }
        catch (Exception exception) {}
        cmisFileVersion.setPrimaryKey(this.getPrimaryKey());
        return cmisFileVersion;
    }

    public Map<String, Serializable> getAttributes() {
        return new HashMap<String, Serializable>();
    }

    public String getChangeLog() {
        return this._document.getCheckinComment();
    }

    @Override
    public long getCompanyId() {
        return this._cmisRepository.getCompanyId();
    }

    public InputStream getContentStream(boolean incrementCounter) {
        ContentStream contentStream = this._document.getContentStream();
        try {
            DLAppHelperLocalServiceUtil.getFileAsStream((long)PrincipalThreadLocal.getUserId(), (FileEntry)this.getFileEntry(), (boolean)incrementCounter);
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
        return contentStream.getStream();
    }

    public Date getCreateDate() {
        GregorianCalendar creationDate = this._document.getCreationDate();
        return creationDate.getTime();
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return null;
    }

    public String getExtension() {
        return FileUtil.getExtension((String)this.getTitle());
    }

    public String getExtraSettings() {
        return null;
    }

    public FileEntry getFileEntry() throws PortalException, SystemException {
        Document document = null;
        try {
            List allVersions = this._document.getAllVersions();
            document = allVersions.isEmpty() ? this._document : (Document)allVersions.get(0);
        }
        catch (CmisObjectNotFoundException confe) {
            throw new NoSuchFileEntryException((Throwable)confe);
        }
        return CMISRepositoryLocalServiceUtil.toFileEntry((long)this.getRepositoryId(), (Object)document);
    }

    public long getFileEntryId() {
        try {
            return this.getFileEntry().getFileEntryId();
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return 0L;
    }

    public long getFileVersionId() {
        return this._fileVersionId;
    }

    public long getGroupId() {
        return this._cmisRepository.getGroupId();
    }

    public String getIcon() {
        return DLUtil.getFileIcon((String)this.getExtension());
    }

    public String getMimeType() {
        String mimeType = this._document.getContentStreamMimeType();
        if (Validator.isNotNull((String)mimeType)) {
            return mimeType;
        }
        return MimeTypesUtil.getContentType((String)this.getTitle());
    }

    public Object getModel() {
        return this._document;
    }

    public Class<?> getModelClass() {
        return CMISFileVersion.class;
    }

    @Override
    public String getModelClassName() {
        return CMISFileVersion.class.getName();
    }

    public Date getModifiedDate() {
        GregorianCalendar modificationDate = this._document.getLastModificationDate();
        return modificationDate.getTime();
    }

    @Override
    public long getPrimaryKey() {
        return this._fileVersionId;
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this.getPrimaryKey());
    }

    public long getRepositoryId() {
        return this._cmisRepository.getRepositoryId();
    }

    public long getSize() {
        return this._document.getContentStreamLength();
    }

    public int getStatus() {
        return 0;
    }

    public long getStatusByUserId() {
        return 0L;
    }

    public String getStatusByUserName() {
        return null;
    }

    public String getStatusByUserUuid() {
        return null;
    }

    public Date getStatusDate() {
        return this.getModifiedDate();
    }

    public String getTitle() {
        return this._document.getName();
    }

    public long getUserId() {
        try {
            return UserLocalServiceUtil.getDefaultUserId((long)this.getCompanyId());
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public String getUserName() {
        return this._document.getCreatedBy();
    }

    public String getUserUuid() {
        try {
            User user = UserLocalServiceUtil.getDefaultUser((long)this.getCompanyId());
            return user.getUserUuid();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getUuid() {
        return this._uuid;
    }

    public String getVersion() {
        return GetterUtil.getString((String)this._document.getVersionLabel());
    }

    public boolean isApproved() {
        return false;
    }

    public boolean isDefaultRepository() {
        return false;
    }

    public boolean isDraft() {
        return false;
    }

    public boolean isEscapedModel() {
        return false;
    }

    public boolean isExpired() {
        return false;
    }

    public boolean isInTrash() {
        return false;
    }

    public boolean isInTrashContainer() {
        return false;
    }

    public boolean isPending() {
        return false;
    }

    public void setCompanyId(long companyId) {
        this._cmisRepository.setCompanyId(companyId);
    }

    public void setCreateDate(Date date) {
    }

    public void setFileVersionId(long fileVersionId) {
        this._fileVersionId = fileVersionId;
    }

    public void setGroupId(long groupId) {
        this._cmisRepository.setGroupId(groupId);
    }

    public void setModifiedDate(Date date) {
    }

    public void setPrimaryKey(long primaryKey) {
        this.setFileVersionId(primaryKey);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public void setUserId(long userId) {
    }

    public void setUserName(String userName) {
    }

    public void setUserUuid(String userUuid) {
    }

    public void setUuid(String uuid) {
    }

    public FileVersion toEscapedModel() {
        return this;
    }

    public FileVersion toUnescapedModel() {
        return this;
    }

    @Override
    protected CMISRepository getCmisRepository() {
        return this._cmisRepository;
    }
}

