/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.pop;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.pop.MessageListener;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerType;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.pop.MessageListenerWrapper;
import com.liferay.portal.pop.messaging.POPNotificationsMessageListener;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class POPServerUtil {
    private static Log _log = LogFactoryUtil.getLog(POPServerUtil.class);
    private static POPServerUtil _instance = new POPServerUtil();
    private List<MessageListener> _listeners = new ArrayList<MessageListener>();

    public static void addListener(MessageListener listener) throws Exception {
        _instance._addListener(listener);
    }

    public static void deleteListener(MessageListener listener) throws Exception {
        _instance._deleteListener(listener);
    }

    public static List<MessageListener> getListeners() throws Exception {
        return _instance._getListeners();
    }

    public static void start() {
        _instance._start();
    }

    private POPServerUtil() {
    }

    private void _addListener(MessageListener listener) {
        if (listener == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Do not add null listener");
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Add listener " + listener.getClass().getName()));
        }
        MessageListenerWrapper messageListenerWrapper = new MessageListenerWrapper(listener);
        this._deleteListener(messageListenerWrapper);
        this._listeners.add(messageListenerWrapper);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Listeners size " + this._listeners.size()));
        }
    }

    private void _deleteListener(MessageListener listener) {
        if (listener == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Do not delete null listener");
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Delete listener " + listener.getClass().getName()));
        }
        MessageListenerWrapper messageListenerWrapper = new MessageListenerWrapper(listener);
        this._deleteListener(messageListenerWrapper);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Listeners size " + this._listeners.size()));
        }
    }

    private void _deleteListener(MessageListenerWrapper listener) {
        Iterator<MessageListener> itr = this._listeners.iterator();
        while (itr.hasNext()) {
            MessageListenerWrapper curListener = (MessageListenerWrapper)itr.next();
            if (!curListener.equals(listener)) continue;
            itr.remove();
        }
    }

    private List<MessageListener> _getListeners() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Listeners size " + this._listeners.size()));
        }
        return new UnmodifiableList(this._listeners);
    }

    private void _start() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Start");
        }
        try {
            SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl();
            schedulerEntry.setEventListenerClass(POPNotificationsMessageListener.class.getName());
            schedulerEntry.setTimeUnit(TimeUnit.MINUTE);
            schedulerEntry.setTriggerType(TriggerType.SIMPLE);
            schedulerEntry.setTriggerValue(PropsValues.POP_SERVER_NOTIFICATIONS_INTERVAL);
            SchedulerEngineHelperUtil.schedule((SchedulerEntry)schedulerEntry, (StorageType)StorageType.MEMORY_CLUSTERED, null, (int)0);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }
}

