/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.patcher;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.patcher.Patcher;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

@DoPrivileged
public class PatcherImpl
implements Patcher {
    private static Log _log = LogFactoryUtil.getLog(PatcherImpl.class);
    private static boolean _configured;
    private static String[] _fixedIssueKeys;
    private static String[] _installedPatchNames;
    private static File _patchDirectory;
    private static Properties _properties;

    public boolean applyPatch(File patchFile) {
        File patchDirectory = this.getPatchDirectory();
        if (patchDirectory == null) {
            return false;
        }
        try {
            FileUtil.copyFile((File)patchFile, (File)new File(patchDirectory + "/" + patchFile.getName()));
            return true;
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to copy " + patchFile.getAbsolutePath() + " to " + patchDirectory.getAbsolutePath()));
            return false;
        }
    }

    public String[] getFixedIssues() {
        if (_fixedIssueKeys != null) {
            return _fixedIssueKeys;
        }
        Properties properties = this.getProperties();
        _fixedIssueKeys = StringUtil.split((String)properties.getProperty("fixed.issues"));
        return _fixedIssueKeys;
    }

    public String[] getInstalledPatches() {
        if (_installedPatchNames != null) {
            return _installedPatchNames;
        }
        Properties properties = this.getProperties();
        _installedPatchNames = StringUtil.split((String)properties.getProperty("installed.patches"));
        return _installedPatchNames;
    }

    public File getPatchDirectory() {
        if (_patchDirectory != null) {
            return _patchDirectory;
        }
        Properties properties = this.getProperties();
        String patchDirectoryName = properties.getProperty("patch.directory");
        if (Validator.isNotNull((String)patchDirectoryName)) {
            _patchDirectory = new File(patchDirectoryName);
            if (!_patchDirectory.exists()) {
                _log.error((Object)"The patch directory does not exist");
            }
        } else {
            _log.error((Object)"The patch directory is not specified");
        }
        return _patchDirectory;
    }

    public Properties getProperties() {
        Properties properties;
        block9: {
            if (_properties != null) {
                return _properties;
            }
            properties = new Properties();
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("patcher.properties");
            if (inputStream == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Unable to load patcher.properties");
                }
            } else {
                try {
                    try {
                        properties.load(inputStream);
                        _configured = true;
                    }
                    catch (IOException ioe) {
                        _log.error((Object)ioe, (Throwable)ioe);
                        StreamUtil.cleanUp((InputStream)inputStream);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    StreamUtil.cleanUp((InputStream)inputStream);
                    throw throwable;
                }
                StreamUtil.cleanUp((InputStream)inputStream);
            }
        }
        _properties = properties;
        return _properties;
    }

    public boolean isConfigured() {
        return _configured;
    }
}

