/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.module.framework;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.module.framework.ModuleFrameworkClassLoader;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

public class ModuleFrameworkAdapterHelper {
    private static Log _log = LogFactoryUtil.getLog(ModuleFrameworkAdapterHelper.class);
    private static ClassLoader _classLoader;
    private static Map<MethodKey, Method> _methods;
    private Object _adaptedObject;

    static {
        _methods = new HashMap<MethodKey, Method>();
    }

    public static ClassLoader getClassLoader() {
        if (_classLoader != null) {
            return _classLoader;
        }
        try {
            File coreDir = new File(PropsValues.LIFERAY_WEB_PORTAL_CONTEXT_TEMPDIR, "osgi");
            ModuleFrameworkAdapterHelper._initDir("com/liferay/portal/deploy/dependencies/osgi/core", coreDir.getAbsolutePath());
            ModuleFrameworkAdapterHelper._initDir("com/liferay/portal/deploy/dependencies/osgi/portal", PropsValues.MODULE_FRAMEWORK_PORTAL_DIR);
            File[] files = coreDir.listFiles();
            URL[] urls = new URL[files.length];
            int i2 = 0;
            while (i2 < urls.length) {
                urls[i2] = new URL("file", null, files[i2].getAbsolutePath());
                ++i2;
            }
            _classLoader = new ModuleFrameworkClassLoader(urls, ClassLoaderUtil.getPortalClassLoader());
            return _classLoader;
        }
        catch (Exception e2) {
            _log.error((Object)"Unable to configure the class loader for the module framework");
            throw new RuntimeException(e2);
        }
    }

    public ModuleFrameworkAdapterHelper(String className) {
        try {
            this._adaptedObject = InstanceFactory.newInstance((ClassLoader)ModuleFrameworkAdapterHelper.getClassLoader(), (String)className);
        }
        catch (Exception e2) {
            _log.error((Object)"Unable to load the module framework");
            throw new RuntimeException(e2);
        }
    }

    public Object exec(String methodName, Class<?>[] parameterTypes, Object ... parameters) {
        try {
            Method method = this.searchMethod(methodName, parameterTypes);
            return method.invoke(this._adaptedObject, parameters);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RuntimeException(e2);
        }
    }

    public Object execute(String methodName, Object ... parameters) {
        Class[] parameterTypes = ReflectionUtil.getParameterTypes((Object[])parameters);
        return this.exec(methodName, parameterTypes, parameters);
    }

    protected Method searchMethod(String methodName, Class<?>[] parameterTypes) throws Exception {
        MethodKey methodKey = new MethodKey(this._adaptedObject.getClass(), methodName, (Class[])parameterTypes);
        if (_methods.containsKey(methodKey)) {
            return _methods.get(methodKey);
        }
        Method method = ReflectionUtil.getDeclaredMethod(this._adaptedObject.getClass(), (String)methodName, (Class[])parameterTypes);
        _methods.put(methodKey, method);
        return method;
    }

    private static void _initDir(String sourcePath, String destinationPath) throws Exception {
        String[] jarFileNames;
        if (FileUtil.getFile() == null) {
            FileUtil fileUtil = new FileUtil();
            fileUtil.setFile((com.liferay.portal.kernel.util.File)DoPrivilegedUtil.wrap(new FileImpl()));
        }
        if (!FileUtil.exists((String)destinationPath)) {
            FileUtil.mkdirs((String)destinationPath);
        }
        ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
        URL url = classLoader.getResource(String.valueOf(sourcePath) + "/jars.txt");
        URLConnection urlConnection = url.openConnection();
        String[] stringArray = jarFileNames = StringUtil.split((String)StringUtil.read((InputStream)urlConnection.getInputStream()));
        int n = jarFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String jarFileName = stringArray[n2];
            File distinationFile = new File(destinationPath, jarFileName);
            if (distinationFile.lastModified() < urlConnection.getLastModified()) {
                byte[] bytes = FileUtil.getBytes((InputStream)classLoader.getResourceAsStream(String.valueOf(sourcePath) + "/" + jarFileName));
                FileUtil.write((File)distinationFile, (byte[])bytes);
            }
            ++n2;
        }
    }
}

