/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.Website;
import com.liferay.portal.model.WebsiteModel;
import com.liferay.portal.model.WebsiteSoap;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.model.impl.WebsiteCacheModel;
import com.liferay.portal.model.impl.WebsiteImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JSON(strict=true)
public class WebsiteModelImpl
extends BaseModelImpl<Website>
implements WebsiteModel {
    public static final String TABLE_NAME = "Website";
    public static final Object[][] TABLE_COLUMNS = new Object[][]{{"uuid_", 12}, {"websiteId", -5}, {"companyId", -5}, {"userId", -5}, {"userName", 12}, {"createDate", 93}, {"modifiedDate", 93}, {"classNameId", -5}, {"classPK", -5}, {"url", 12}, {"typeId", 4}, {"primary_", 16}};
    public static final String TABLE_SQL_CREATE = "create table Website (uuid_ VARCHAR(75) null,websiteId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,url STRING null,typeId INTEGER,primary_ BOOLEAN)";
    public static final String TABLE_SQL_DROP = "drop table Website";
    public static final String ORDER_BY_JPQL = " ORDER BY website.createDate ASC";
    public static final String ORDER_BY_SQL = " ORDER BY Website.createDate ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get("value.object.entity.cache.enabled.com.liferay.portal.model.Website"), (boolean)true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get("value.object.finder.cache.enabled.com.liferay.portal.model.Website"), (boolean)true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get("value.object.column.bitmask.enabled.com.liferay.portal.model.Website"), (boolean)true);
    public static long CLASSNAMEID_COLUMN_BITMASK = 1L;
    public static long CLASSPK_COLUMN_BITMASK = 2L;
    public static long COMPANYID_COLUMN_BITMASK = 4L;
    public static long PRIMARY_COLUMN_BITMASK = 8L;
    public static long USERID_COLUMN_BITMASK = 16L;
    public static long UUID_COLUMN_BITMASK = 32L;
    public static long CREATEDATE_COLUMN_BITMASK = 64L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong((String)PropsUtil.get("lock.expiration.time.com.liferay.portal.model.Website"));
    private static ClassLoader _classLoader = Website.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[]{Website.class};
    private String _uuid;
    private String _originalUuid;
    private long _websiteId;
    private long _companyId;
    private long _originalCompanyId;
    private boolean _setOriginalCompanyId;
    private long _userId;
    private String _userUuid;
    private long _originalUserId;
    private boolean _setOriginalUserId;
    private String _userName;
    private Date _createDate;
    private Date _modifiedDate;
    private long _classNameId;
    private long _originalClassNameId;
    private boolean _setOriginalClassNameId;
    private long _classPK;
    private long _originalClassPK;
    private boolean _setOriginalClassPK;
    private String _url;
    private int _typeId;
    private boolean _primary;
    private boolean _originalPrimary;
    private boolean _setOriginalPrimary;
    private long _columnBitmask;
    private Website _escapedModel;

    public static Website toModel(WebsiteSoap soapModel) {
        if (soapModel == null) {
            return null;
        }
        WebsiteImpl model = new WebsiteImpl();
        model.setUuid(soapModel.getUuid());
        model.setWebsiteId(soapModel.getWebsiteId());
        model.setCompanyId(soapModel.getCompanyId());
        model.setUserId(soapModel.getUserId());
        model.setUserName(soapModel.getUserName());
        model.setCreateDate(soapModel.getCreateDate());
        model.setModifiedDate(soapModel.getModifiedDate());
        model.setClassNameId(soapModel.getClassNameId());
        model.setClassPK(soapModel.getClassPK());
        model.setUrl(soapModel.getUrl());
        model.setTypeId(soapModel.getTypeId());
        model.setPrimary(soapModel.getPrimary());
        return model;
    }

    public static List<Website> toModels(WebsiteSoap[] soapModels) {
        if (soapModels == null) {
            return null;
        }
        ArrayList<Website> models = new ArrayList<Website>(soapModels.length);
        WebsiteSoap[] websiteSoapArray = soapModels;
        int n = soapModels.length;
        int n2 = 0;
        while (n2 < n) {
            WebsiteSoap soapModel = websiteSoapArray[n2];
            models.add(WebsiteModelImpl.toModel(soapModel));
            ++n2;
        }
        return models;
    }

    public long getPrimaryKey() {
        return this._websiteId;
    }

    public void setPrimaryKey(long primaryKey) {
        this.setWebsiteId(primaryKey);
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this._websiteId);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public Class<?> getModelClass() {
        return Website.class;
    }

    public String getModelClassName() {
        return Website.class.getName();
    }

    public Map<String, Object> getModelAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("uuid", this.getUuid());
        attributes.put("websiteId", this.getWebsiteId());
        attributes.put("companyId", this.getCompanyId());
        attributes.put("userId", this.getUserId());
        attributes.put("userName", this.getUserName());
        attributes.put("createDate", this.getCreateDate());
        attributes.put("modifiedDate", this.getModifiedDate());
        attributes.put("classNameId", this.getClassNameId());
        attributes.put("classPK", this.getClassPK());
        attributes.put("url", this.getUrl());
        attributes.put("typeId", this.getTypeId());
        attributes.put("primary", this.getPrimary());
        return attributes;
    }

    public void setModelAttributes(Map<String, Object> attributes) {
        Boolean primary;
        Integer typeId;
        String url;
        Long classPK;
        Long classNameId;
        Date modifiedDate;
        Date createDate;
        String userName;
        Long userId;
        Long companyId;
        Long websiteId;
        String uuid = (String)attributes.get("uuid");
        if (uuid != null) {
            this.setUuid(uuid);
        }
        if ((websiteId = (Long)attributes.get("websiteId")) != null) {
            this.setWebsiteId(websiteId);
        }
        if ((companyId = (Long)attributes.get("companyId")) != null) {
            this.setCompanyId(companyId);
        }
        if ((userId = (Long)attributes.get("userId")) != null) {
            this.setUserId(userId);
        }
        if ((userName = (String)attributes.get("userName")) != null) {
            this.setUserName(userName);
        }
        if ((createDate = (Date)attributes.get("createDate")) != null) {
            this.setCreateDate(createDate);
        }
        if ((modifiedDate = (Date)attributes.get("modifiedDate")) != null) {
            this.setModifiedDate(modifiedDate);
        }
        if ((classNameId = (Long)attributes.get("classNameId")) != null) {
            this.setClassNameId(classNameId);
        }
        if ((classPK = (Long)attributes.get("classPK")) != null) {
            this.setClassPK(classPK);
        }
        if ((url = (String)attributes.get("url")) != null) {
            this.setUrl(url);
        }
        if ((typeId = (Integer)attributes.get("typeId")) != null) {
            this.setTypeId(typeId);
        }
        if ((primary = (Boolean)attributes.get("primary")) != null) {
            this.setPrimary(primary);
        }
    }

    @JSON
    public String getUuid() {
        if (this._uuid == null) {
            return "";
        }
        return this._uuid;
    }

    public void setUuid(String uuid) {
        if (this._originalUuid == null) {
            this._originalUuid = this._uuid;
        }
        this._uuid = uuid;
    }

    public String getOriginalUuid() {
        return GetterUtil.getString((String)this._originalUuid);
    }

    @JSON
    public long getWebsiteId() {
        return this._websiteId;
    }

    public void setWebsiteId(long websiteId) {
        this._websiteId = websiteId;
    }

    @JSON
    public long getCompanyId() {
        return this._companyId;
    }

    public void setCompanyId(long companyId) {
        this._columnBitmask |= COMPANYID_COLUMN_BITMASK;
        if (!this._setOriginalCompanyId) {
            this._setOriginalCompanyId = true;
            this._originalCompanyId = this._companyId;
        }
        this._companyId = companyId;
    }

    public long getOriginalCompanyId() {
        return this._originalCompanyId;
    }

    @JSON
    public long getUserId() {
        return this._userId;
    }

    public void setUserId(long userId) {
        this._columnBitmask |= USERID_COLUMN_BITMASK;
        if (!this._setOriginalUserId) {
            this._setOriginalUserId = true;
            this._originalUserId = this._userId;
        }
        this._userId = userId;
    }

    public String getUserUuid() throws SystemException {
        return PortalUtil.getUserValue((long)this.getUserId(), (String)"uuid", (String)this._userUuid);
    }

    public void setUserUuid(String userUuid) {
        this._userUuid = userUuid;
    }

    public long getOriginalUserId() {
        return this._originalUserId;
    }

    @JSON
    public String getUserName() {
        if (this._userName == null) {
            return "";
        }
        return this._userName;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    @JSON
    public Date getCreateDate() {
        return this._createDate;
    }

    public void setCreateDate(Date createDate) {
        this._columnBitmask = -1L;
        this._createDate = createDate;
    }

    @JSON
    public Date getModifiedDate() {
        return this._modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this._modifiedDate = modifiedDate;
    }

    public String getClassName() {
        if (this.getClassNameId() <= 0L) {
            return "";
        }
        return PortalUtil.getClassName((long)this.getClassNameId());
    }

    public void setClassName(String className) {
        long classNameId = 0L;
        if (Validator.isNotNull((String)className)) {
            classNameId = PortalUtil.getClassNameId((String)className);
        }
        this.setClassNameId(classNameId);
    }

    @JSON
    public long getClassNameId() {
        return this._classNameId;
    }

    public void setClassNameId(long classNameId) {
        this._columnBitmask |= CLASSNAMEID_COLUMN_BITMASK;
        if (!this._setOriginalClassNameId) {
            this._setOriginalClassNameId = true;
            this._originalClassNameId = this._classNameId;
        }
        this._classNameId = classNameId;
    }

    public long getOriginalClassNameId() {
        return this._originalClassNameId;
    }

    @JSON
    public long getClassPK() {
        return this._classPK;
    }

    public void setClassPK(long classPK) {
        this._columnBitmask |= CLASSPK_COLUMN_BITMASK;
        if (!this._setOriginalClassPK) {
            this._setOriginalClassPK = true;
            this._originalClassPK = this._classPK;
        }
        this._classPK = classPK;
    }

    public long getOriginalClassPK() {
        return this._originalClassPK;
    }

    @JSON
    public String getUrl() {
        if (this._url == null) {
            return "";
        }
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    @JSON
    public int getTypeId() {
        return this._typeId;
    }

    public void setTypeId(int typeId) {
        this._typeId = typeId;
    }

    @JSON
    public boolean getPrimary() {
        return this._primary;
    }

    public boolean isPrimary() {
        return this._primary;
    }

    public void setPrimary(boolean primary) {
        this._columnBitmask |= PRIMARY_COLUMN_BITMASK;
        if (!this._setOriginalPrimary) {
            this._setOriginalPrimary = true;
            this._originalPrimary = this._primary;
        }
        this._primary = primary;
    }

    public boolean getOriginalPrimary() {
        return this._originalPrimary;
    }

    public long getColumnBitmask() {
        return this._columnBitmask;
    }

    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge((long)this.getCompanyId(), (String)Website.class.getName(), (long)this.getPrimaryKey());
    }

    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = this.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
    }

    public Website toEscapedModel() {
        if (this._escapedModel == null) {
            this._escapedModel = (Website)ProxyUtil.newProxyInstance((ClassLoader)_classLoader, (Class[])_escapedModelInterfaces, (InvocationHandler)new AutoEscapeBeanHandler((Object)this));
        }
        return this._escapedModel;
    }

    public Object clone() {
        WebsiteImpl websiteImpl = new WebsiteImpl();
        websiteImpl.setUuid(this.getUuid());
        websiteImpl.setWebsiteId(this.getWebsiteId());
        websiteImpl.setCompanyId(this.getCompanyId());
        websiteImpl.setUserId(this.getUserId());
        websiteImpl.setUserName(this.getUserName());
        websiteImpl.setCreateDate(this.getCreateDate());
        websiteImpl.setModifiedDate(this.getModifiedDate());
        websiteImpl.setClassNameId(this.getClassNameId());
        websiteImpl.setClassPK(this.getClassPK());
        websiteImpl.setUrl(this.getUrl());
        websiteImpl.setTypeId(this.getTypeId());
        websiteImpl.setPrimary(this.getPrimary());
        websiteImpl.resetOriginalValues();
        return websiteImpl;
    }

    public int compareTo(Website website) {
        int value = 0;
        value = DateUtil.compareTo((Date)this.getCreateDate(), (Date)website.getCreateDate());
        if (value != 0) {
            return value;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Website)) {
            return false;
        }
        Website website = (Website)obj;
        long primaryKey = website.getPrimaryKey();
        return this.getPrimaryKey() == primaryKey;
    }

    public int hashCode() {
        return (int)this.getPrimaryKey();
    }

    public void resetOriginalValues() {
        WebsiteModelImpl websiteModelImpl = this;
        websiteModelImpl._originalUuid = websiteModelImpl._uuid;
        websiteModelImpl._originalCompanyId = websiteModelImpl._companyId;
        websiteModelImpl._setOriginalCompanyId = false;
        websiteModelImpl._originalUserId = websiteModelImpl._userId;
        websiteModelImpl._setOriginalUserId = false;
        websiteModelImpl._originalClassNameId = websiteModelImpl._classNameId;
        websiteModelImpl._setOriginalClassNameId = false;
        websiteModelImpl._originalClassPK = websiteModelImpl._classPK;
        websiteModelImpl._setOriginalClassPK = false;
        websiteModelImpl._originalPrimary = websiteModelImpl._primary;
        websiteModelImpl._setOriginalPrimary = false;
        websiteModelImpl._columnBitmask = 0L;
    }

    public CacheModel<Website> toCacheModel() {
        Date createDate;
        WebsiteCacheModel websiteCacheModel = new WebsiteCacheModel();
        websiteCacheModel.uuid = this.getUuid();
        String uuid = websiteCacheModel.uuid;
        if (uuid != null && uuid.length() == 0) {
            websiteCacheModel.uuid = null;
        }
        websiteCacheModel.websiteId = this.getWebsiteId();
        websiteCacheModel.companyId = this.getCompanyId();
        websiteCacheModel.userId = this.getUserId();
        websiteCacheModel.userName = this.getUserName();
        String userName = websiteCacheModel.userName;
        if (userName != null && userName.length() == 0) {
            websiteCacheModel.userName = null;
        }
        websiteCacheModel.createDate = (createDate = this.getCreateDate()) != null ? createDate.getTime() : Long.MIN_VALUE;
        Date modifiedDate = this.getModifiedDate();
        websiteCacheModel.modifiedDate = modifiedDate != null ? modifiedDate.getTime() : Long.MIN_VALUE;
        websiteCacheModel.classNameId = this.getClassNameId();
        websiteCacheModel.classPK = this.getClassPK();
        websiteCacheModel.url = this.getUrl();
        String url = websiteCacheModel.url;
        if (url != null && url.length() == 0) {
            websiteCacheModel.url = null;
        }
        websiteCacheModel.typeId = this.getTypeId();
        websiteCacheModel.primary = this.getPrimary();
        return websiteCacheModel;
    }

    public String toString() {
        StringBundler sb = new StringBundler(25);
        sb.append("{uuid=");
        sb.append(this.getUuid());
        sb.append(", websiteId=");
        sb.append(this.getWebsiteId());
        sb.append(", companyId=");
        sb.append(this.getCompanyId());
        sb.append(", userId=");
        sb.append(this.getUserId());
        sb.append(", userName=");
        sb.append(this.getUserName());
        sb.append(", createDate=");
        sb.append((Object)this.getCreateDate());
        sb.append(", modifiedDate=");
        sb.append((Object)this.getModifiedDate());
        sb.append(", classNameId=");
        sb.append(this.getClassNameId());
        sb.append(", classPK=");
        sb.append(this.getClassPK());
        sb.append(", url=");
        sb.append(this.getUrl());
        sb.append(", typeId=");
        sb.append(this.getTypeId());
        sb.append(", primary=");
        sb.append(this.getPrimary());
        sb.append("}");
        return sb.toString();
    }

    public String toXmlString() {
        StringBundler sb = new StringBundler(40);
        sb.append("<model><model-name>");
        sb.append("com.liferay.portal.model.Website");
        sb.append("</model-name>");
        sb.append("<column><column-name>uuid</column-name><column-value><![CDATA[");
        sb.append(this.getUuid());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>websiteId</column-name><column-value><![CDATA[");
        sb.append(this.getWebsiteId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>companyId</column-name><column-value><![CDATA[");
        sb.append(this.getCompanyId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>userId</column-name><column-value><![CDATA[");
        sb.append(this.getUserId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>userName</column-name><column-value><![CDATA[");
        sb.append(this.getUserName());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>createDate</column-name><column-value><![CDATA[");
        sb.append((Object)this.getCreateDate());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
        sb.append((Object)this.getModifiedDate());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>classNameId</column-name><column-value><![CDATA[");
        sb.append(this.getClassNameId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>classPK</column-name><column-value><![CDATA[");
        sb.append(this.getClassPK());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>url</column-name><column-value><![CDATA[");
        sb.append(this.getUrl());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>typeId</column-name><column-value><![CDATA[");
        sb.append(this.getTypeId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>primary</column-name><column-value><![CDATA[");
        sb.append(this.getPrimary());
        sb.append("]]></column-value></column>");
        sb.append("</model>");
        return sb.toString();
    }
}

