/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.LayoutBranch;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.impl.LayoutRevisionBaseImpl;
import com.liferay.portal.service.LayoutBranchLocalServiceUtil;
import com.liferay.portal.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import java.util.List;
import java.util.Locale;

public class LayoutRevisionImpl
extends LayoutRevisionBaseImpl {
    private UnicodeProperties _typeSettingsProperties;

    public List<LayoutRevision> getChildren() throws SystemException {
        return LayoutRevisionLocalServiceUtil.getChildLayoutRevisions((long)this.getLayoutSetBranchId(), (long)this.getLayoutRevisionId(), (long)this.getPlid());
    }

    public ColorScheme getColorScheme() throws PortalException, SystemException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getColorScheme();
        }
        return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)this.getTheme().getThemeId(), (String)this.getColorSchemeId(), (boolean)false);
    }

    public String getCssText() throws PortalException, SystemException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getCss();
        }
        return this.getCss();
    }

    public String getHTMLTitle(Locale locale) {
        String localeLanguageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.getHTMLTitle(localeLanguageId);
    }

    public String getHTMLTitle(String localeLanguageId) {
        String htmlTitle = this.getTitle(localeLanguageId);
        if (Validator.isNull((String)htmlTitle)) {
            htmlTitle = this.getName(localeLanguageId);
        }
        return htmlTitle;
    }

    public LayoutBranch getLayoutBranch() throws PortalException, SystemException {
        return LayoutBranchLocalServiceUtil.getLayoutBranch((long)this.getLayoutBranchId());
    }

    public LayoutSet getLayoutSet() throws PortalException, SystemException {
        return LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroupId(), (boolean)this.isPrivateLayout());
    }

    public Theme getTheme() throws PortalException, SystemException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getTheme();
        }
        return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)this.getThemeId(), (boolean)false);
    }

    @Override
    public String getTypeSettings() {
        if (this._typeSettingsProperties == null) {
            return super.getTypeSettings();
        }
        return this._typeSettingsProperties.toString();
    }

    public UnicodeProperties getTypeSettingsProperties() {
        if (this._typeSettingsProperties == null) {
            this._typeSettingsProperties = new UnicodeProperties(true);
            this._typeSettingsProperties.fastLoad(super.getTypeSettings());
        }
        return this._typeSettingsProperties;
    }

    public ColorScheme getWapColorScheme() throws PortalException, SystemException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getWapColorScheme();
        }
        return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)this.getWapTheme().getThemeId(), (String)this.getWapColorSchemeId(), (boolean)true);
    }

    public Theme getWapTheme() throws PortalException, SystemException {
        if (this.isInheritWapLookAndFeel()) {
            return this.getLayoutSet().getWapTheme();
        }
        return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)this.getWapThemeId(), (boolean)true);
    }

    public boolean hasChildren() throws SystemException {
        return !this.getChildren().isEmpty();
    }

    public boolean isInheritLookAndFeel() {
        return Validator.isNull((String)this.getThemeId()) || Validator.isNull((String)this.getColorSchemeId());
    }

    public boolean isInheritWapLookAndFeel() {
        return Validator.isNull((String)this.getWapThemeId()) || Validator.isNull((String)this.getWapColorSchemeId());
    }

    @Override
    public void setTypeSettings(String typeSettings) {
        this._typeSettingsProperties = null;
        super.setTypeSettings(typeSettings);
    }

    public void setTypeSettingsProperties(UnicodeProperties typeSettingsProperties) {
        this._typeSettingsProperties = typeSettingsProperties;
        super.setTypeSettings(this._typeSettingsProperties.toString());
    }
}

