/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import com.liferay.portal.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;

public class LayoutListener
extends BaseModelListener<Layout> {
    public void onAfterCreate(Layout layout) {
        this.clearCache(layout);
    }

    public void onAfterRemove(Layout layout) {
        this.clearCache(layout);
    }

    public void onAfterUpdate(Layout layout) {
        this.clearCache(layout);
    }

    public void onBeforeRemove(Layout layout) throws ModelListenerException {
        try {
            if (!LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
                return;
            }
            LayoutRevisionLocalServiceUtil.deleteLayoutLayoutRevisions((long)layout.getPlid());
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (PortalException pe) {
            throw new ModelListenerException((Throwable)pe);
        }
        catch (SystemException se) {
            throw new ModelListenerException((Throwable)se);
        }
    }

    protected void clearCache(Layout layout) {
        if (!layout.isPrivateLayout()) {
            CacheUtil.clearCache(layout.getCompanyId());
        }
    }
}

